/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.queries;

import java.util.List;
import java.util.Locale;
import net.intelie.live.CriteriaSpecificationBase;
import net.intelie.live.InnerSpecification;
import net.intelie.live.model.Rule;
import net.intelie.live.model.SeverityLevel;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class AllRules
extends CriteriaSpecificationBase<Rule> {
    public AllRules() {
        super(Rule.class);
    }

    protected AllRules(InnerSpecification<Rule> spec) {
        super(spec);
    }

    public AllRules byName(String name) {
        return new AllRules(this.spec.where((Criterion)Restrictions.eq((String)"name", (Object)name)));
    }

    public AllRules byProvider(String provider) {
        return new AllRules(this.spec.where((Criterion)Restrictions.eq((String)"provider", (Object)provider)));
    }

    public AllRules query(String query) {
        if (query == null) {
            return this;
        }
        return new AllRules(this.spec.whereLike(query, "name", "description", "expression"));
    }

    public AllRules active() {
        return this.byStatus(true);
    }

    public AllRules byStatus(Boolean active) {
        return new AllRules(this.spec.where((Criterion)Restrictions.eq((String)"active", (Object)active)));
    }

    public AllRules inPerspective(Integer perspectiveId) {
        if (perspectiveId == null) {
            return this;
        }
        return new AllRules(this.spec.where((Criterion)Restrictions.eq((String)"perspective.id", (Object)perspectiveId)));
    }

    public AllRules inPerspectives(List<Integer> perspectiveIds) {
        return new AllRules(this.spec.where(Restrictions.in((String)"perspective.id", perspectiveIds)));
    }

    public AllRules severityGreaterThan(SeverityLevel severity) {
        if (severity == null) {
            return this;
        }
        return new AllRules(this.spec.where((Criterion)Restrictions.ge((String)"severity", (Object)severity)));
    }

    public AllRules severityGreaterThan(String severity) {
        SeverityLevel s;
        if (severity == null) {
            return this;
        }
        try {
            s = SeverityLevel.valueOf(severity.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return new AllRules(this.spec.where(Restrictions.not((Criterion)Restrictions.conjunction())));
        }
        return this.severityGreaterThan(s);
    }
}

