/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.intelie.live.util.SafeCloseable;
import net.intelie.pipes.util.Preconditions;

public class AutoList<T extends SafeCloseable>
implements SafeCloseable {
    private List<T> list;

    public AutoList() {
        this(new ArrayList());
    }

    public AutoList(int expectedSize) {
        this(new ArrayList(expectedSize));
    }

    public AutoList(List<T> list) {
        this.list = list;
    }

    public void add(T obj) {
        Preconditions.checkState((this.list != null ? 1 : 0) != 0, (Object)"AutoList already closed");
        this.list.add(obj);
    }

    public List<T> get() {
        return this.list;
    }

    public List<T> release() {
        List<T> tmp = this.list;
        this.list = null;
        return tmp;
    }

    @Override
    public void close() {
        List<T> list = this.release();
        if (list != null) {
            Iterator<T> iterator = list.iterator();
            try {
                while (iterator.hasNext()) {
                    ((SafeCloseable)iterator.next()).close();
                }
            }
            catch (Throwable primary) {
                while (iterator.hasNext()) {
                    try {
                        ((SafeCloseable)iterator.next()).close();
                    }
                    catch (Throwable suppressed) {
                        primary.addSuppressed(suppressed);
                    }
                }
                throw primary;
            }
        }
    }
}

