/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.intelie.live.EntityContext;
import net.intelie.live.model.Dashboard;
import net.intelie.live.model.User;
import net.intelie.live.util.UserVisibility;

public class CachedUserVisibility {
    private final EntityContext context;
    private final LoadingCache<UserDashboardIdPair, Boolean> userCanViewDashboard;

    public CachedUserVisibility(EntityContext context) {
        this(context, 1L, TimeUnit.MINUTES);
    }

    public CachedUserVisibility(EntityContext context, long duration, TimeUnit unit) {
        this.context = context;
        this.userCanViewDashboard = CacheBuilder.newBuilder().expireAfterWrite(duration, unit).build(CacheLoader.from(this::userCanViewDashboard));
    }

    public boolean userCanViewDashboard(int userId, int dashboardId) {
        return (Boolean)this.userCanViewDashboard.getUnchecked((Object)new UserDashboardIdPair(userId, dashboardId));
    }

    private boolean userCanViewDashboard(UserDashboardIdPair userDashboardIdPair) {
        return this.context.inTransaction(() -> {
            User user = this.context.get(User.class, Integer.valueOf(userDashboardIdPair.getUserId()));
            Dashboard dashboard = this.context.get(Dashboard.class, Integer.valueOf(userDashboardIdPair.getDashboardId()));
            if (user == null || dashboard == null) {
                return false;
            }
            return new UserVisibility(user).canView(dashboard);
        });
    }

    private static final class UserDashboardIdPair {
        private final int userId;
        private final int dashboardId;

        private UserDashboardIdPair(int userId, int dashboardId) {
            this.userId = userId;
            this.dashboardId = dashboardId;
        }

        public int getUserId() {
            return this.userId;
        }

        public int getDashboardId() {
            return this.dashboardId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserDashboardIdPair that = (UserDashboardIdPair)o;
            return this.userId == that.userId && this.dashboardId == that.dashboardId;
        }

        public int hashCode() {
            return Objects.hash(this.userId, this.dashboardId);
        }
    }
}

