/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import net.intelie.live.UserContext;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EntitiesAuditor
implements PostUpdateEventListener,
PostDeleteEventListener,
PostInsertEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntitiesAuditor.class);
    private final UserContext context;

    @Autowired
    public EntitiesAuditor(UserContext context) {
        this.context = context;
    }

    public void onPostDelete(PostDeleteEvent event) {
        this.record("deleted", event.getPersister(), event.getEntity());
    }

    public void onPostInsert(PostInsertEvent event) {
        this.record("created", event.getPersister(), event.getEntity());
    }

    public void onPostUpdate(PostUpdateEvent event) {
        this.record("updated", event.getPersister(), event.getEntity());
    }

    private void record(String action, EntityPersister persister, Object entity) {
        String username = this.context.currentUsername();
        Object entityDescription = this.getEntityDescription(persister, entity);
        String className = persister.getClassMetadata().getMappedClass().getSimpleName();
        Serializable id = persister.getIdentifier(entity, null);
        if (username != null) {
            LOGGER.info("{}#{} ({}) was {} by user '{}'", new Object[]{className, id, entityDescription, action, username});
        } else {
            LOGGER.info("{}#{} ({}) was {} by system", new Object[]{className, id, entityDescription, action});
        }
    }

    private Object getEntityDescription(EntityPersister persister, Object entity) {
        List<String> propertyNames = Arrays.asList(persister.getPropertyNames());
        Object entityName = null;
        if (propertyNames.contains("name")) {
            entityName = persister.getPropertyValue(entity, "name");
        } else if (propertyNames.contains("title")) {
            entityName = persister.getPropertyValue(entity, "title");
        }
        return entityName;
    }
}

