/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.util;

import net.intelie.live.Callback;
import net.intelie.live.SecurityContextFactory;
import net.intelie.live.util.EntityContextBase;
import net.intelie.pipes.time.Clock;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class EntityContextImpl
extends EntityContextBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityContextImpl.class);
    private final PlatformTransactionManager transactionManager;

    @Autowired
    public EntityContextImpl(SessionFactory factory, Clock clock, PlatformTransactionManager transactionManager, SecurityContextFactory security) {
        super(factory, clock, security);
        this.transactionManager = transactionManager;
    }

    @Override
    public <T, E extends Throwable> T inTransaction(Callback<T, E> callback) throws E {
        TransactionStatus tx = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            T result = callback.call();
            this.transactionManager.commit(tx);
            return result;
        }
        catch (Throwable e) {
            LOGGER.info("Rolling back transaction because of: {}", (Object)e.getMessage());
            LOGGER.debug("Stacktrace", e);
            this.tryRollback(tx);
            throw e;
        }
    }

    private void tryRollback(TransactionStatus tx) {
        try {
            this.transactionManager.rollback(tx);
        }
        catch (Throwable e) {
            LOGGER.warn("Failure rolling back", e);
        }
    }
}

