/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.util;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class PathUtils {
    private static final Pattern SLASHES = Pattern.compile("(?<!:)/+");

    public static int level(String a) {
        int i;
        int length = a.length();
        for (i = 0; i < length && a.charAt(i) == '/'; ++i) {
        }
        int count = 1;
        while (i < length) {
            if (a.charAt(i) == '/' && (i == 0 || a.charAt(i - 1) != '/')) {
                ++count;
            }
            ++i;
        }
        if (length == 0 || a.charAt(length - 1) == '/') {
            --count;
        }
        return count;
    }

    public static String last(String a) {
        int start;
        int end;
        for (end = a.length() - 1; end >= 0 && a.charAt(end) == '/'; --end) {
        }
        for (start = end; start >= 0 && a.charAt(start) != '/'; --start) {
        }
        return a.substring(start + 1, end + 1);
    }

    public static String fix(String a) {
        a = CharMatcher.anyOf((CharSequence)"/").trimFrom((CharSequence)a);
        a = SLASHES.matcher(a).replaceAll("/");
        return a;
    }

    public static List<String> parents(String a) {
        int index = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (index >= 0) {
            if ((index = a.indexOf(47, index + 1)) < 0 || index + 1 == a.length()) continue;
            list.add(a.substring(0, index + 1));
        }
        return Lists.reverse(list);
    }

    public static String fixFirst(String a) {
        boolean slashFirst = a.startsWith("/");
        return (slashFirst ? "/" : "") + PathUtils.fix(a);
    }

    public static String addSlash(String a) {
        if (a.endsWith("/")) {
            return a;
        }
        return a + "/";
    }

    public static String join(String a, String b) {
        return PathUtils.fixFirst(a) + "/" + PathUtils.fix(b);
    }
}

