/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.util;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import net.intelie.live.HtmlTag;
import net.intelie.live.Live;

public abstract class PluginUtils {
    public static final String CONTENT_DIR = "webcontent";

    public static void defaultWebSetup(Live live) throws Exception {
        ClassLoader loader = live.system().classloader();
        URL contentUrl = loader.getResource(CONTENT_DIR);
        if (contentUrl == null) {
            return;
        }
        live.web().addContent("", contentUrl);
        URL bundleUrl = loader.getResource("webcontent/bundle.js");
        if (bundleUrl == null) {
            return;
        }
        String resolved = live.web().resolveContent("bundle.js");
        if (bundleUrl.openConnection().getContentLength() < 65536) {
            live.web().addShortScript(Resources.toString((URL)bundleUrl, (Charset)Charsets.UTF_8), resolved);
        } else {
            live.web().addTag(HtmlTag.Position.BODY_END, new HtmlTag.JsFile(resolved));
        }
    }
}

