/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.util;

import com.google.common.base.Splitter;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class TimestampOverwriteMap
extends AbstractMap<String, Object>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> originalMap;
    private final Object oldtimestamp;
    private final boolean hasNewKey;
    private final Object timestamp;

    private static Object getField(Object value, String field) {
        if (value instanceof Map) {
            return ((Map)value).get(field);
        }
        return null;
    }

    public TimestampOverwriteMap(Map<String, Object> originalMap, String timestampHint) {
        this.originalMap = originalMap;
        this.hasNewKey = !originalMap.containsKey("__oldTimestamp");
        this.oldtimestamp = this.hasNewKey ? originalMap.get("timestamp") : originalMap.get("__oldTimestamp");
        this.timestamp = this.getTimestamp(originalMap, timestampHint);
    }

    @Nullable
    public Object getTimestamp(Map<String, Object> originalMap, String timestampHint) {
        Object value = originalMap;
        for (String field : Splitter.on((char)'.').split((CharSequence)timestampHint)) {
            value = TimestampOverwriteMap.getField(value, field);
        }
        return value;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new EntrySet();
    }

    @Override
    public Set<String> keySet() {
        return new KeySet();
    }

    @Override
    public int size() {
        return this.originalMap.keySet().size() + (this.hasNewKey ? 1 : 0);
    }

    @Override
    public Object get(Object key) {
        if ("__oldTimestamp".equals(key)) {
            return this.oldtimestamp;
        }
        if ("timestamp".equals(key)) {
            return this.timestamp;
        }
        return this.originalMap.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.originalMap.containsKey(key) || "__oldTimestamp".equals(key);
    }

    private class EntryIterator
    implements Iterator<Map.Entry<String, Object>> {
        private final Iterator<Map.Entry<String, Object>> it;
        private boolean first;

        private EntryIterator() {
            this.it = TimestampOverwriteMap.this.originalMap.entrySet().iterator();
            this.first = true;
        }

        @Override
        public boolean hasNext() {
            if (this.first && TimestampOverwriteMap.this.hasNewKey) {
                return true;
            }
            return this.it.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            Map.Entry<String, Object> e;
            if (this.first && TimestampOverwriteMap.this.hasNewKey) {
                this.first = false;
                e = new AbstractMap.SimpleImmutableEntry<String, Object>("__oldTimestamp", TimestampOverwriteMap.this.oldtimestamp);
            } else {
                e = this.it.next();
            }
            if ("timestamp".equals(e.getKey())) {
                return new AbstractMap.SimpleImmutableEntry<String, Object>("timestamp", TimestampOverwriteMap.this.timestamp);
            }
            if ("__oldTimestamp".equals(e.getKey())) {
                return new AbstractMap.SimpleImmutableEntry<String, Object>("__oldTimestamp", TimestampOverwriteMap.this.oldtimestamp);
            }
            return e;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return TimestampOverwriteMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if ("__oldTimestamp".equals(((Map.Entry)o).getKey())) {
                return Objects.equals(TimestampOverwriteMap.this.oldtimestamp, ((Map.Entry)o).getValue());
            }
            if ("timestamp".equals(((Map.Entry)o).getKey())) {
                return Objects.equals(TimestampOverwriteMap.this.timestamp, ((Map.Entry)o).getValue());
            }
            return TimestampOverwriteMap.this.originalMap.entrySet().contains(o);
        }
    }

    private class KeyIterator
    implements Iterator<String> {
        private final Iterator<String> it;
        private boolean first;

        private KeyIterator() {
            this.it = TimestampOverwriteMap.this.originalMap.keySet().iterator();
            this.first = true;
        }

        @Override
        public boolean hasNext() {
            if (this.first && TimestampOverwriteMap.this.hasNewKey) {
                return true;
            }
            return this.it.hasNext();
        }

        @Override
        public String next() {
            if (this.first && TimestampOverwriteMap.this.hasNewKey) {
                this.first = false;
                return "__oldTimestamp";
            }
            return this.it.next();
        }
    }

    private class KeySet
    extends AbstractSet<String> {
        private KeySet() {
        }

        @Override
        public Iterator<String> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return TimestampOverwriteMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return TimestampOverwriteMap.this.originalMap.keySet().contains(o) || TimestampOverwriteMap.this.hasNewKey && "__oldTimestamp".equals(o);
        }
    }
}

