/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live.util;

import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import net.intelie.live.model.HasPerspective;
import net.intelie.live.model.HasVisibilityStatus;
import net.intelie.live.model.Perspective;
import net.intelie.live.model.Role;
import net.intelie.live.model.User;
import net.intelie.live.model.UserGroup;
import net.intelie.live.model.VisibilityStatus;
import net.intelie.live.model.Widget;

public class UserVisibility {
    private final User user;
    private final Set<String> permissions = new HashSet<String>();
    private final Set<Perspective> perspectives = new HashSet<Perspective>();
    private final boolean allPerspectives;
    private boolean isAdmin;

    public UserVisibility(User user) {
        this.user = user;
        boolean allPerspectives = false;
        for (UserGroup group : user.getGroups()) {
            for (Role role : group.getRoles()) {
                for (String p : role.getPermissions()) {
                    this.permissions.add(p.toLowerCase(Locale.ROOT));
                }
            }
            this.perspectives.addAll(group.getPerspectives());
            allPerspectives = allPerspectives || Boolean.TRUE.equals(group.getAllPerspectivesAllowed());
        }
        this.allPerspectives = allPerspectives;
        this.isAdmin = user.isSuperuser() || this.permissions.contains("ADMIN".toLowerCase(Locale.ROOT));
    }

    public boolean hasPermission(String ... permissions) {
        if (this.isAdmin) {
            return true;
        }
        for (String i : this.permissions) {
            for (String j : permissions) {
                if (!i.equalsIgnoreCase(j)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canView(Object obj) {
        if (this.user.isSuperuser()) {
            return true;
        }
        if (obj instanceof Widget) {
            return this.canViewWidget((Widget)obj);
        }
        if (obj instanceof HasVisibilityStatus) {
            return this.canViewWithVisibility((HasVisibilityStatus)obj);
        }
        if (obj instanceof HasPerspective) {
            return this.canViewWithPerspective((HasPerspective)obj);
        }
        if (obj instanceof Perspective) {
            return this.canViewPerspective((Perspective)obj);
        }
        return true;
    }

    private boolean canViewWidget(Widget obj) {
        return this.canViewWithVisibility(obj.getDashboard());
    }

    private boolean canViewWithVisibility(HasVisibilityStatus entity) {
        VisibilityStatus visibility = entity.getVisibility();
        return visibility == VisibilityStatus.PUBLIC || visibility == VisibilityStatus.INTERNAL && this.canViewWithPerspective(entity) || visibility == VisibilityStatus.DRAFT && Objects.equals(this.user, entity.getAuthor());
    }

    private boolean canViewWithPerspective(HasPerspective entity) {
        return this.canViewPerspective(entity.getPerspective());
    }

    private boolean canViewPerspective(Perspective entity) {
        return this.isAdmin || this.allPerspectives || entity == null || this.perspectives.contains(entity);
    }
}

