/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.prowl.api;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import net.sourceforge.prowl.api.ProwlCommand;
import net.sourceforge.prowl.api.ProwlEvent;
import net.sourceforge.prowl.api.ProwlParameter;
import net.sourceforge.prowl.exception.ProwlException;
import net.sourceforge.prowl.url.DefaultProwlURLBuilder;
import net.sourceforge.prowl.url.ProwlResponseParser;
import net.sourceforge.prowl.url.ProwlURLBuilder;
import net.sourceforge.prowl.url.URLEncoder;

public class ProwlClient {
    private String providerKey;
    private ProwlResponseParser responseParser = new ProwlResponseParser();
    private Proxy proxy = null;
    private int connectionTimeout = 5000;
    private int readTimeout = 5000;

    public ProwlClient() {
    }

    public ProwlClient(int connectionTimeout, int readTimeout) {
        if (connectionTimeout > 0) {
            this.connectionTimeout = connectionTimeout;
        }
        if (readTimeout > 0) {
            this.readTimeout = readTimeout;
        }
    }

    public String pushEvent(ProwlEvent prowlEvent) throws ProwlException {
        if (prowlEvent == null || prowlEvent.getApiKey() == null || prowlEvent.getApplication() == null || prowlEvent.getDescription() == null || prowlEvent.getEvent() == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
        int priority = prowlEvent.getPriority();
        if (priority < -2 || priority > 2) {
            throw new IllegalArgumentException("The priority is out of range -2<x>2");
        }
        String apiKey = prowlEvent.getApiKey();
        String application = prowlEvent.getApplication();
        String event = prowlEvent.getEvent();
        String desc = prowlEvent.getDescription();
        String url = prowlEvent.getUrl();
        application = URLEncoder.escapeString(application);
        event = URLEncoder.escapeString(event);
        desc = URLEncoder.escapeString(desc);
        url = URLEncoder.escapeString(url);
        ProwlURLBuilder prowlUrl = DefaultProwlURLBuilder.createUrl().useCommand(ProwlCommand.add);
        prowlUrl.appendParam(ProwlParameter.apikey, apiKey);
        prowlUrl.appendParam(ProwlParameter.application, application);
        prowlUrl.appendParam(ProwlParameter.event, event);
        prowlUrl.appendParam(ProwlParameter.description, desc);
        prowlUrl.appendParam(ProwlParameter.priority, String.valueOf(priority));
        prowlUrl.appendParam(ProwlParameter.url, url);
        prowlUrl.appendParam(ProwlParameter.providerkey, this.providerKey);
        String finalUrl = prowlUrl.getURL();
        String response = this.sendPushNotification(finalUrl);
        return response;
    }

    protected String sendPushNotification(String url) throws ProwlException {
        try {
            URL requestURL = new URL(url);
            HttpURLConnection connection = null;
            connection = this.proxy == null ? (HttpURLConnection)requestURL.openConnection() : (HttpURLConnection)requestURL.openConnection(this.proxy);
            connection.setConnectTimeout(this.connectionTimeout);
            connection.setReadTimeout(this.readTimeout);
            String responseMessage = this.responseParser.getResponseMessage(connection);
            return responseMessage;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return e.getMessage();
        }
        catch (SocketTimeoutException ste) {
            ste.printStackTrace();
            return ste.getMessage();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return ioe.getMessage();
        }
    }

    public void setProxy(String type, String host, int port) {
        InetSocketAddress sa = new InetSocketAddress(host, port);
        if ("SOCKS".equalsIgnoreCase(type)) {
            this.proxy = new Proxy(Proxy.Type.SOCKS, sa);
        } else if ("HTTP".equalsIgnoreCase(type)) {
            this.proxy = new Proxy(Proxy.Type.HTTP, sa);
        } else {
            throw new IllegalArgumentException("Unknown proxy type");
        }
    }

    public void removeProxy() {
        this.proxy = null;
    }

    public void setProviderKey(String providerKey) {
        this.providerKey = providerKey;
    }

    public String getProviderKey() {
        return this.providerKey;
    }

    public String getProwlUrl() {
        return DefaultProwlURLBuilder.getProwlApiUrl();
    }

    public void setProwlUrl(String url) {
        DefaultProwlURLBuilder.setProwlApiUrl(url);
    }

    public boolean verifyApiKey(String apiKey) throws ProwlException {
        try {
            String prowlUrl = DefaultProwlURLBuilder.createUrl().useCommand(ProwlCommand.verify).appendParam(ProwlParameter.apikey, apiKey).getURL();
            this.sendPushNotification(prowlUrl);
        }
        catch (ProwlException e) {
            if (401 == e.getResponseCode()) {
                return false;
            }
            throw e;
        }
        return true;
    }
}

