/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.prowl.url;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.prowl.exception.ProwlException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProwlResponseParser {
    public String getResponseMessage(HttpURLConnection connection) throws ProwlException {
        if (connection == null) {
            throw new IllegalArgumentException("connection must not be null");
        }
        this.checkForErrors(connection);
        try {
            Node prowl;
            Node result;
            InputStream inputStream = connection.getInputStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            NodeList childNodes = document.getChildNodes();
            if (childNodes.getLength() > 0 && (result = (prowl = childNodes.item(0)).getFirstChild().getNextSibling()) != null) {
                NamedNodeMap attributes = result.getAttributes();
                if ("success".equalsIgnoreCase(result.getNodeName())) {
                    Node remaining = attributes.getNamedItem("remaining");
                    return "API call succeeded. " + remaining.getTextContent() + " api calls left.";
                }
                Node errorCode = attributes.getNamedItem("code");
                return "API call failed with code=" + errorCode.getTextContent() + ". " + result.getTextContent();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void checkForErrors(HttpURLConnection connection) throws ProwlException {
        try {
            int code = connection.getResponseCode();
            if (code == 400) {
                throw new ProwlException(code, "Bad request, the parameters you provided did not validate.");
            }
            if (code == 401) {
                throw new ProwlException(code, "The API key given is not valid, and does not correspond to a user.");
            }
            if (code == 405) {
                throw new ProwlException(code, "Method not allowed, you attempted to use a non-SSL connection to Prowl.");
            }
            if (code == 406) {
                throw new ProwlException(code, "Your IP address has exceeded the API limit.");
            }
            if (code == 500) {
                throw new ProwlException(code, "Internal server error, something failed to execute properly on the Prowl side.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

