/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.semantics;

import java.util.HashSet;
import java.util.List;
import org.antlr.v4.analysis.LeftRecursiveRuleTransformer;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Pair;
import org.antlr.v4.semantics.AttributeChecks;
import org.antlr.v4.semantics.BasicSemanticChecks;
import org.antlr.v4.semantics.RuleCollector;
import org.antlr.v4.semantics.SymbolChecks;
import org.antlr.v4.semantics.SymbolCollector;
import org.antlr.v4.semantics.UseDefAnalyzer;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.Rule;
import org.antlr.v4.tool.ast.GrammarAST;
import org.antlr.v4.tool.ast.RuleAST;

public class SemanticPipeline {
    public Grammar g;

    public SemanticPipeline(Grammar g) {
        this.g = g;
    }

    public void process() {
        if (this.g.ast == null) {
            return;
        }
        RuleCollector ruleCollector = new RuleCollector(this.g);
        ruleCollector.process(this.g.ast);
        BasicSemanticChecks basics = new BasicSemanticChecks(this.g, ruleCollector);
        basics.process();
        LeftRecursiveRuleTransformer lrtrans = new LeftRecursiveRuleTransformer(this.g.ast, ruleCollector.rules.values(), this.g);
        lrtrans.translateLeftRecursiveRules();
        for (Rule r : ruleCollector.rules.values()) {
            this.g.defineRule(r);
        }
        SymbolCollector collector = new SymbolCollector(this.g);
        collector.process(this.g.ast);
        SymbolChecks symcheck = new SymbolChecks(this.g, collector);
        symcheck.process();
        for (GrammarAST a : collector.namedActions) {
            this.g.defineAction(a);
        }
        for (Rule r : this.g.rules.values()) {
            for (int i = 1; i <= r.numberOfAlts; ++i) {
                r.alt[i].ast.alt = r.alt[i];
            }
        }
        this.g.importTokensFromTokensFile();
        if (this.g.isLexer()) {
            this.assignLexerTokenTypes(this.g, collector.tokensDefs);
        } else {
            this.assignTokenTypes(this.g, collector.tokensDefs, collector.tokenIDRefs, collector.terminals);
        }
        symcheck.checkRuleArgs(this.g, collector.rulerefs);
        this.identifyStartRules(collector);
        symcheck.checkForQualifiedRuleIssues(this.g, collector.qualifiedRulerefs);
        if (this.g.tool.getNumErrors() > 0) {
            return;
        }
        AttributeChecks.checkAllAttributeExpressions(this.g);
        UseDefAnalyzer.trackTokenRuleRefsInActions(this.g);
    }

    void identifyStartRules(SymbolCollector collector) {
        for (GrammarAST ref : collector.rulerefs) {
            String ruleName = ref.getText();
            Rule r = this.g.getRule(ruleName);
            if (r == null) continue;
            r.isStartRule = false;
        }
    }

    void assignLexerTokenTypes(Grammar g, List<GrammarAST> tokensDefs) {
        Grammar G = g.getOutermostGrammar();
        for (GrammarAST def : tokensDefs) {
            if (!Grammar.isTokenName(def.getText())) continue;
            G.defineTokenName(def.getText());
        }
        for (Rule r : g.rules.values()) {
            if (r.isFragment() || this.hasTypeOrMoreCommand(r)) continue;
            G.defineTokenName(r.name);
        }
        List<Pair<GrammarAST, GrammarAST>> litAliases = Grammar.getStringLiteralAliasesFromLexerRules(g.ast);
        HashSet<String> conflictingLiterals = new HashSet<String>();
        if (litAliases != null) {
            for (Pair<GrammarAST, GrammarAST> pair : litAliases) {
                GrammarAST nameAST = (GrammarAST)((Object)pair.a);
                GrammarAST litAST = (GrammarAST)((Object)pair.b);
                if (!G.stringLiteralToTypeMap.containsKey(litAST.getText())) {
                    G.defineTokenAlias(nameAST.getText(), litAST.getText());
                    continue;
                }
                conflictingLiterals.add(litAST.getText());
            }
            for (String lit : conflictingLiterals) {
                G.stringLiteralToTypeMap.remove(lit);
            }
        }
    }

    boolean hasTypeOrMoreCommand(@NotNull Rule r) {
        RuleAST ast = r.ast;
        if (ast == null) {
            return false;
        }
        GrammarAST altActionAst = (GrammarAST)ast.getFirstDescendantWithType(85);
        if (altActionAst == null) {
            return false;
        }
        for (int i = 1; i < altActionAst.getChildCount(); ++i) {
            GrammarAST node = (GrammarAST)altActionAst.getChild(i);
            if (!(node.getType() == 84 ? "type".equals(node.getChild(0).getText()) : "more".equals(node.getText()))) continue;
            return true;
        }
        return false;
    }

    void assignTokenTypes(Grammar g, List<GrammarAST> tokensDefs, List<GrammarAST> tokenIDs, List<GrammarAST> terminals) {
        for (GrammarAST alias : tokensDefs) {
            if (g.getTokenType(alias.getText()) != 0) {
                g.tool.errMgr.grammarError(ErrorType.TOKEN_NAME_REASSIGNMENT, g.fileName, alias.token, alias.getText());
            }
            g.defineTokenName(alias.getText());
        }
        for (GrammarAST idAST : tokenIDs) {
            if (g.getTokenType(idAST.getText()) == 0) {
                g.tool.errMgr.grammarError(ErrorType.IMPLICIT_TOKEN_DEFINITION, g.fileName, idAST.token, idAST.getText());
            }
            g.defineTokenName(idAST.getText());
        }
        for (GrammarAST termAST : terminals) {
            if (termAST.getType() != 61 || g.getTokenType(termAST.getText()) != 0) continue;
            g.tool.errMgr.grammarError(ErrorType.IMPLICIT_STRING_DEFINITION, g.fileName, termAST.token, termAST.getText());
        }
        g.tool.log("semantics", "tokens=" + g.tokenNameToTypeMap);
        g.tool.log("semantics", "strings=" + g.stringLiteralToTypeMap);
    }
}

