/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.net.URI;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.AbstractSamlBase64InHandler;

public class SamlFormInHandler
extends AbstractSamlBase64InHandler {
    private static final String SAML_ELEMENT = "SAMLToken";
    private static final String SAML_RELAY_STATE = "RelayState";
    private FormEncodingProvider<Form> provider = new FormEncodingProvider(true);

    public void filter(ContainerRequestContext context) {
        UriInfoImpl ui;
        Message message = JAXRSUtils.getCurrentMessage();
        Form form = this.readFormData(message);
        MultivaluedMap formData = form.asMap();
        String assertion = (String)formData.getFirst((Object)SAML_ELEMENT);
        this.handleToken(message, assertion);
        String samlRequestURI = (String)formData.getFirst((Object)SAML_RELAY_STATE);
        if (samlRequestURI != null && !samlRequestURI.startsWith((ui = new UriInfoImpl(message)).getBaseUri().toString())) {
            context.abortWith(Response.status((int)302).location(URI.create(samlRequestURI)).build());
            return;
        }
        formData.remove((Object)SAML_ELEMENT);
        formData.remove((Object)SAML_RELAY_STATE);
        try {
            FormUtils.restoreForm(this.provider, form, message);
        }
        catch (Exception ex) {
            this.throwFault(ex.getMessage(), ex);
        }
    }

    private Form readFormData(Message message) {
        try {
            return FormUtils.readForm(this.provider, message);
        }
        catch (Exception ex) {
            this.throwFault("Error reading the form", ex);
            return null;
        }
    }
}

