/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptorProvider;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.SecurityConstants;
import org.apache.cxf.ws.security.policy.interceptors.NegotiationUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.trust.STSUtils;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JStaxInInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JStaxOutInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.cxf.ws.security.wss4j.policyvalidators.IssuedTokenPolicyValidator;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.policy.SP11Constants;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.model.IssuedToken;
import org.apache.wss4j.policy.model.Trust10;
import org.apache.wss4j.policy.model.Trust13;
import org.w3c.dom.Element;

public class IssuedTokenInterceptorProvider
extends AbstractPolicyInterceptorProvider {
    private static final long serialVersionUID = -6936475570762840527L;
    private static final String ASSOCIATED_TOKEN = IssuedTokenInterceptorProvider.class.getName() + "-" + "Associated_Token";

    public IssuedTokenInterceptorProvider() {
        super(Arrays.asList(SP11Constants.ISSUED_TOKEN, SP12Constants.ISSUED_TOKEN));
        this.getOutInterceptors().add(PolicyBasedWSS4JOutInterceptor.INSTANCE);
        this.getOutFaultInterceptors().add(PolicyBasedWSS4JOutInterceptor.INSTANCE);
        this.getInInterceptors().add(PolicyBasedWSS4JInInterceptor.INSTANCE);
        this.getInFaultInterceptors().add(PolicyBasedWSS4JInInterceptor.INSTANCE);
        this.getOutInterceptors().add(new IssuedTokenOutInterceptor());
        this.getOutFaultInterceptors().add(new IssuedTokenOutInterceptor());
        this.getInInterceptors().add(new IssuedTokenInInterceptor());
        this.getInFaultInterceptors().add(new IssuedTokenInInterceptor());
        this.getOutInterceptors().add(PolicyBasedWSS4JStaxOutInterceptor.INSTANCE);
        this.getOutFaultInterceptors().add(PolicyBasedWSS4JStaxOutInterceptor.INSTANCE);
        this.getInInterceptors().add(PolicyBasedWSS4JStaxInInterceptor.INSTANCE);
        this.getInFaultInterceptors().add(PolicyBasedWSS4JStaxInInterceptor.INSTANCE);
    }

    protected static void assertIssuedToken(IssuedToken issuedToken, AssertionInfoMap aim) {
        if (issuedToken == null) {
            return;
        }
        if (issuedToken.isRequireExternalReference()) {
            IssuedTokenInterceptorProvider.assertPolicy(new QName(issuedToken.getName().getNamespaceURI(), "RequireExternalReference"), aim);
        }
        if (issuedToken.isRequireInternalReference()) {
            IssuedTokenInterceptorProvider.assertPolicy(new QName(issuedToken.getName().getNamespaceURI(), "RequireInternalReference"), aim);
        }
    }

    protected static void assertPolicy(QName n, AssertionInfoMap aim) {
        Collection<AssertionInfo> ais = aim.getAssertionInfo(n);
        if (ais != null && !ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
        }
    }

    static class IssuedTokenInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public IssuedTokenInInterceptor() {
            super("pre-protocol");
            this.addAfter(WSS4JInInterceptor.class.getName());
            this.addAfter(PolicyBasedWSS4JInInterceptor.class.getName());
        }

        @Override
        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = message.get(AssertionInfoMap.class);
            if (aim != null) {
                List results;
                Collection<AssertionInfo> ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "IssuedToken");
                if (ais.isEmpty()) {
                    return;
                }
                for (AssertionInfo ai : ais) {
                    ai.setAsserted(true);
                }
                IssuedToken itok = (IssuedToken)ais.iterator().next().getAssertion();
                IssuedTokenInterceptorProvider.assertIssuedToken(itok, aim);
                if (!this.isRequestor(message) && (results = CastUtils.cast((List)message.get("RECV_RESULTS"))) != null && results.size() > 0) {
                    this.parseHandlerResults((WSHandlerResult)results.get(0), message, aim);
                }
            }
        }

        private void parseHandlerResults(WSHandlerResult rResult, Message message, AssertionInfoMap aim) {
            boolean valid;
            List signedResults = WSSecurityUtil.fetchAllActionResults((List)rResult.getResults(), (int)2);
            IssuedTokenPolicyValidator issuedValidator = new IssuedTokenPolicyValidator(signedResults, message);
            Collection<AssertionInfo> issuedAis = NegotiationUtils.getAllAssertionsByLocalname(aim, "IssuedToken");
            for (SamlAssertionWrapper assertionWrapper : this.findSamlTokenResults(rResult.getResults())) {
                valid = issuedValidator.validatePolicy(issuedAis, assertionWrapper);
                if (!valid) continue;
                SecurityToken token = this.createSecurityToken(assertionWrapper);
                WSS4JUtils.getTokenStore(message).add(token);
                message.getExchange().remove("ws-security.token");
                message.getExchange().put("ws-security.token.id", token.getId());
                return;
            }
            for (BinarySecurity binarySecurityToken : this.findBinarySecurityTokenResults(rResult.getResults())) {
                valid = issuedValidator.validatePolicy(issuedAis, binarySecurityToken);
                if (!valid) continue;
                SecurityToken token = this.createSecurityToken(binarySecurityToken);
                WSS4JUtils.getTokenStore(message).add(token);
                message.getExchange().remove("ws-security.token");
                message.getExchange().put("ws-security.token.id", token.getId());
                return;
            }
        }

        private List<SamlAssertionWrapper> findSamlTokenResults(List<WSSecurityEngineResult> wsSecEngineResults) {
            ArrayList<SamlAssertionWrapper> results = new ArrayList<SamlAssertionWrapper>();
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 16 && actInt != 8) continue;
                results.add((SamlAssertionWrapper)wser.get((Object)"saml-assertion"));
            }
            return results;
        }

        private List<BinarySecurity> findBinarySecurityTokenResults(List<WSSecurityEngineResult> wsSecEngineResults) {
            ArrayList<BinarySecurity> results = new ArrayList<BinarySecurity>();
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 4096 || !Boolean.TRUE.equals(wser.get((Object)"validated-token"))) continue;
                results.add((BinarySecurity)wser.get((Object)"binary-security-token"));
            }
            return results;
        }

        private SecurityToken createSecurityToken(SamlAssertionWrapper assertionWrapper) {
            SecurityToken token = new SecurityToken(assertionWrapper.getId());
            SAMLKeyInfo subjectKeyInfo = assertionWrapper.getSubjectKeyInfo();
            if (subjectKeyInfo != null) {
                token.setSecret(subjectKeyInfo.getSecret());
                X509Certificate[] certs = subjectKeyInfo.getCerts();
                if (certs != null && certs.length > 0) {
                    token.setX509Certificate(certs[0], null);
                }
            }
            if (assertionWrapper.getSaml1() != null) {
                token.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            } else if (assertionWrapper.getSaml2() != null) {
                token.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            }
            token.setToken(assertionWrapper.getElement());
            return token;
        }

        private SecurityToken createSecurityToken(BinarySecurity binarySecurityToken) {
            SecurityToken token = new SecurityToken(binarySecurityToken.getID());
            token.setToken(binarySecurityToken.getElement());
            token.setSecret(binarySecurityToken.getToken());
            token.setTokenType(binarySecurityToken.getValueType());
            return token;
        }
    }

    static class IssuedTokenOutInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public IssuedTokenOutInterceptor() {
            super("prepare-send");
        }

        private static void mapSecurityProps(Message message, Map<String, Object> ctx) {
            for (String s : SecurityConstants.ALL_PROPERTIES) {
                Object v = message.getContextualProperty(s + ".it");
                if (v == null) {
                    v = message.getContextualProperty(s);
                }
                if (ctx.containsKey(s) || v == null) continue;
                ctx.put(s, v);
            }
        }

        @Override
        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection<AssertionInfo> ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "IssuedToken");
                if (ais.isEmpty()) {
                    return;
                }
                if (this.isRequestor(message)) {
                    IssuedToken itok = (IssuedToken)ais.iterator().next().getAssertion();
                    IssuedTokenInterceptorProvider.assertIssuedToken(itok, aim);
                    SecurityToken tok = this.retrieveCachedToken(message);
                    tok = tok == null ? this.issueToken(message, aim, itok) : this.renewToken(message, aim, itok, tok);
                    if (tok != null) {
                        boolean cacheIssuedToken;
                        for (AssertionInfo ai : ais) {
                            ai.setAsserted(true);
                        }
                        boolean bl = cacheIssuedToken = MessageUtils.getContextualBoolean(message, "ws-security.cache.issued.token.in.endpoint", true) && !this.isOneTimeUse(tok);
                        if (cacheIssuedToken) {
                            message.getExchange().get(Endpoint.class).put("ws-security.token", tok);
                            message.getExchange().put("ws-security.token", tok);
                            message.getExchange().put("ws-security.token.id", tok.getId());
                            message.getExchange().get(Endpoint.class).put("ws-security.token.id", tok.getId());
                        } else {
                            message.put("ws-security.token", tok);
                            message.put("ws-security.token.id", tok.getId());
                        }
                        WSS4JUtils.getTokenStore(message).add(tok);
                    }
                } else {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                    IssuedToken itok = (IssuedToken)ais.iterator().next().getAssertion();
                    IssuedTokenInterceptorProvider.assertIssuedToken(itok, aim);
                }
            }
        }

        private Trust10 getTrust10(AssertionInfoMap aim) {
            Collection<AssertionInfo> ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "Trust10");
            if (ais.isEmpty()) {
                return null;
            }
            return (Trust10)ais.iterator().next().getAssertion();
        }

        private Trust13 getTrust13(AssertionInfoMap aim) {
            Collection<AssertionInfo> ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "Trust13");
            if (ais.isEmpty()) {
                return null;
            }
            return (Trust13)ais.iterator().next().getAssertion();
        }

        private boolean isOneTimeUse(SecurityToken issuedToken) {
            Element token = issuedToken.getToken();
            if (token != null && "Assertion".equals(token.getLocalName()) && "urn:oasis:names:tc:SAML:2.0:assertion".equals(token.getNamespaceURI())) {
                try {
                    SamlAssertionWrapper assertion = new SamlAssertionWrapper(token);
                    if (assertion.getSaml2().getConditions() != null && assertion.getSaml2().getConditions().getOneTimeUse() != null) {
                        return true;
                    }
                }
                catch (WSSecurityException ex) {
                    throw new Fault(ex);
                }
            }
            return false;
        }

        private SecurityToken retrieveCachedToken(Message message) {
            boolean cacheIssuedToken = MessageUtils.getContextualBoolean(message, "ws-security.cache.issued.token.in.endpoint", true);
            SecurityToken tok = null;
            if (cacheIssuedToken) {
                String tokId;
                tok = (SecurityToken)message.getContextualProperty("ws-security.token");
                if (tok == null && (tokId = (String)message.getContextualProperty("ws-security.token.id")) != null) {
                    tok = WSS4JUtils.getTokenStore(message).getToken(tokId);
                }
            } else {
                String tokId;
                tok = (SecurityToken)message.get("ws-security.token");
                if (tok == null && (tokId = (String)message.get("ws-security.token.id")) != null) {
                    tok = WSS4JUtils.getTokenStore(message).getToken(tokId);
                }
            }
            return tok;
        }

        private SecurityToken handleDelegation(Message message, Element onBehalfOfToken, Element actAsToken, String appliesTo, boolean enableAppliesTo) throws Exception {
            String associatedToken;
            SecurityToken issuedToken;
            Properties properties;
            String id;
            SecurityToken cachedToken;
            TokenStore tokenStore = WSS4JUtils.getTokenStore(message);
            String key = appliesTo;
            if (!enableAppliesTo || key == null || "".equals(key)) {
                key = ASSOCIATED_TOKEN;
            }
            if (onBehalfOfToken != null && (cachedToken = tokenStore.getToken(id = this.getIdFromToken(onBehalfOfToken))) != null && (properties = cachedToken.getProperties()) != null && properties.containsKey(key) && (issuedToken = tokenStore.getToken(associatedToken = properties.getProperty(key))) != null) {
                return issuedToken;
            }
            if (actAsToken != null && (cachedToken = tokenStore.getToken(id = this.getIdFromToken(actAsToken))) != null && (properties = cachedToken.getProperties()) != null && properties.containsKey(key) && (issuedToken = tokenStore.getToken(associatedToken = properties.getProperty(key))) != null) {
                return issuedToken;
            }
            return null;
        }

        private String getIdFromToken(Element token) {
            if (token != null) {
                if (token.hasAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")) {
                    return token.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                }
                if (token.hasAttributeNS(null, "ID")) {
                    return token.getAttributeNS(null, "ID");
                }
                if (token.hasAttributeNS(null, "AssertionID")) {
                    return token.getAttributeNS(null, "AssertionID");
                }
            }
            return "";
        }

        private void storeDelegationTokens(Message message, SecurityToken issuedToken, Element onBehalfOfToken, Element actAsToken, String appliesTo, boolean enableAppliesTo) throws Exception {
            Properties properties;
            SecurityToken cachedToken;
            String id;
            if (issuedToken == null) {
                return;
            }
            TokenStore tokenStore = WSS4JUtils.getTokenStore(message);
            String key = appliesTo;
            if (!enableAppliesTo || key == null || "".equals(key)) {
                key = ASSOCIATED_TOKEN;
            }
            if (onBehalfOfToken != null) {
                id = this.getIdFromToken(onBehalfOfToken);
                cachedToken = tokenStore.getToken(id);
                if (cachedToken == null) {
                    cachedToken = new SecurityToken(id);
                    cachedToken.setToken(onBehalfOfToken);
                }
                if ((properties = cachedToken.getProperties()) == null) {
                    properties = new Properties();
                    cachedToken.setProperties(properties);
                }
                properties.put(key, issuedToken.getId());
                tokenStore.add(cachedToken);
            }
            if (actAsToken != null) {
                id = this.getIdFromToken(actAsToken);
                cachedToken = tokenStore.getToken(id);
                if (cachedToken == null) {
                    cachedToken = new SecurityToken(id);
                    cachedToken.setToken(actAsToken);
                }
                if ((properties = cachedToken.getProperties()) == null) {
                    properties = new Properties();
                    cachedToken.setProperties(properties);
                }
                properties.put(key, issuedToken.getId());
                tokenStore.add(cachedToken);
            }
        }

        private SecurityToken getTokenFromSTS(Message message, STSClient client, AssertionInfoMap aim, AddressingProperties maps, IssuedToken itok, String appliesTo) throws Exception {
            client.setTrust(this.getTrust10(aim));
            client.setTrust(this.getTrust13(aim));
            client.setTemplate(itok.getRequestSecurityTokenTemplate());
            if (itok.getPolicy() != null && itok.getPolicy().getNamespace() != null) {
                client.setWspNamespace(itok.getPolicy().getNamespace());
            }
            if (maps != null && maps.getNamespaceURI() != null) {
                client.setAddressingNamespace(maps.getNamespaceURI());
            }
            if (itok.getClaims() != null) {
                client.setClaims(itok.getClaims());
            }
            return client.requestSecurityToken(appliesTo);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private SecurityToken renewToken(Message message, AssertionInfoMap aim, IssuedToken itok, SecurityToken tok) {
            if (!tok.isExpired()) {
                return tok;
            }
            message.getExchange().get(Endpoint.class).remove("ws-security.token");
            message.getExchange().get(Endpoint.class).remove("ws-security.token.id");
            message.getExchange().remove("ws-security.token.id");
            message.getExchange().remove("ws-security.token");
            NegotiationUtils.getTokenStore(message).remove(tok.getId());
            STSClient client = STSUtils.getClient(message, "sts", itok);
            if (!client.isAllowRenewing()) {
                return this.issueToken(message, aim, itok);
            }
            AddressingProperties maps = (AddressingProperties)message.get("javax.xml.ws.addressing.context.outbound");
            if (maps == null) {
                maps = (AddressingProperties)message.get("javax.xml.ws.addressing.context");
            }
            STSClient sTSClient = client;
            synchronized (sTSClient) {
                try {
                    Map<String, Object> ctx = client.getRequestContext();
                    IssuedTokenOutInterceptor.mapSecurityProps(message, ctx);
                    client.setMessage(message);
                    if (maps != null) {
                        client.setAddressingNamespace(maps.getNamespaceURI());
                    }
                    client.setTrust(this.getTrust10(aim));
                    client.setTrust(this.getTrust13(aim));
                    client.setTemplate(itok.getRequestSecurityTokenTemplate());
                    SecurityToken securityToken = client.renewSecurityToken(tok);
                    return securityToken;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new Fault(e);
                }
                finally {
                    client.setTrust((Trust10)null);
                    client.setTrust((Trust13)null);
                    client.setTemplate(null);
                    client.setAddressingNamespace(null);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private SecurityToken issueToken(Message message, AssertionInfoMap aim, IssuedToken itok) {
            STSClient client = STSUtils.getClient(message, "sts", itok);
            AddressingProperties maps = (AddressingProperties)message.get("javax.xml.ws.addressing.context.outbound");
            if (maps == null) {
                maps = (AddressingProperties)message.get("javax.xml.ws.addressing.context");
            }
            STSClient sTSClient = client;
            synchronized (sTSClient) {
                try {
                    Object token = message.getContextualProperty("ws-security.sts.token.act-as");
                    if (token != null) {
                        client.setActAs(token);
                    }
                    if ((token = message.getContextualProperty("ws-security.sts.token.on-behalf-of")) != null) {
                        client.setOnBehalfOf(token);
                    }
                    Map<String, Object> ctx = client.getRequestContext();
                    IssuedTokenOutInterceptor.mapSecurityProps(message, ctx);
                    Object o = message.getContextualProperty("ws-security.sts.applies-to");
                    String appliesTo = o == null ? null : o.toString();
                    appliesTo = appliesTo == null ? message.getContextualProperty(Message.ENDPOINT_ADDRESS).toString() : appliesTo;
                    boolean enableAppliesTo = client.isEnableAppliesTo();
                    client.setMessage(message);
                    Element onBehalfOfToken = client.getOnBehalfOfToken();
                    Element actAsToken = client.getActAsToken();
                    SecurityToken secToken = this.handleDelegation(message, onBehalfOfToken, actAsToken, appliesTo, enableAppliesTo);
                    if (secToken == null) {
                        secToken = this.getTokenFromSTS(message, client, aim, maps, itok, appliesTo);
                    }
                    this.storeDelegationTokens(message, secToken, onBehalfOfToken, actAsToken, appliesTo, enableAppliesTo);
                    SecurityToken securityToken = secToken;
                    return securityToken;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new Fault(e);
                }
                finally {
                    client.setTrust((Trust10)null);
                    client.setTrust((Trust13)null);
                    client.setTemplate(null);
                    client.setAddressingNamespace(null);
                }
            }
        }
    }
}

