/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.interceptor.security.RolePrefixSecurityContextImpl;
import org.apache.cxf.interceptor.security.SAMLSecurityContext;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.ws.security.wss4j.SAMLUtils;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.CustomTokenPrincipal;
import org.apache.wss4j.common.principal.WSDerivedKeyTokenPrincipal;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.stax.securityEvent.KerberosTokenSecurityEvent;
import org.apache.wss4j.stax.securityEvent.KeyValueTokenSecurityEvent;
import org.apache.wss4j.stax.securityEvent.SamlTokenSecurityEvent;
import org.apache.wss4j.stax.securityEvent.UsernameTokenSecurityEvent;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.wss4j.stax.securityEvent.X509TokenSecurityEvent;
import org.apache.wss4j.stax.securityToken.SubjectAndPrincipalSecurityToken;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;

public class StaxSecurityContextInInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public static final String SAML_ROLE_ATTRIBUTENAME_DEFAULT = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role";

    public StaxSecurityContextInInterceptor() {
        super("pre-protocol");
    }

    @Override
    public void handleMessage(SoapMessage soapMessage) throws Fault {
        List incomingSecurityEventList = (List)soapMessage.get(SecurityEvent.class.getName() + ".in");
        if (incomingSecurityEventList != null) {
            try {
                this.doResults(soapMessage, incomingSecurityEventList);
            }
            catch (WSSecurityException e) {
                throw this.createSoapFault(soapMessage.getVersion(), e);
            }
        }
    }

    private void doResults(SoapMessage msg, List<SecurityEvent> incomingSecurityEventList) throws WSSecurityException {
        for (SecurityEvent event : incomingSecurityEventList) {
            SubjectAndPrincipalSecurityToken token = this.getSubjectPrincipalToken(event);
            if (token == null) continue;
            Principal p = token.getPrincipal();
            Subject subject = token.getSubject();
            if (subject != null) {
                String roleClassifier = (String)msg.getContextualProperty("ws-security.role.classifier");
                if (roleClassifier != null && !"".equals(roleClassifier)) {
                    String roleClassifierType = (String)msg.getContextualProperty("ws-security.role.classifier.type");
                    if (roleClassifierType == null || "".equals(roleClassifierType)) {
                        roleClassifierType = "prefix";
                    }
                    msg.put(SecurityContext.class, new RolePrefixSecurityContextImpl(subject, roleClassifier, roleClassifierType));
                    break;
                }
                msg.put(SecurityContext.class, new DefaultSecurityContext(subject));
                break;
            }
            if (p == null || !this.isSecurityContextPrincipal(p, incomingSecurityEventList)) continue;
            SamlAssertionWrapper receivedAssertion = null;
            List<String> roles = null;
            if (event.getSecurityEventType() == WSSecurityEventConstants.SamlToken) {
                SamlTokenSecurityEvent samlEvent;
                String roleAttributeName = (String)msg.getContextualProperty("ws-security.saml-role-attributename");
                if (roleAttributeName == null || roleAttributeName.length() == 0) {
                    roleAttributeName = SAML_ROLE_ATTRIBUTENAME_DEFAULT;
                }
                if ((receivedAssertion = (samlEvent = (SamlTokenSecurityEvent)event).getSamlAssertionWrapper()) == null) break;
                roles = SAMLUtils.parseRolesInAssertion(receivedAssertion, roleAttributeName);
                SAMLSecurityContext context = this.createSecurityContext(p, roles);
                context.setIssuer(SAMLUtils.getIssuer(receivedAssertion));
                context.setAssertionElement(SAMLUtils.getAssertionElement(receivedAssertion));
                msg.put(SecurityContext.class, context);
                break;
            }
            msg.put(SecurityContext.class, this.createSecurityContext(p));
            break;
        }
    }

    private boolean isSecurityContextPrincipal(Principal p, List<SecurityEvent> incomingSecurityEventList) {
        boolean derivedKeyPrincipal = p instanceof WSDerivedKeyTokenPrincipal;
        if (derivedKeyPrincipal || p instanceof CustomTokenPrincipal) {
            return incomingSecurityEventList.size() <= 1;
        }
        return true;
    }

    private SubjectAndPrincipalSecurityToken getSubjectPrincipalToken(SecurityEvent event) {
        if (event.getSecurityEventType() == WSSecurityEventConstants.UsernameToken) {
            return (SubjectAndPrincipalSecurityToken)((UsernameTokenSecurityEvent)event).getSecurityToken();
        }
        if (event.getSecurityEventType() == WSSecurityEventConstants.SamlToken) {
            return (SubjectAndPrincipalSecurityToken)((SamlTokenSecurityEvent)event).getSecurityToken();
        }
        if (event.getSecurityEventType() == WSSecurityEventConstants.X509Token) {
            return (SubjectAndPrincipalSecurityToken)((X509TokenSecurityEvent)event).getSecurityToken();
        }
        if (event.getSecurityEventType() == WSSecurityEventConstants.KeyValueToken) {
            return (SubjectAndPrincipalSecurityToken)((KeyValueTokenSecurityEvent)event).getSecurityToken();
        }
        if (event.getSecurityEventType() == WSSecurityEventConstants.KerberosToken) {
            return (SubjectAndPrincipalSecurityToken)((KerberosTokenSecurityEvent)event).getSecurityToken();
        }
        return null;
    }

    private SecurityContext createSecurityContext(final Principal p) {
        return new SecurityContext(){

            @Override
            public Principal getUserPrincipal() {
                return p;
            }

            @Override
            public boolean isUserInRole(String arg0) {
                return false;
            }
        };
    }

    private SAMLSecurityContext createSecurityContext(Principal p, List<String> roles) {
        HashSet<Principal> userRoles;
        if (roles != null) {
            userRoles = new HashSet<Principal>();
            for (String role : roles) {
                userRoles.add(new SimplePrincipal(role));
            }
        } else {
            userRoles = null;
        }
        return new SAMLSecurityContext(p, userRoles);
    }

    private SoapFault createSoapFault(SoapVersion version, WSSecurityException e) {
        SoapFault fault;
        QName faultCode = e.getFaultCode();
        if (version.getVersion() == 1.1 && faultCode != null) {
            fault = new SoapFault(e.getMessage(), (Throwable)e, faultCode);
        } else {
            fault = new SoapFault(e.getMessage(), (Throwable)e, version.getSender());
            if (version.getVersion() != 1.1 && faultCode != null) {
                fault.setSubCode(faultCode);
            }
        }
        return fault;
    }
}

