/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.net.URI;
import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSoapInterceptor
extends AbstractPhaseInterceptor<SoapMessage>
implements SoapInterceptor {
    public AbstractSoapInterceptor() {
        super(null);
    }

    public AbstractSoapInterceptor(String p) {
        super(p);
    }

    public AbstractSoapInterceptor(String i, String p) {
        super(i, p);
    }

    @Override
    public Set<URI> getRoles() {
        return Collections.emptySet();
    }

    @Override
    public Set<QName> getUnderstoodHeaders() {
        return Collections.emptySet();
    }

    protected String getFaultCodePrefix(XMLStreamWriter writer, QName faultCode) throws XMLStreamException {
        String codeNs = faultCode.getNamespaceURI();
        String prefix = null;
        if (codeNs.length() > 0) {
            prefix = StaxUtils.getUniquePrefix((XMLStreamWriter)writer, (String)codeNs, (boolean)true);
        }
        return prefix;
    }

    protected void prepareStackTrace(SoapMessage message, SoapFault fault) throws Exception {
        String config = (String)message.getContextualProperty("faultStackTraceEnabled");
        if (config != null && Boolean.valueOf(config).booleanValue() && fault.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement ste : fault.getCause().getStackTrace()) {
                sb.append(ste.getClassName() + "!" + ste.getMethodName() + "!" + ste.getFileName() + "!" + ste.getLineNumber() + "\n");
            }
            Element detail = fault.getDetail();
            String soapNamespace = message.getVersion().getNamespace();
            if (detail == null) {
                Document doc = XMLUtils.newDocument();
                Element stackTrace = doc.createElementNS("http://cxf.apache.org/fault", "stackTrace");
                stackTrace.setTextContent(sb.toString());
                detail = doc.createElementNS(soapNamespace, "detail");
                fault.setDetail(detail);
                detail.appendChild(stackTrace);
            } else {
                Element stackTrace = detail.getOwnerDocument().createElementNS("http://cxf.apache.org/fault", "stackTrace");
                stackTrace.setTextContent(sb.toString());
                detail.appendChild(stackTrace);
            }
        }
    }
}

