/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertion;
import org.apache.cxf.ws.security.SecurityConstants;
import org.apache.cxf.ws.security.policy.PolicyUtils;
import org.apache.cxf.ws.security.policy.interceptors.HttpsTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.NegotiationUtils;
import org.apache.cxf.ws.security.policy.interceptors.STSInvoker;
import org.apache.cxf.ws.security.policy.interceptors.SecureConversationTokenInterceptorProvider;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.tokenstore.TokenStoreUtils;
import org.apache.cxf.ws.security.trust.DefaultSymmetricBinding;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.trust.STSUtils;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JStaxInInterceptor;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.message.token.SecurityContextToken;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractBinding;
import org.apache.wss4j.policy.model.Header;
import org.apache.wss4j.policy.model.ProtectionToken;
import org.apache.wss4j.policy.model.SecureConversationToken;
import org.apache.wss4j.policy.model.SignedParts;
import org.apache.wss4j.policy.model.Trust10;
import org.apache.wss4j.policy.model.Trust13;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.apache.xml.security.utils.Base64;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SecureConversationInInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public SecureConversationInInterceptor() {
        super("pre-stream");
        this.addBefore(WSS4JStaxInInterceptor.class.getName());
        this.addBefore(HttpsTokenInterceptorProvider.HttpsTokenInInterceptor.class.getName());
    }

    public void handleMessage(SoapMessage message) throws Fault {
        final AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (aim != null) {
            final Collection<AssertionInfo> ais = PolicyUtils.getAllAssertionsByLocalname(aim, "SecureConversationToken");
            if (ais.isEmpty()) {
                return;
            }
            if (this.isRequestor((Message)message)) {
                for (AssertionInfo ai : ais) {
                    ai.setAsserted(true);
                }
                this.assertPolicies(aim);
                Object s = message.getContextualProperty("security.sts.token.do.cancel");
                if (s != null && (Boolean.TRUE.equals(s) || "true".equalsIgnoreCase(s.toString()))) {
                    message.getInterceptorChain().add((Interceptor)SecureConversationCancelInterceptor.INSTANCE);
                }
                return;
            }
            String s = (String)message.get((Object)"SOAPAction");
            if (s == null) {
                s = SoapActionInInterceptor.getSoapAction((Message)message);
            }
            if (s != null) {
                this.handleMessageForAction(message, s, aim, ais);
            } else {
                AbstractPhaseInterceptor<SoapMessage> post = new AbstractPhaseInterceptor<SoapMessage>("pre-protocol"){

                    public void handleMessage(SoapMessage message) throws Fault {
                        String s = (String)message.get((Object)"SOAPAction");
                        if (s == null) {
                            s = SoapActionInInterceptor.getSoapAction((Message)message);
                        }
                        SecureConversationInInterceptor.this.handleMessageForAction(message, s, aim, ais);
                    }
                };
                post.addAfter(MAPCodec.class.getName());
                post.addBefore(PolicyBasedWSS4JInInterceptor.class.getName());
                message.put("ws-security.enable.streaming", (Object)Boolean.FALSE);
                message.getInterceptorChain().add((Interceptor)post);
            }
        }
    }

    void handleMessageForAction(SoapMessage message, String s, AssertionInfoMap aim, Collection<AssertionInfo> ais) {
        String addNs = null;
        AddressingProperties inProps = (AddressingProperties)message.getContextualProperty("javax.xml.ws.addressing.context.inbound");
        if (inProps != null) {
            addNs = inProps.getNamespaceURI();
            if (s == null) {
                s = inProps.getAction().getValue();
            }
        }
        if (s != null && s.contains("/RST/SCT") && (s.startsWith("http://schemas.xmlsoap.org/ws/2005/02/trust") || s.startsWith("http://docs.oasis-open.org/ws-sx/ws-trust/200512"))) {
            Policy p;
            SecureConversationToken tok = (SecureConversationToken)ais.iterator().next().getAssertion();
            Policy pol = tok.getBootstrapPolicy().getPolicy();
            if (s.endsWith("Cancel")) {
                p = new Policy();
                ExactlyOne ea = new ExactlyOne();
                p.addPolicyComponent((PolicyComponent)ea);
                All all = new All();
                Assertion ass = NegotiationUtils.getAddressingPolicy(aim, false);
                all.addPolicyComponent((PolicyComponent)ass);
                ea.addPolicyComponent((PolicyComponent)all);
                SecureConversationToken secureConversationToken = new SecureConversationToken(SPConstants.SPVersion.SP12, SPConstants.IncludeTokenType.INCLUDE_TOKEN_NEVER, null, null, null, new Policy());
                Policy sctPolicy = new Policy();
                ExactlyOne sctPolicyEa = new ExactlyOne();
                sctPolicy.addPolicyComponent((PolicyComponent)sctPolicyEa);
                All sctPolicyAll = new All();
                sctPolicyAll.addPolicyComponent((PolicyComponent)secureConversationToken);
                sctPolicyEa.addPolicyComponent((PolicyComponent)sctPolicyAll);
                Policy bindingPolicy = new Policy();
                ExactlyOne bindingPolicyEa = new ExactlyOne();
                bindingPolicy.addPolicyComponent((PolicyComponent)bindingPolicyEa);
                All bindingPolicyAll = new All();
                AbstractBinding origBinding = PolicyUtils.getSecurityBinding(aim);
                bindingPolicyAll.addPolicyComponent((PolicyComponent)origBinding.getAlgorithmSuite());
                bindingPolicyAll.addPolicyComponent((PolicyComponent)new ProtectionToken(SPConstants.SPVersion.SP12, sctPolicy));
                bindingPolicyAll.addAssertion((Assertion)new PrimitiveAssertion(SP12Constants.INCLUDE_TIMESTAMP));
                bindingPolicyAll.addAssertion((Assertion)new PrimitiveAssertion(SP12Constants.ONLY_SIGN_ENTIRE_HEADERS_AND_BODY));
                bindingPolicyEa.addPolicyComponent((PolicyComponent)bindingPolicyAll);
                DefaultSymmetricBinding binding = new DefaultSymmetricBinding(SPConstants.SPVersion.SP12, bindingPolicy);
                binding.setOnlySignEntireHeadersAndBody(true);
                binding.setProtectTokens(false);
                all.addPolicyComponent((PolicyComponent)binding);
                SignedParts signedParts = this.getSignedParts(aim, addNs);
                all.addPolicyComponent((PolicyComponent)signedParts);
                pol = p;
                message.getInterceptorChain().add((Interceptor)SecureConversationTokenFinderInterceptor.INSTANCE);
            } else {
                p = new Policy();
                ExactlyOne ea = new ExactlyOne();
                p.addPolicyComponent((PolicyComponent)ea);
                All all = new All();
                Assertion ass = NegotiationUtils.getAddressingPolicy(aim, false);
                all.addPolicyComponent((PolicyComponent)ass);
                ea.addPolicyComponent((PolicyComponent)all);
                pol = p.merge(pol);
            }
            this.unmapSecurityProps((Message)message);
            String ns = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
            if (s.startsWith("http://schemas.xmlsoap.org/ws/2005/02/trust")) {
                ns = "http://schemas.xmlsoap.org/ws/2005/02/trust";
            }
            NegotiationUtils.recalcEffectivePolicy(message, ns, pol, new SecureConversationSTSInvoker(), true);
            SoapActionInInterceptor.getAndSetOperation((SoapMessage)message, (String)s);
        } else {
            message.getInterceptorChain().add((Interceptor)SecureConversationTokenFinderInterceptor.INSTANCE);
        }
        this.assertPolicies(aim);
    }

    private SignedParts getSignedParts(AssertionInfoMap aim, String addNs) {
        AssertionInfo signedPartsAi = PolicyUtils.getFirstAssertionByLocalname(aim, "SignedParts");
        SignedParts signedParts = null;
        if (signedPartsAi != null) {
            signedParts = (SignedParts)signedPartsAi.getAssertion();
        }
        if (signedParts == null) {
            ArrayList<Header> headers = new ArrayList<Header>();
            if (addNs != null) {
                headers.add(new Header("To", addNs));
                headers.add(new Header("From", addNs));
                headers.add(new Header("FaultTo", addNs));
                headers.add(new Header("ReplyTo", addNs));
                headers.add(new Header("Action", addNs));
                headers.add(new Header("MessageID", addNs));
                headers.add(new Header("RelatesTo", addNs));
            }
            signedParts = new SignedParts(SPConstants.SPVersion.SP12, true, null, headers, false);
        }
        return signedParts;
    }

    private void assertPolicies(AssertionInfoMap aim) {
        PolicyUtils.assertPolicy(aim, "BootstrapPolicy");
        PolicyUtils.assertPolicy(aim, "MustNotSendAmend");
        PolicyUtils.assertPolicy(aim, "MustNotSendCancel");
        PolicyUtils.assertPolicy(aim, "MustNotSendRenew");
        QName oldCancelQName = new QName("http://schemas.microsoft.com/ws/2005/07/securitypolicy", "MustNotSendCancel");
        PolicyUtils.assertPolicy(aim, oldCancelQName);
    }

    private void unmapSecurityProps(Message message) {
        Exchange ex = message.getExchange();
        for (String s : SecurityConstants.ALL_PROPERTIES) {
            Object v = message.getContextualProperty(s + ".sct");
            if (v == null) {
                v = message.getContextualProperty(s);
            }
            if (v == null) continue;
            ex.put((Object)s, v);
        }
    }

    static class SecureConversationCancelInterceptor
    extends AbstractPhaseInterceptor<SoapMessage> {
        static final SecureConversationCancelInterceptor INSTANCE = new SecureConversationCancelInterceptor();

        public SecureConversationCancelInterceptor() {
            super("post-logical");
        }

        public void handleMessage(SoapMessage message) throws Fault {
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            if (aim == null) {
                return;
            }
            AssertionInfo ai = PolicyUtils.getFirstAssertionByLocalname(aim, "SecureConversationToken");
            if (ai == null) {
                return;
            }
            SecureConversationToken tok = (SecureConversationToken)ai.getAssertion();
            this.doCancel(message, aim, tok);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCancel(SoapMessage message, AssertionInfoMap aim, SecureConversationToken itok) {
            String tokId;
            Message m2 = message.getExchange().getOutMessage();
            SecurityToken tok = (SecurityToken)m2.getContextualProperty("ws-security.token");
            if (tok == null && (tokId = (String)m2.getContextualProperty("ws-security.token.id")) != null) {
                tok = TokenStoreUtils.getTokenStore(m2).getToken(tokId);
            }
            STSClient client = STSUtils.getClient(m2, "sct");
            AddressingProperties maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context.inbound");
            if (maps == null) {
                maps = (AddressingProperties)m2.get((Object)"javax.xml.ws.addressing.context");
            }
            STSClient sTSClient = client;
            synchronized (sTSClient) {
                try {
                    SecureConversationTokenInterceptorProvider.setupClient(client, message, aim, itok, true);
                    if (maps != null) {
                        client.setAddressingNamespace(maps.getNamespaceURI());
                    }
                    client.cancelSecurityToken(tok);
                    TokenStore tokenStore = TokenStoreUtils.getTokenStore(m2);
                    if (tokenStore != null) {
                        tokenStore.remove(tok.getId());
                    }
                    m2.put((Object)"ws-security.token", null);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new Fault((Throwable)e);
                }
                finally {
                    client.setTrust(null);
                    client.setTrust((Trust10)((Trust13)null));
                    client.setTemplate(null);
                    client.setLocation(null);
                    client.setAddressingNamespace(null);
                }
            }
        }
    }

    static final class SecureConversationTokenFinderInterceptor
    extends AbstractPhaseInterceptor<SoapMessage> {
        static final SecureConversationTokenFinderInterceptor INSTANCE = new SecureConversationTokenFinderInterceptor();

        private SecureConversationTokenFinderInterceptor() {
            super("pre-protocol");
            this.addAfter(WSS4JInInterceptor.class.getName());
        }

        public void handleMessage(SoapMessage message) throws Fault {
            boolean foundSCT = NegotiationUtils.parseSCTResult(message);
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection<AssertionInfo> ais = PolicyUtils.getAllAssertionsByLocalname(aim, "SecureConversationToken");
                if (ais.isEmpty()) {
                    return;
                }
                for (AssertionInfo inf : ais) {
                    SecureConversationToken token = (SecureConversationToken)inf.getAssertion();
                    SPConstants.IncludeTokenType inclusion = token.getIncludeTokenType();
                    if (foundSCT || token.isOptional() || !foundSCT && inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_NEVER) {
                        inf.setAsserted(true);
                        continue;
                    }
                    inf.setNotAsserted("No SecureConversation token found in message.");
                }
            }
        }
    }

    public class SecureConversationSTSInvoker
    extends STSInvoker {
        @Override
        void doIssue(Element requestEl, Exchange exchange, Element binaryExchange, W3CDOMStreamWriter writer, String prefix, String namespace) throws Exception {
            this.doIssueOrRenew(requestEl, exchange, binaryExchange, writer, prefix, namespace, null);
        }

        @Override
        void doRenew(Element requestEl, Exchange exchange, SecurityToken renewToken, Element binaryExchange, W3CDOMStreamWriter writer, String prefix, String namespace) throws Exception {
            this.doIssueOrRenew(requestEl, exchange, binaryExchange, writer, prefix, namespace, renewToken.getId());
        }

        private void doIssueOrRenew(Element requestEl, Exchange exchange, Element binaryExchange, W3CDOMStreamWriter writer, String prefix, String namespace, String tokenIdToRenew) throws Exception {
            SecurityToken bootstrapToken;
            SecurityContextToken sct;
            if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(namespace)) {
                writer.writeStartElement(prefix, "RequestSecurityTokenResponseCollection", namespace);
            }
            writer.writeStartElement(prefix, "RequestSecurityTokenResponse", namespace);
            byte[] clientEntropy = null;
            int keySize = 256;
            long ttl = 300000L;
            String tokenType = null;
            Element el = DOMUtils.getFirstElement((Node)requestEl);
            while (el != null) {
                String localName = el.getLocalName();
                if (namespace.equals(el.getNamespaceURI())) {
                    if ("Entropy".equals(localName)) {
                        Element bs = DOMUtils.getFirstElement((Node)el);
                        if (bs != null) {
                            clientEntropy = Base64.decode((String)bs.getTextContent());
                        }
                    } else if ("KeySize".equals(localName)) {
                        keySize = Integer.parseInt(el.getTextContent());
                    } else if ("TokenType".equals(localName)) {
                        tokenType = el.getTextContent();
                    }
                }
                el = DOMUtils.getNextElement((Element)el);
            }
            if (keySize < 128 || keySize > 512) {
                keySize = 256;
            }
            writer.writeStartElement(prefix, "RequestedSecurityToken", namespace);
            if (tokenIdToRenew != null) {
                ((TokenStore)exchange.getEndpoint().getEndpointInfo().getProperty(TokenStore.class.getName())).remove(tokenIdToRenew);
                String instance = IDGenerator.generateID(null);
                sct = new SecurityContextToken(NegotiationUtils.getWSCVersion(tokenType), writer.getDocument(), tokenIdToRenew, instance);
                sct.setID(WSSConfig.getNewInstance().getIdAllocator().createSecureId("sctId-", (Object)sct.getElement()));
            } else {
                sct = new SecurityContextToken(NegotiationUtils.getWSCVersion(tokenType), writer.getDocument());
                sct.setID(WSSConfig.getNewInstance().getIdAllocator().createSecureId("sctId-", (Object)sct.getElement()));
            }
            Date created = new Date();
            Date expires = new Date();
            expires.setTime(created.getTime() + ttl);
            SecurityToken token = new SecurityToken(sct.getIdentifier(), created, expires);
            token.setToken(sct.getElement());
            token.setTokenType(sct.getTokenType());
            writer.getCurrentNode().appendChild(sct.getElement());
            writer.writeEndElement();
            writer.writeStartElement(prefix, "RequestedAttachedReference", namespace);
            token.setAttachedReference(this.writeSecurityTokenReference(writer, "#" + sct.getID(), tokenType));
            writer.writeEndElement();
            writer.writeStartElement(prefix, "RequestedUnattachedReference", namespace);
            token.setUnattachedReference(this.writeSecurityTokenReference(writer, sct.getIdentifier(), sct.getInstance(), tokenType));
            writer.writeEndElement();
            this.writeLifetime(writer, created, expires, prefix, namespace);
            byte[] secret = this.writeProofToken(prefix, namespace, writer, clientEntropy, keySize);
            token.setSecret(secret);
            SecurityContext sc = (SecurityContext)exchange.getInMessage().get(SecurityContext.class);
            if (sc != null) {
                token.setSecurityContext(sc);
            }
            if ((bootstrapToken = this.getBootstrapToken(exchange.getInMessage())) != null) {
                HashMap<String, Object> properties = new HashMap<String, Object>(1);
                properties.put("bootstrap_security_token_id", bootstrapToken.getId());
                token.setProperties(properties);
            }
            ((TokenStore)exchange.getEndpoint().getEndpointInfo().getProperty(TokenStore.class.getName())).add(token);
            writer.writeEndElement();
            if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(namespace)) {
                writer.writeEndElement();
            }
        }

        private SecurityToken getBootstrapToken(Message message) {
            String id;
            SecurityToken st = (SecurityToken)message.getContextualProperty("ws-security.token");
            if (st == null && (id = (String)message.getContextualProperty("ws-security.token.id")) != null) {
                st = TokenStoreUtils.getTokenStore(message).getToken(id);
            }
            if (st != null && !st.isExpired()) {
                return st;
            }
            return null;
        }
    }
}

