/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.net.InetSocketAddress;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.DummyHAService;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.SshFenceByTcpPort;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestSshFenceByTcpPort {
    private static String TEST_FENCING_HOST;
    private static final String TEST_FENCING_PORT;
    private static final String TEST_KEYFILE;
    private static final InetSocketAddress TEST_ADDR;
    private static final HAServiceTarget TEST_TARGET;
    private static final HAServiceTarget UNFENCEABLE_TARGET;

    @Test(timeout=20000L)
    public void testFence() throws BadFencingConfigurationException {
        Assume.assumeTrue((boolean)this.isConfigured());
        Configuration conf = new Configuration();
        conf.set("dfs.ha.fencing.ssh.private-key-files", TEST_KEYFILE);
        SshFenceByTcpPort fence = new SshFenceByTcpPort();
        fence.setConf(conf);
        Assert.assertTrue((boolean)fence.tryFence(TEST_TARGET, null));
    }

    @Test(timeout=20000L)
    public void testConnectTimeout() throws BadFencingConfigurationException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.fencing.ssh.connect-timeout", 3000);
        SshFenceByTcpPort fence = new SshFenceByTcpPort();
        fence.setConf(conf);
        Assert.assertFalse((boolean)fence.tryFence(UNFENCEABLE_TARGET, ""));
    }

    @Test
    public void testArgsParsing() throws BadFencingConfigurationException {
        SshFenceByTcpPort.Args args = new SshFenceByTcpPort.Args(null);
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)args.user);
        Assert.assertEquals((long)22L, (long)args.sshPort);
        args = new SshFenceByTcpPort.Args("");
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)args.user);
        Assert.assertEquals((long)22L, (long)args.sshPort);
        args = new SshFenceByTcpPort.Args("12345");
        Assert.assertEquals((Object)"12345", (Object)args.user);
        Assert.assertEquals((long)22L, (long)args.sshPort);
        args = new SshFenceByTcpPort.Args(":12345");
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)args.user);
        Assert.assertEquals((long)12345L, (long)args.sshPort);
        args = new SshFenceByTcpPort.Args("foo:2222");
        Assert.assertEquals((Object)"foo", (Object)args.user);
        Assert.assertEquals((long)2222L, (long)args.sshPort);
    }

    @Test
    public void testBadArgsParsing() throws BadFencingConfigurationException {
        this.assertBadArgs(":");
        this.assertBadArgs("bar.com:");
        this.assertBadArgs(":xx");
        this.assertBadArgs("bar.com:xx");
    }

    private void assertBadArgs(String argStr) {
        try {
            new SshFenceByTcpPort.Args(argStr);
            Assert.fail((String)("Did not fail on bad args: " + argStr));
        }
        catch (BadFencingConfigurationException badFencingConfigurationException) {
            // empty catch block
        }
    }

    private boolean isConfigured() {
        return TEST_FENCING_HOST != null && !TEST_FENCING_HOST.isEmpty() && TEST_FENCING_PORT != null && !TEST_FENCING_PORT.isEmpty() && TEST_KEYFILE != null && !TEST_KEYFILE.isEmpty();
    }

    static {
        ((Log4JLogger)SshFenceByTcpPort.LOG).getLogger().setLevel(Level.ALL);
        TEST_FENCING_HOST = System.getProperty("test.TestSshFenceByTcpPort.host", "localhost");
        TEST_FENCING_PORT = System.getProperty("test.TestSshFenceByTcpPort.port", "8020");
        TEST_KEYFILE = System.getProperty("test.TestSshFenceByTcpPort.key");
        TEST_ADDR = new InetSocketAddress(TEST_FENCING_HOST, Integer.parseInt(TEST_FENCING_PORT));
        TEST_TARGET = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, TEST_ADDR);
        UNFENCEABLE_TARGET = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, new InetSocketAddress("8.8.8.8", 1234));
    }
}

