/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;

public interface AdminApiHandler<K, V> {
    public String apiName();

    public AbstractRequest.Builder<?> buildRequest(int var1, Set<K> var2);

    public ApiResult<K, V> handleResponse(Node var1, Set<K> var2, AbstractResponse var3);

    public AdminApiLookupStrategy<K> lookupStrategy();

    public static class ApiResult<K, V> {
        public final Map<K, V> completedKeys;
        public final Map<K, Throwable> failedKeys;
        public final List<K> unmappedKeys;

        public ApiResult(Map<K, V> completedKeys, Map<K, Throwable> failedKeys, List<K> unmappedKeys) {
            this.completedKeys = Collections.unmodifiableMap(completedKeys);
            this.failedKeys = Collections.unmodifiableMap(failedKeys);
            this.unmappedKeys = Collections.unmodifiableList(unmappedKeys);
        }

        public static <K, V> ApiResult<K, V> completed(K key, V value) {
            return new ApiResult<K, V>(Collections.singletonMap(key, value), Collections.emptyMap(), Collections.emptyList());
        }

        public static <K, V> ApiResult<K, V> failed(K key, Throwable t) {
            return new ApiResult(Collections.emptyMap(), Collections.singletonMap(key, t), Collections.emptyList());
        }

        public static <K, V> ApiResult<K, V> unmapped(List<K> keys) {
            return new ApiResult(Collections.emptyMap(), Collections.emptyMap(), keys);
        }

        public static <K, V> ApiResult<K, V> empty() {
            return new ApiResult(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
        }
    }
}

