/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.ant.tasks;

import java.io.File;
import org.apache.maven.plugins.antrun.MavenAntRunProject;
import org.apache.maven.plugins.antrun.taskconfig.AttachArtifactConfiguration;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.codehaus.plexus.util.FileUtils;

public class AttachArtifactTask
extends Task {
    private String mavenProjectRefId = "maven.project.ref";
    private String mavenProjectHelperRefId = "maven.project.helper";
    private AttachArtifactConfiguration configuration = new AttachArtifactConfiguration();

    public void execute() {
        File file = this.configuration.getFile();
        if (file == null) {
            throw new BuildException("File is a required parameter.");
        }
        if (!file.exists()) {
            throw new BuildException("File does not exist: " + file);
        }
        if (this.getProject().getReference(this.mavenProjectRefId) == null) {
            throw new BuildException("Maven project reference not found: " + this.mavenProjectRefId);
        }
        String type = this.configuration.getType();
        if (type == null) {
            type = FileUtils.getExtension((String)file.getName());
        }
        MavenProject mavenProject = ((MavenAntRunProject)this.getProject().getReference(this.mavenProjectRefId)).getMavenProject();
        if (this.getProject().getReference(this.mavenProjectHelperRefId) == null) {
            throw new BuildException("Maven project helper reference not found: " + this.mavenProjectHelperRefId);
        }
        String classifier = this.configuration.getClassifier();
        this.log("Attaching " + file + " as an attached artifact", 3);
        MavenProjectHelper projectHelper = (MavenProjectHelper)this.getProject().getReference(this.mavenProjectHelperRefId);
        projectHelper.attachArtifact(mavenProject, type, classifier, file);
    }

    public String getMavenProjectRefId() {
        return this.mavenProjectRefId;
    }

    public void setMavenProjectRefId(String mavenProjectRefId) {
        this.mavenProjectRefId = mavenProjectRefId;
    }

    public File getFile() {
        return this.configuration.getFile();
    }

    public void setFile(File file) {
        this.configuration.setFile(file);
    }

    public String getClassifier() {
        return this.configuration.getClassifier();
    }

    public void setClassifier(String classifier) {
        this.configuration.setClassifier(classifier);
    }

    public String getType() {
        return this.configuration.getType();
    }

    public void setType(String type) {
        this.configuration.setType(type);
    }
}

