/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.failsafe;

import java.io.File;
import java.util.Collection;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.failsafe.util.FailsafeSummaryXmlUtils;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.plugin.surefire.log.PluginConsoleLogger;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.surefire.api.cli.CommandLineOption;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.shared.utils.StringUtils;
import org.codehaus.plexus.logging.Logger;

@Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY, requiresProject=true, threadSafe=true)
public class VerifyMojo
extends AbstractMojo
implements SurefireReportParameters {
    @Parameter(property="skipTests")
    private boolean skipTests;
    @Parameter(property="skipITs")
    private boolean skipITs;
    @Deprecated
    @Parameter(property="maven.test.skip.exec")
    private boolean skipExec;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean testFailureIgnore;
    @Parameter(defaultValue="${basedir}")
    private File basedir;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File testClassesDirectory;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports")
    private File reportsDirectory;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports/failsafe-summary.xml", required=true)
    private File summaryFile;
    @Parameter
    private File[] summaryFiles;
    @Parameter(property="failIfNoTests", defaultValue="false")
    private boolean failIfNoTests;
    @Parameter(property="failsafe.failOnFlakeCount", defaultValue="0")
    private int failOnFlakeCount;
    @Parameter(property="encoding", defaultValue="${project.reporting.outputEncoding}")
    private String encoding;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private Logger logger;
    private Collection<CommandLineOption> cli;
    private volatile PluginConsoleLogger consoleLogger;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.cli = this.commandLineOptions();
        if (this.verifyParameters()) {
            RunResult summary;
            this.logDebugOrCliShowErrors(StringUtils.capitalizeFirstLetter((String)this.getPluginName()) + " report directory: " + this.getReportsDirectory());
            try {
                RunResult runResult = summary = this.existsSummaryFile() ? this.readSummary(this.summaryFile) : RunResult.noTestsRun();
                if (this.existsSummaryFiles()) {
                    for (File summaryFile : this.summaryFiles) {
                        summary = summary.aggregate(this.readSummary(summaryFile));
                    }
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            SurefireHelper.reportExecution((SurefireReportParameters)this, (RunResult)summary, (PluginConsoleLogger)this.getConsoleLogger(), (Exception)this.getBooterForkException(summary));
        }
    }

    private Exception getBooterForkException(RunResult summary) {
        String firstForkExceptionFailureMessage = String.format("%s: ", SurefireBooterForkException.class.getName());
        if (summary.getFailure() != null && summary.getFailure().contains(firstForkExceptionFailureMessage)) {
            return new SurefireBooterForkException(summary.getFailure().substring(firstForkExceptionFailureMessage.length()));
        }
        return null;
    }

    void setLogger(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginConsoleLogger getConsoleLogger() {
        if (this.consoleLogger == null) {
            VerifyMojo verifyMojo = this;
            synchronized (verifyMojo) {
                if (this.consoleLogger == null) {
                    this.consoleLogger = new PluginConsoleLogger(this.logger);
                }
            }
        }
        return this.consoleLogger;
    }

    private RunResult readSummary(File summaryFile) throws Exception {
        return FailsafeSummaryXmlUtils.toRunResult(summaryFile);
    }

    protected boolean verifyParameters() throws MojoFailureException {
        if (this.isSkip() || this.isSkipTests() || this.isSkipITs() || this.isSkipExec()) {
            this.getConsoleLogger().info("Tests are skipped.");
            return false;
        }
        if (!this.getTestClassesDirectory().exists() && this.getFailIfNoTests()) {
            throw new MojoFailureException("No tests to run!");
        }
        if (!this.existsSummary()) {
            this.getConsoleLogger().info("No tests to run.");
            return false;
        }
        if (this.failOnFlakeCount < 0) {
            throw new MojoFailureException("Parameter \"failOnFlakeCount\" should not be negative.");
        }
        return true;
    }

    protected String getPluginName() {
        return "failsafe";
    }

    protected String[] getDefaultIncludes() {
        return null;
    }

    public boolean isSkipTests() {
        return this.skipTests;
    }

    public void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    public boolean isSkipITs() {
        return this.skipITs;
    }

    public void setSkipITs(boolean skipITs) {
        this.skipITs = skipITs;
    }

    @Deprecated
    public boolean isSkipExec() {
        return this.skipExec;
    }

    @Deprecated
    public void setSkipExec(boolean skipExec) {
        this.skipExec = skipExec;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isTestFailureIgnore() {
        return this.testFailureIgnore;
    }

    public void setTestFailureIgnore(boolean testFailureIgnore) {
        this.testFailureIgnore = testFailureIgnore;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    public void setTestClassesDirectory(File testClassesDirectory) {
        this.testClassesDirectory = testClassesDirectory;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public File getSummaryFile() {
        return this.summaryFile;
    }

    public void setSummaryFile(File summaryFile) {
        this.summaryFile = summaryFile;
    }

    public boolean getFailIfNoTests() {
        return this.failIfNoTests;
    }

    public void setFailIfNoTests(boolean failIfNoTests) {
        this.failIfNoTests = failIfNoTests;
    }

    public int getFailOnFlakeCount() {
        return this.failOnFlakeCount;
    }

    public void setFailOnFlakeCount(int failOnFlakeCount) {
        this.failOnFlakeCount = failOnFlakeCount;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    private boolean existsSummaryFile() {
        return this.summaryFile != null && this.summaryFile.isFile();
    }

    private boolean existsSummaryFiles() {
        return this.summaryFiles != null && this.summaryFiles.length != 0;
    }

    private boolean existsSummary() {
        return this.existsSummaryFile() || this.existsSummaryFiles();
    }

    private Collection<CommandLineOption> commandLineOptions() {
        return SurefireHelper.commandLineOptions((MavenSession)this.session, (PluginConsoleLogger)this.getConsoleLogger());
    }

    private void logDebugOrCliShowErrors(String s) {
        SurefireHelper.logDebugOrCliShowErrors((String)s, (PluginConsoleLogger)this.getConsoleLogger(), this.cli);
    }
}

