/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.pom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom.Content;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class MavenJDOMWriter {
    private DefaultJDOMFactory factory = new DefaultJDOMFactory();
    private String lineSeparator = "\n";

    protected Element findAndReplaceProperties(Counter counter, Element parent, String name, Map props) {
        boolean shouldExist = props != null && !props.isEmpty();
        Element element = this.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            Counter innerCounter = new Counter(counter.getDepth() + 1);
            for (Map.Entry entry : props.entrySet()) {
                String key = (String)entry.getKey();
                this.findAndReplaceSimpleElement(innerCounter, element, key, (String)entry.getValue(), null);
            }
            ArrayList lst = new ArrayList(props.keySet());
            Iterator it = element.getChildren().iterator();
            while (it.hasNext()) {
                Element elem = (Element)it.next();
                String key = elem.getName();
                if (lst.contains(key)) continue;
                it.remove();
            }
        }
        return element;
    }

    protected Element findAndReplaceSimpleElement(Counter counter, Element parent, String name, String text, String defaultValue) {
        Element element;
        if (defaultValue != null && text != null && defaultValue.equals(text) && ((element = parent.getChild(name, parent.getNamespace())) != null && defaultValue.equals(element.getText()) || element == null)) {
            return element;
        }
        boolean shouldExist = text != null && text.trim().length() > 0;
        Element element2 = this.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            element2.setText(text);
        }
        return element2;
    }

    protected Element findAndReplaceSimpleLists(Counter counter, Element parent, Collection list, String parentName, String childName) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentName, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childName, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                String value = (String)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childName, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                el.setText(value);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
        return element;
    }

    protected Element findAndReplaceXpp3DOM(Counter counter, Element parent, String name, Xpp3Dom dom) {
        boolean shouldExist = dom != null && (dom.getChildCount() > 0 || dom.getValue() != null);
        Element element = this.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            this.replaceXpp3DOM(element, dom, new Counter(counter.getDepth() + 1));
        }
        return element;
    }

    protected void insertAtPreferredLocation(Element parent, Element child, Counter counter) {
        int contentIndex = 0;
        int elementCounter = 0;
        Iterator it = parent.getContent().iterator();
        Text lastText = null;
        int offset = 0;
        while (it.hasNext() && elementCounter <= counter.getCurrentIndex()) {
            Object next = it.next();
            ++offset;
            if (next instanceof Element) {
                ++elementCounter;
                contentIndex += offset;
                offset = 0;
            }
            if (!(next instanceof Text) || !it.hasNext()) continue;
            lastText = (Text)next;
        }
        if (lastText != null && lastText.getTextTrim().length() == 0) {
            lastText = (Text)lastText.clone();
        } else {
            String starter = this.lineSeparator;
            for (int i = 0; i < counter.getDepth(); ++i) {
                starter = starter + "    ";
            }
            lastText = this.factory.text(starter);
        }
        if (parent.getContentSize() == 0) {
            Text finalText = (Text)lastText.clone();
            finalText.setText(finalText.getText().substring(0, finalText.getText().length() - "    ".length()));
            parent.addContent(contentIndex, (Content)finalText);
        }
        parent.addContent(contentIndex, (Content)child);
        parent.addContent(contentIndex, (Content)lastText);
    }

    protected void iterateContributor(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Contributor value = (Contributor)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateContributor(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateDependency(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Dependency value = (Dependency)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateDependency(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateDeveloper(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Developer value = (Developer)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateDeveloper(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateExclusion(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Exclusion value = (Exclusion)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateExclusion(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateExtension(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Extension value = (Extension)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateExtension(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateLicense(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                License value = (License)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateLicense(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateMailingList(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                MailingList value = (MailingList)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateMailingList(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateNotifier(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Notifier value = (Notifier)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateNotifier(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iteratePlugin(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Plugin value = (Plugin)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updatePlugin(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iteratePluginExecution(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                PluginExecution value = (PluginExecution)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updatePluginExecution(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateProfile(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Profile value = (Profile)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateProfile(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateReportPlugin(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                ReportPlugin value = (ReportPlugin)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateReportPlugin(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateReportSet(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                ReportSet value = (ReportSet)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateReportSet(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateRepository(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Repository value = (Repository)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateRepository(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateResource(Counter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Resource value = (Resource)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateResource(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void replaceXpp3DOM(Element parent, Xpp3Dom parentDom, Counter counter) {
        if (parentDom.getChildCount() > 0) {
            Xpp3Dom[] childs = parentDom.getChildren();
            ArrayList<Xpp3Dom> domChilds = new ArrayList<Xpp3Dom>();
            for (int i = 0; i < childs.length; ++i) {
                domChilds.add(childs[i]);
            }
            ListIterator it = parent.getChildren().listIterator();
            while (it.hasNext()) {
                Element elem = (Element)it.next();
                Iterator it2 = domChilds.iterator();
                Xpp3Dom corrDom = null;
                while (it2.hasNext()) {
                    Xpp3Dom dm = (Xpp3Dom)it2.next();
                    if (!dm.getName().equals(elem.getName())) continue;
                    corrDom = dm;
                    break;
                }
                if (corrDom != null) {
                    domChilds.remove(corrDom);
                    this.replaceXpp3DOM(elem, corrDom, new Counter(counter.getDepth() + 1));
                    counter.increaseCount();
                    continue;
                }
                parent.removeContent((Content)elem);
            }
            for (Xpp3Dom dm : domChilds) {
                Element elem = this.factory.element(dm.getName(), parent.getNamespace());
                this.insertAtPreferredLocation(parent, elem, counter);
                counter.increaseCount();
                this.replaceXpp3DOM(elem, dm, new Counter(counter.getDepth() + 1));
            }
        } else if (parentDom.getValue() != null) {
            parent.setText(parentDom.getValue());
        }
    }

    protected void updateActivationFile(ActivationFile value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "missing", value.getMissing(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "exists", value.getExists(), null);
        }
    }

    protected void updateActivationOS(ActivationOS value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "family", value.getFamily(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "arch", value.getArch(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
        }
    }

    protected void updateActivationProperty(ActivationProperty value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "value", value.getValue(), null);
        }
    }

    protected void updateBuild(Build value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "sourceDirectory", value.getSourceDirectory(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "scriptSourceDirectory", value.getScriptSourceDirectory(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "testSourceDirectory", value.getTestSourceDirectory(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "outputDirectory", value.getOutputDirectory(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "testOutputDirectory", value.getTestOutputDirectory(), null);
            this.iterateExtension(innerCount, root, value.getExtensions(), "extensions", "extension");
            this.findAndReplaceSimpleElement(innerCount, root, "defaultGoal", value.getDefaultGoal(), null);
            this.iterateResource(innerCount, root, value.getResources(), "resources", "resource");
            this.iterateResource(innerCount, root, value.getTestResources(), "testResources", "testResource");
            this.findAndReplaceSimpleElement(innerCount, root, "directory", value.getDirectory(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "finalName", value.getFinalName(), null);
            this.findAndReplaceSimpleLists(innerCount, root, value.getFilters(), "filters", "filter");
            this.updatePluginManagement(value.getPluginManagement(), "pluginManagement", innerCount, root);
            this.iteratePlugin(innerCount, root, value.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updateBuildBase(BuildBase value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "defaultGoal", value.getDefaultGoal(), null);
            this.iterateResource(innerCount, root, value.getResources(), "resources", "resource");
            this.iterateResource(innerCount, root, value.getTestResources(), "testResources", "testResource");
            this.findAndReplaceSimpleElement(innerCount, root, "directory", value.getDirectory(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "finalName", value.getFinalName(), null);
            this.findAndReplaceSimpleLists(innerCount, root, value.getFilters(), "filters", "filter");
            this.updatePluginManagement(value.getPluginManagement(), "pluginManagement", innerCount, root);
            this.iteratePlugin(innerCount, root, value.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updateCiManagement(CiManagement value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "system", value.getSystem(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
            this.iterateNotifier(innerCount, root, value.getNotifiers(), "notifiers", "notifier");
        }
    }

    protected void updateConfigurationContainer(ConfigurationContainer value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "inherited", value.getInherited(), null);
            this.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)value.getConfiguration());
        }
    }

    protected void updateContributor(Contributor value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "email", value.getEmail(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "organization", value.getOrganization(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "organizationUrl", value.getOrganizationUrl(), null);
        this.findAndReplaceSimpleLists(innerCount, root, value.getRoles(), "roles", "role");
        this.findAndReplaceSimpleElement(innerCount, root, "timezone", value.getTimezone(), null);
        this.findAndReplaceProperties(innerCount, root, "properties", value.getProperties());
    }

    protected void updateDependency(Dependency value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "type", value.getType(), "jar");
        this.findAndReplaceSimpleElement(innerCount, root, "classifier", value.getClassifier(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "scope", value.getScope(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "systemPath", value.getSystemPath(), null);
        this.iterateExclusion(innerCount, root, value.getExclusions(), "exclusions", "exclusion");
        this.findAndReplaceSimpleElement(innerCount, root, "optional", !value.isOptional() ? null : String.valueOf(value.isOptional()), "false");
    }

    protected void updateDependencyManagement(DependencyManagement value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.iterateDependency(innerCount, root, value.getDependencies(), "dependencies", "dependency");
        }
    }

    protected void updateDeploymentRepository(DeploymentRepository value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "uniqueVersion", value.isUniqueVersion() ? null : String.valueOf(value.isUniqueVersion()), "true");
            this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "layout", value.getLayout(), "default");
        }
    }

    protected void updateDeveloper(Developer value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "email", value.getEmail(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "organization", value.getOrganization(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "organizationUrl", value.getOrganizationUrl(), null);
        this.findAndReplaceSimpleLists(innerCount, root, value.getRoles(), "roles", "role");
        this.findAndReplaceSimpleElement(innerCount, root, "timezone", value.getTimezone(), null);
        this.findAndReplaceProperties(innerCount, root, "properties", value.getProperties());
    }

    protected void updateDistributionManagement(DistributionManagement value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.updateDeploymentRepository(value.getRepository(), "repository", innerCount, root);
            this.updateDeploymentRepository(value.getSnapshotRepository(), "snapshotRepository", innerCount, root);
            this.updateSite(value.getSite(), "site", innerCount, root);
            this.findAndReplaceSimpleElement(innerCount, root, "downloadUrl", value.getDownloadUrl(), null);
            this.updateRelocation(value.getRelocation(), "relocation", innerCount, root);
            this.findAndReplaceSimpleElement(innerCount, root, "status", value.getStatus(), null);
        }
    }

    protected Element updateElement(Counter counter, Element parent, String name, boolean shouldExist) {
        Element element = parent.getChild(name, parent.getNamespace());
        if (element != null && shouldExist) {
            counter.increaseCount();
        }
        if (element == null && shouldExist) {
            element = this.factory.element(name, parent.getNamespace());
            this.insertAtPreferredLocation(parent, element, counter);
            counter.increaseCount();
        }
        if (!shouldExist && element != null) {
            Text txt;
            Content previous;
            int index = parent.indexOf((Content)element);
            if (index > 0 && (previous = parent.getContent(index - 1)) instanceof Text && (txt = (Text)previous).getTextTrim().length() == 0) {
                parent.removeContent((Content)txt);
            }
            parent.removeContent((Content)element);
        }
        return element;
    }

    protected void updateExclusion(Exclusion value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null);
    }

    protected void updateExtension(Extension value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
    }

    protected void updateFileSet(FileSet value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "directory", value.getDirectory(), null);
            this.findAndReplaceSimpleLists(innerCount, root, value.getIncludes(), "includes", "include");
            this.findAndReplaceSimpleLists(innerCount, root, value.getExcludes(), "excludes", "exclude");
        }
    }

    protected void updateIssueManagement(IssueManagement value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "system", value.getSystem(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        }
    }

    protected void updateLicense(License value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "distribution", value.getDistribution(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "comments", value.getComments(), null);
    }

    protected void updateMailingList(MailingList value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "subscribe", value.getSubscribe(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "unsubscribe", value.getUnsubscribe(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "post", value.getPost(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "archive", value.getArchive(), null);
        this.findAndReplaceSimpleLists(innerCount, root, value.getOtherArchives(), "otherArchives", "otherArchive");
    }

    protected void updateModel(Model value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.updateParent(value.getParent(), "parent", innerCount, root);
        this.findAndReplaceSimpleElement(innerCount, root, "modelVersion", value.getModelVersion(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "packaging", value.getPackaging(), "jar");
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "description", value.getDescription(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        this.updatePrerequisites(value.getPrerequisites(), "prerequisites", innerCount, root);
        this.updateIssueManagement(value.getIssueManagement(), "issueManagement", innerCount, root);
        this.updateCiManagement(value.getCiManagement(), "ciManagement", innerCount, root);
        this.findAndReplaceSimpleElement(innerCount, root, "inceptionYear", value.getInceptionYear(), null);
        this.iterateMailingList(innerCount, root, value.getMailingLists(), "mailingLists", "mailingList");
        this.iterateDeveloper(innerCount, root, value.getDevelopers(), "developers", "developer");
        this.iterateContributor(innerCount, root, value.getContributors(), "contributors", "contributor");
        this.iterateLicense(innerCount, root, value.getLicenses(), "licenses", "license");
        this.updateScm(value.getScm(), "scm", innerCount, root);
        this.updateOrganization(value.getOrganization(), "organization", innerCount, root);
        this.updateBuild(value.getBuild(), "build", innerCount, root);
        this.iterateProfile(innerCount, root, value.getProfiles(), "profiles", "profile");
        this.findAndReplaceSimpleLists(innerCount, root, value.getModules(), "modules", "module");
        this.iterateRepository(innerCount, root, value.getRepositories(), "repositories", "repository");
        this.iterateRepository(innerCount, root, value.getPluginRepositories(), "pluginRepositories", "pluginRepository");
        this.iterateDependency(innerCount, root, value.getDependencies(), "dependencies", "dependency");
        this.findAndReplaceXpp3DOM(innerCount, root, "reports", (Xpp3Dom)value.getReports());
        this.updateReporting(value.getReporting(), "reporting", innerCount, root);
        this.updateDependencyManagement(value.getDependencyManagement(), "dependencyManagement", innerCount, root);
        this.updateDistributionManagement(value.getDistributionManagement(), "distributionManagement", innerCount, root);
        this.findAndReplaceProperties(innerCount, root, "properties", value.getProperties());
    }

    protected void updateModelBase(ModelBase value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleLists(innerCount, root, value.getModules(), "modules", "module");
            this.iterateRepository(innerCount, root, value.getRepositories(), "repositories", "repository");
            this.iterateRepository(innerCount, root, value.getPluginRepositories(), "pluginRepositories", "pluginRepository");
            this.iterateDependency(innerCount, root, value.getDependencies(), "dependencies", "dependency");
            this.findAndReplaceXpp3DOM(innerCount, root, "reports", (Xpp3Dom)value.getReports());
            this.updateReporting(value.getReporting(), "reporting", innerCount, root);
            this.updateDependencyManagement(value.getDependencyManagement(), "dependencyManagement", innerCount, root);
            this.updateDistributionManagement(value.getDistributionManagement(), "distributionManagement", innerCount, root);
            this.findAndReplaceProperties(innerCount, root, "properties", value.getProperties());
        }
    }

    protected void updateNotifier(Notifier value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "type", value.getType(), "mail");
        this.findAndReplaceSimpleElement(innerCount, root, "sendOnError", value.isSendOnError() ? null : String.valueOf(value.isSendOnError()), "true");
        this.findAndReplaceSimpleElement(innerCount, root, "sendOnFailure", value.isSendOnFailure() ? null : String.valueOf(value.isSendOnFailure()), "true");
        this.findAndReplaceSimpleElement(innerCount, root, "sendOnSuccess", value.isSendOnSuccess() ? null : String.valueOf(value.isSendOnSuccess()), "true");
        this.findAndReplaceSimpleElement(innerCount, root, "sendOnWarning", value.isSendOnWarning() ? null : String.valueOf(value.isSendOnWarning()), "true");
        this.findAndReplaceSimpleElement(innerCount, root, "address", value.getAddress(), null);
        this.findAndReplaceProperties(innerCount, root, "configuration", value.getConfiguration());
    }

    protected void updateOrganization(Organization value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        }
    }

    protected void updateParent(Parent value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "relativePath", value.getRelativePath(), "../pom.xml");
        }
    }

    protected void updatePatternSet(PatternSet value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleLists(innerCount, root, value.getIncludes(), "includes", "include");
            this.findAndReplaceSimpleLists(innerCount, root, value.getExcludes(), "excludes", "exclude");
        }
    }

    protected void updatePlugin(Plugin value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), "org.apache.maven.plugins");
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "extensions", !value.isExtensions() ? null : String.valueOf(value.isExtensions()), "false");
        this.iteratePluginExecution(innerCount, root, value.getExecutions(), "executions", "execution");
        this.iterateDependency(innerCount, root, value.getDependencies(), "dependencies", "dependency");
        this.findAndReplaceXpp3DOM(innerCount, root, "goals", (Xpp3Dom)value.getGoals());
        this.findAndReplaceSimpleElement(innerCount, root, "inherited", value.getInherited(), null);
        this.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)value.getConfiguration());
    }

    protected void updatePluginConfiguration(PluginConfiguration value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.updatePluginManagement(value.getPluginManagement(), "pluginManagement", innerCount, root);
            this.iteratePlugin(innerCount, root, value.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updatePluginContainer(PluginContainer value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.iteratePlugin(innerCount, root, value.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updatePluginExecution(PluginExecution value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), "default");
        this.findAndReplaceSimpleElement(innerCount, root, "phase", value.getPhase(), null);
        this.findAndReplaceSimpleLists(innerCount, root, value.getGoals(), "goals", "goal");
        this.findAndReplaceSimpleElement(innerCount, root, "inherited", value.getInherited(), null);
        this.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)value.getConfiguration());
    }

    protected void updatePluginManagement(PluginManagement value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.iteratePlugin(innerCount, root, value.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updatePrerequisites(Prerequisites value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "maven", value.getMaven(), "2.0");
        }
    }

    protected void updateProfile(Profile value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), "default");
        this.updateBuildBase(value.getBuild(), "build", innerCount, root);
        this.findAndReplaceSimpleLists(innerCount, root, value.getModules(), "modules", "module");
        this.iterateRepository(innerCount, root, value.getRepositories(), "repositories", "repository");
        this.iterateRepository(innerCount, root, value.getPluginRepositories(), "pluginRepositories", "pluginRepository");
        this.iterateDependency(innerCount, root, value.getDependencies(), "dependencies", "dependency");
        this.findAndReplaceXpp3DOM(innerCount, root, "reports", (Xpp3Dom)value.getReports());
        this.updateReporting(value.getReporting(), "reporting", innerCount, root);
        this.updateDependencyManagement(value.getDependencyManagement(), "dependencyManagement", innerCount, root);
        this.updateDistributionManagement(value.getDistributionManagement(), "distributionManagement", innerCount, root);
        this.findAndReplaceProperties(innerCount, root, "properties", value.getProperties());
    }

    protected void updateRelocation(Relocation value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "message", value.getMessage(), null);
        }
    }

    protected void updateReportPlugin(ReportPlugin value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), "org.apache.maven.plugins");
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "inherited", value.getInherited(), null);
        this.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)value.getConfiguration());
        this.iterateReportSet(innerCount, root, value.getReportSets(), "reportSets", "reportSet");
    }

    protected void updateReportSet(ReportSet value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), "default");
        this.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)value.getConfiguration());
        this.findAndReplaceSimpleElement(innerCount, root, "inherited", value.getInherited(), null);
        this.findAndReplaceSimpleLists(innerCount, root, value.getReports(), "reports", "report");
    }

    protected void updateReporting(Reporting value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "excludeDefaults", !value.isExcludeDefaults() ? null : String.valueOf(value.isExcludeDefaults()), "false");
            this.findAndReplaceSimpleElement(innerCount, root, "outputDirectory", value.getOutputDirectory(), null);
            this.iterateReportPlugin(innerCount, root, value.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updateRepository(Repository value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.updateRepositoryPolicy(value.getReleases(), "releases", innerCount, root);
        this.updateRepositoryPolicy(value.getSnapshots(), "snapshots", innerCount, root);
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "layout", value.getLayout(), "default");
    }

    protected void updateRepositoryBase(RepositoryBase value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "layout", value.getLayout(), "default");
        }
    }

    protected void updateRepositoryPolicy(RepositoryPolicy value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "enabled", value.isEnabled() ? null : String.valueOf(value.isEnabled()), "true");
            this.findAndReplaceSimpleElement(innerCount, root, "updatePolicy", value.getUpdatePolicy(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "checksumPolicy", value.getChecksumPolicy(), null);
        }
    }

    protected void updateResource(Resource value, String xmlTag, Counter counter, Element element) {
        Element root = element;
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "targetPath", value.getTargetPath(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "filtering", !value.isFiltering() ? null : String.valueOf(value.isFiltering()), "false");
        this.findAndReplaceSimpleElement(innerCount, root, "directory", value.getDirectory(), null);
        this.findAndReplaceSimpleLists(innerCount, root, value.getIncludes(), "includes", "include");
        this.findAndReplaceSimpleLists(innerCount, root, value.getExcludes(), "excludes", "exclude");
    }

    protected void updateScm(Scm value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "connection", value.getConnection(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "developerConnection", value.getDeveloperConnection(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "tag", value.getTag(), "HEAD");
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        }
    }

    protected void updateSite(Site value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        }
    }

    public void write(Model project, Document document, OutputStream stream) throws IOException {
        this.updateModel(project, "project", new Counter(0), document.getRootElement());
        XMLOutputter outputter = new XMLOutputter();
        Format format = Format.getPrettyFormat();
        format.setIndent("    ").setLineSeparator(System.getProperty("line.separator"));
        outputter.setFormat(format);
        outputter.output(document, stream);
    }

    public void write(Model project, Document document, OutputStreamWriter writer) throws IOException {
        Format format = Format.getRawFormat();
        format.setEncoding(writer.getEncoding()).setLineSeparator(System.getProperty("line.separator"));
        this.write(project, document, writer, format);
    }

    public void write(Model project, Document document, Writer writer, Format jdomFormat) throws IOException {
        this.updateModel(project, "project", new Counter(0), document.getRootElement());
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(jdomFormat);
        outputter.output(document, writer);
    }

    public class Counter {
        private int currentIndex = 0;
        private int level;

        public Counter(int depthLevel) {
            this.level = depthLevel;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public int getDepth() {
            return this.level;
        }

        public void increaseCount() {
            ++this.currentIndex;
        }
    }
}

