/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.war.AbstractWarMojo;
import org.apache.maven.plugin.war.util.ClassesPackager;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class WarMojo
extends AbstractWarMojo {
    private String outputDirectory;
    private String warName;
    private String classifier;
    private String packagingExcludes;
    private String packagingIncludes;
    private WarArchiver warArchiver;
    private MavenProjectHelper projectHelper;
    private boolean primaryArtifact = true;
    private boolean failOnMissingWebXml = true;
    private boolean attachClasses = false;
    private String classesClassifier = "classes";

    public void execute() throws MojoExecutionException, MojoFailureException {
        File warFile = this.getTargetWarFile();
        try {
            this.performPackaging(warFile);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error assembling WAR: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("Error assembling WAR", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error assembling WAR", (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error assembling WAR: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private void performPackaging(File warFile) throws IOException, ArchiverException, ManifestException, DependencyResolutionRequiredException, MojoExecutionException, MojoFailureException {
        String classifier;
        this.getLog().info((CharSequence)"Packaging webapp");
        this.buildExplodedWebapp(this.getWebappDirectory());
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver((JarArchiver)this.warArchiver);
        archiver.setOutputFile(warFile);
        this.getLog().debug((CharSequence)("Excluding " + Arrays.asList(this.getPackagingExcludes()) + " from the generated webapp archive."));
        this.getLog().debug((CharSequence)("Including " + Arrays.asList(this.getPackagingIncludes()) + " in the generated webapp archive."));
        this.warArchiver.addDirectory(this.getWebappDirectory(), this.getPackagingIncludes(), this.getPackagingExcludes());
        File webXmlFile = new File(this.getWebappDirectory(), "WEB-INF/web.xml");
        if (webXmlFile.exists()) {
            this.warArchiver.setWebxml(webXmlFile);
        }
        if (!this.failOnMissingWebXml) {
            this.getLog().debug((CharSequence)"Build won't fail if web.xml file is missing.");
            this.warArchiver.setIgnoreWebxml(false);
        }
        archiver.createArchive(this.getSession(), this.getProject(), this.getArchive());
        if (this.isAttachClasses()) {
            if (this.isArchiveClasses() && this.getJarArchiver().getDestFile() != null) {
                File targetClassesFile = this.getTargetClassesFile();
                FileUtils.copyFile((File)this.getJarArchiver().getDestFile(), (File)targetClassesFile);
                this.projectHelper.attachArtifact(this.getProject(), "jar", this.getClassesClassifier(), targetClassesFile);
            } else {
                ClassesPackager packager = new ClassesPackager();
                File classesDirectory = packager.getClassesDirectory(this.getWebappDirectory());
                if (classesDirectory.exists()) {
                    this.getLog().info((CharSequence)"Packaging classes");
                    packager.packageClasses(classesDirectory, this.getTargetClassesFile(), this.getJarArchiver(), this.getSession(), this.getProject(), this.getArchive());
                    this.projectHelper.attachArtifact(this.getProject(), "jar", this.getClassesClassifier(), this.getTargetClassesFile());
                }
            }
        }
        if ((classifier = this.classifier) != null) {
            this.projectHelper.attachArtifact(this.getProject(), "war", classifier, warFile);
        } else {
            Artifact artifact = this.getProject().getArtifact();
            if (this.primaryArtifact) {
                artifact.setFile(warFile);
            } else if (artifact.getFile() == null || artifact.getFile().isDirectory()) {
                artifact.setFile(warFile);
            }
        }
    }

    protected static File getTargetFile(File basedir, String finalName, String classifier, String type) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + "." + type);
    }

    protected File getTargetWarFile() {
        return WarMojo.getTargetFile(new File(this.getOutputDirectory()), this.getWarName(), this.getClassifier(), "war");
    }

    protected File getTargetClassesFile() {
        return WarMojo.getTargetFile(new File(this.getOutputDirectory()), this.getWarName(), this.getClassesClassifier(), "jar");
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String[] getPackagingExcludes() {
        if (StringUtils.isEmpty((String)this.packagingExcludes)) {
            return new String[0];
        }
        return StringUtils.split((String)this.packagingExcludes, (String)",");
    }

    public void setPackagingExcludes(String packagingExcludes) {
        this.packagingExcludes = packagingExcludes;
    }

    public String[] getPackagingIncludes() {
        if (StringUtils.isEmpty((String)this.packagingIncludes)) {
            return new String[]{"**"};
        }
        return StringUtils.split((String)this.packagingIncludes, (String)",");
    }

    public void setPackagingIncludes(String packagingIncludes) {
        this.packagingIncludes = packagingIncludes;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getWarName() {
        return this.warName;
    }

    public void setWarName(String warName) {
        this.warName = warName;
    }

    public WarArchiver getWarArchiver() {
        return this.warArchiver;
    }

    public void setWarArchiver(WarArchiver warArchiver) {
        this.warArchiver = warArchiver;
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public void setProjectHelper(MavenProjectHelper projectHelper) {
        this.projectHelper = projectHelper;
    }

    public boolean isPrimaryArtifact() {
        return this.primaryArtifact;
    }

    public void setPrimaryArtifact(boolean primaryArtifact) {
        this.primaryArtifact = primaryArtifact;
    }

    public boolean isAttachClasses() {
        return this.attachClasses;
    }

    public void setAttachClasses(boolean attachClasses) {
        this.attachClasses = attachClasses;
    }

    public String getClassesClassifier() {
        return this.classesClassifier;
    }

    public void setClassesClassifier(String classesClassifier) {
        this.classesClassifier = classesClassifier;
    }

    public boolean isFailOnMissingWebXml() {
        return this.failOnMissingWebXml;
    }

    public void setFailOnMissingWebXml(boolean failOnMissingWebXml) {
        this.failOnMissingWebXml = failOnMissingWebXml;
    }
}

