/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.war.Overlay;
import org.apache.maven.plugin.war.overlay.OverlayManager;
import org.apache.maven.plugin.war.packaging.CopyUserManifestTask;
import org.apache.maven.plugin.war.packaging.DependenciesAnalysisPackagingTask;
import org.apache.maven.plugin.war.packaging.OverlayPackagingTask;
import org.apache.maven.plugin.war.packaging.SaveWebappStructurePostPackagingTask;
import org.apache.maven.plugin.war.packaging.WarPackagingContext;
import org.apache.maven.plugin.war.packaging.WarPackagingTask;
import org.apache.maven.plugin.war.packaging.WarPostPackagingTask;
import org.apache.maven.plugin.war.packaging.WarProjectPackagingTask;
import org.apache.maven.plugin.war.util.WebappStructure;
import org.apache.maven.plugin.war.util.WebappStructureSerializer;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.AbstractMavenFilteringRequest;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWarMojo
extends AbstractMojo {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String META_INF = "META-INF";
    private static final String WEB_INF = "WEB-INF";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    private File classesDirectory;
    @Parameter(property="archiveClasses", defaultValue="false")
    private boolean archiveClasses;
    @Parameter(property="resourceEncoding", defaultValue="${project.build.sourceEncoding}")
    private String resourceEncoding;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}", required=true)
    private File webappDirectory;
    @Parameter(defaultValue="${basedir}/src/main/webapp", required=true)
    private File warSourceDirectory;
    @Parameter
    private Resource[] webResources;
    @Parameter
    private List<String> filters;
    @Parameter(property="maven.war.webxml")
    private File webXml;
    @Parameter(property="maven.war.containerConfigXML")
    private File containerConfigXML;
    @Parameter(defaultValue="${project.build.directory}/war/work", required=true)
    private File workDirectory;
    @Parameter
    private String outputFileNameMapping;
    @Parameter(defaultValue="${project.build.directory}/war/work/webapp-cache.xml", required=true)
    private File cacheFile;
    @Parameter(property="useCache", defaultValue="false")
    private boolean useCache = false;
    @Component(role=ArtifactFactory.class)
    private ArtifactFactory artifactFactory;
    @Component(role=ArchiverManager.class)
    private ArchiverManager archiverManager;
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    private MavenResourcesFiltering mavenResourcesFiltering;
    @Parameter(alias="includes", defaultValue="**")
    private String warSourceIncludes;
    @Parameter(alias="excludes")
    private String warSourceExcludes;
    @Parameter
    private String dependentWarIncludes = "**/**";
    @Parameter
    private String dependentWarExcludes = "META-INF/**";
    @Parameter
    private List<Overlay> overlays = new ArrayList<Overlay>();
    @Parameter
    private List<String> nonFilteredFileExtensions;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="maven.war.filteringDeploymentDescriptors", defaultValue="false")
    private boolean filteringDeploymentDescriptors = false;
    @Parameter(property="maven.war.escapedBackslashesInFilePath", defaultValue="false")
    private boolean escapedBackslashesInFilePath = false;
    @Parameter(property="maven.war.escapeString")
    protected String escapeString;
    @Parameter(defaultValue="true")
    private boolean recompressZippedFiles;
    @Parameter(defaultValue="false")
    private boolean includeEmptyDirectories;
    @Parameter(property="maven.war.supportMultiLineFiltering", defaultValue="false")
    private boolean supportMultiLineFiltering = false;
    @Parameter(property="maven.war.useJvmChmod", defaultValue="true")
    private boolean useJvmChmod;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private final WebappStructureSerializer webappStructureSerialier = new WebappStructureSerializer();
    private final Overlay currentProjectOverlay = Overlay.createInstance();

    public Overlay getCurrentProjectOverlay() {
        return this.currentProjectOverlay;
    }

    protected String[] getExcludes() {
        ArrayList<String> excludeList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.warSourceExcludes)) {
            excludeList.addAll(Arrays.asList(StringUtils.split((String)this.warSourceExcludes, (String)",")));
        }
        if (this.webXml != null && StringUtils.isNotEmpty((String)this.webXml.getName())) {
            excludeList.add("**/WEB-INF/web.xml");
        }
        if (this.containerConfigXML != null && StringUtils.isNotEmpty((String)this.containerConfigXML.getName())) {
            excludeList.add("**/META-INF/" + this.containerConfigXML.getName());
        }
        return excludeList.toArray(new String[excludeList.size()]);
    }

    protected String[] getIncludes() {
        return StringUtils.split((String)StringUtils.defaultString((Object)this.warSourceIncludes), (String)",");
    }

    protected String[] getDependentWarExcludes() {
        String[] excludes = StringUtils.isNotEmpty((String)this.dependentWarExcludes) ? StringUtils.split((String)this.dependentWarExcludes, (String)",") : EMPTY_STRING_ARRAY;
        return excludes;
    }

    protected String[] getDependentWarIncludes() {
        return StringUtils.split((String)StringUtils.defaultString((Object)this.dependentWarIncludes), (String)",");
    }

    public void buildExplodedWebapp(File webapplicationDirectory) throws MojoExecutionException, MojoFailureException {
        webapplicationDirectory.mkdirs();
        try {
            this.buildWebapp(this.project, webapplicationDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not build webapp", (Exception)e);
        }
    }

    public void buildWebapp(MavenProject mavenProject, File webapplicationDirectory) throws MojoExecutionException, MojoFailureException, IOException {
        List defaultFilterWrappers;
        WebappStructure cache = this.useCache && this.cacheFile.exists() ? new WebappStructure(mavenProject.getDependencies(), this.webappStructureSerialier.fromXml(this.cacheFile)) : new WebappStructure(mavenProject.getDependencies(), null);
        long startTime = System.currentTimeMillis();
        this.getLog().info((CharSequence)("Assembling webapp [" + mavenProject.getArtifactId() + "] in [" + webapplicationDirectory + "]"));
        OverlayManager overlayManager = new OverlayManager(this.overlays, mavenProject, this.dependentWarIncludes, this.dependentWarExcludes, this.currentProjectOverlay);
        List<WarPackagingTask> packagingTasks = this.getPackagingTasks(overlayManager);
        try {
            MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution();
            mavenResourcesExecution.setEscapeString(this.escapeString);
            mavenResourcesExecution.setSupportMultiLineFiltering(this.supportMultiLineFiltering);
            mavenResourcesExecution.setMavenProject(mavenProject);
            if (this.filters == null) {
                this.filters = this.getProject().getBuild().getFilters();
            }
            mavenResourcesExecution.setFilters(this.filters);
            mavenResourcesExecution.setEscapedBackslashesInFilePath(this.escapedBackslashesInFilePath);
            mavenResourcesExecution.setMavenSession(this.session);
            mavenResourcesExecution.setEscapeString(this.escapeString);
            mavenResourcesExecution.setSupportMultiLineFiltering(this.supportMultiLineFiltering);
            defaultFilterWrappers = this.mavenFileFilter.getDefaultFilterWrappers((AbstractMavenFilteringRequest)mavenResourcesExecution);
        }
        catch (MavenFilteringException e) {
            this.getLog().error((CharSequence)("fail to build filering wrappers " + e.getMessage()));
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        DefaultWarPackagingContext context = new DefaultWarPackagingContext(webapplicationDirectory, cache, overlayManager, defaultFilterWrappers, this.getNonFilteredFileExtensions(), this.filteringDeploymentDescriptors, this.artifactFactory, this.resourceEncoding, this.useJvmChmod);
        for (WarPackagingTask warPackagingTask : packagingTasks) {
            warPackagingTask.performPackaging(context);
        }
        List<WarPostPackagingTask> postPackagingTasks = this.getPostPackagingTasks();
        for (WarPostPackagingTask task : postPackagingTasks) {
            task.performPostPackaging(context);
        }
        this.getLog().info((CharSequence)("Webapp assembled in [" + (System.currentTimeMillis() - startTime) + " msecs]"));
    }

    private List<WarPackagingTask> getPackagingTasks(OverlayManager overlayManager) throws MojoExecutionException {
        ArrayList<WarPackagingTask> packagingTasks = new ArrayList<WarPackagingTask>();
        packagingTasks.add(new CopyUserManifestTask());
        if (this.useCache) {
            packagingTasks.add(new DependenciesAnalysisPackagingTask());
        }
        List<Overlay> resolvedOverlays = overlayManager.getOverlays();
        for (Overlay overlay : resolvedOverlays) {
            if (overlay.isCurrentProject()) {
                packagingTasks.add(new WarProjectPackagingTask(this.webResources, this.webXml, this.containerConfigXML, this.currentProjectOverlay));
                continue;
            }
            packagingTasks.add(new OverlayPackagingTask(overlay, this.currentProjectOverlay));
        }
        return packagingTasks;
    }

    private List<WarPostPackagingTask> getPostPackagingTasks() {
        ArrayList<WarPostPackagingTask> postPackagingTasks = new ArrayList<WarPostPackagingTask>();
        if (this.useCache) {
            postPackagingTasks.add(new SaveWebappStructurePostPackagingTask(this.cacheFile));
        }
        return postPackagingTasks;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public File getWebappDirectory() {
        return this.webappDirectory;
    }

    public void setWebappDirectory(File webappDirectory) {
        this.webappDirectory = webappDirectory;
    }

    public File getWarSourceDirectory() {
        return this.warSourceDirectory;
    }

    public void setWarSourceDirectory(File warSourceDirectory) {
        this.warSourceDirectory = warSourceDirectory;
    }

    public File getWebXml() {
        return this.webXml;
    }

    public void setWebXml(File webXml) {
        this.webXml = webXml;
    }

    public File getContainerConfigXML() {
        return this.containerConfigXML;
    }

    public void setContainerConfigXML(File containerConfigXML) {
        this.containerConfigXML = containerConfigXML;
    }

    public String getOutputFileNameMapping() {
        return this.outputFileNameMapping;
    }

    public void setOutputFileNameMapping(String outputFileNameMapping) {
        this.outputFileNameMapping = outputFileNameMapping;
    }

    public List<Overlay> getOverlays() {
        return this.overlays;
    }

    public void setOverlays(List<Overlay> overlays) {
        this.overlays = overlays;
    }

    public void addOverlay(Overlay overlay) {
        this.overlays.add(overlay);
    }

    public boolean isArchiveClasses() {
        return this.archiveClasses;
    }

    public void setArchiveClasses(boolean archiveClasses) {
        this.archiveClasses = archiveClasses;
    }

    public JarArchiver getJarArchiver() {
        return this.jarArchiver;
    }

    public void setJarArchiver(JarArchiver jarArchiver) {
        this.jarArchiver = jarArchiver;
    }

    public Resource[] getWebResources() {
        return this.webResources;
    }

    public void setWebResources(Resource[] webResources) {
        this.webResources = webResources;
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    public File getWorkDirectory() {
        return this.workDirectory;
    }

    public void setWorkDirectory(File workDirectory) {
        this.workDirectory = workDirectory;
    }

    public File getCacheFile() {
        return this.cacheFile;
    }

    public void setCacheFile(File cacheFile) {
        this.cacheFile = cacheFile;
    }

    public String getWarSourceIncludes() {
        return this.warSourceIncludes;
    }

    public void setWarSourceIncludes(String warSourceIncludes) {
        this.warSourceIncludes = warSourceIncludes;
    }

    public String getWarSourceExcludes() {
        return this.warSourceExcludes;
    }

    public void setWarSourceExcludes(String warSourceExcludes) {
        this.warSourceExcludes = warSourceExcludes;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public MavenArchiveConfiguration getArchive() {
        return this.archive;
    }

    public List<String> getNonFilteredFileExtensions() {
        return this.nonFilteredFileExtensions;
    }

    public void setNonFilteredFileExtensions(List<String> nonFilteredFileExtensions) {
        this.nonFilteredFileExtensions = nonFilteredFileExtensions;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    protected MavenSession getSession() {
        return this.session;
    }

    protected boolean isRecompressZippedFiles() {
        return this.recompressZippedFiles;
    }

    protected boolean isIncludeEmptyDirectories() {
        return this.includeEmptyDirectories;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultWarPackagingContext
    implements WarPackagingContext {
        private final ArtifactFactory artifactFactory;
        private final String resourceEncoding;
        private final WebappStructure webappStructure;
        private final File webappDirectory;
        private final OverlayManager overlayManager;
        private final List<FileUtils.FilterWrapper> filterWrappers;
        private List<String> nonFilteredFileExtensions;
        private boolean filteringDeploymentDescriptors;
        private boolean useJvmChmod = true;

        public DefaultWarPackagingContext(File webappDirectory, WebappStructure webappStructure, OverlayManager overlayManager, List<FileUtils.FilterWrapper> filterWrappers, List<String> nonFilteredFileExtensions, boolean filteringDeploymentDescriptors, ArtifactFactory artifactFactory, String resourceEncoding, boolean useJvmChmod) {
            this.webappDirectory = webappDirectory;
            this.webappStructure = webappStructure;
            this.overlayManager = overlayManager;
            this.filterWrappers = filterWrappers;
            this.artifactFactory = artifactFactory;
            this.filteringDeploymentDescriptors = filteringDeploymentDescriptors;
            this.nonFilteredFileExtensions = nonFilteredFileExtensions == null ? Collections.emptyList() : nonFilteredFileExtensions;
            this.resourceEncoding = resourceEncoding;
            for (String overlayId : overlayManager.getOverlayIds()) {
                webappStructure.getStructure(overlayId);
            }
            this.useJvmChmod = useJvmChmod;
        }

        @Override
        public MavenProject getProject() {
            return AbstractWarMojo.this.project;
        }

        @Override
        public File getWebappDirectory() {
            return this.webappDirectory;
        }

        @Override
        public File getClassesDirectory() {
            return AbstractWarMojo.this.classesDirectory;
        }

        @Override
        public Log getLog() {
            return AbstractWarMojo.this.getLog();
        }

        @Override
        public String getOutputFileNameMapping() {
            return AbstractWarMojo.this.outputFileNameMapping;
        }

        @Override
        public File getWebappSourceDirectory() {
            return AbstractWarMojo.this.warSourceDirectory;
        }

        @Override
        public String[] getWebappSourceIncludes() {
            return AbstractWarMojo.this.getIncludes();
        }

        @Override
        public String[] getWebappSourceExcludes() {
            return AbstractWarMojo.this.getExcludes();
        }

        @Override
        public boolean isWebappSourceIncludeEmptyDirectories() {
            return AbstractWarMojo.this.includeEmptyDirectories;
        }

        @Override
        public boolean archiveClasses() {
            return AbstractWarMojo.this.archiveClasses;
        }

        @Override
        public File getOverlaysWorkDirectory() {
            return AbstractWarMojo.this.workDirectory;
        }

        @Override
        public ArchiverManager getArchiverManager() {
            return AbstractWarMojo.this.archiverManager;
        }

        @Override
        public MavenArchiveConfiguration getArchive() {
            return AbstractWarMojo.this.archive;
        }

        @Override
        public JarArchiver getJarArchiver() {
            return AbstractWarMojo.this.jarArchiver;
        }

        @Override
        public List<String> getFilters() {
            return AbstractWarMojo.this.filters;
        }

        @Override
        public WebappStructure getWebappStructure() {
            return this.webappStructure;
        }

        @Override
        public List<String> getOwnerIds() {
            return this.overlayManager.getOverlayIds();
        }

        @Override
        public MavenFileFilter getMavenFileFilter() {
            return AbstractWarMojo.this.mavenFileFilter;
        }

        @Override
        public List<FileUtils.FilterWrapper> getFilterWrappers() {
            return this.filterWrappers;
        }

        @Override
        public boolean isNonFilteredExtension(String fileName) {
            return !AbstractWarMojo.this.mavenResourcesFiltering.filteredFileExtension(fileName, this.nonFilteredFileExtensions);
        }

        @Override
        public boolean isFilteringDeploymentDescriptors() {
            return this.filteringDeploymentDescriptors;
        }

        @Override
        public ArtifactFactory getArtifactFactory() {
            return this.artifactFactory;
        }

        @Override
        public MavenSession getSession() {
            return AbstractWarMojo.this.session;
        }

        @Override
        public String getResourceEncoding() {
            return this.resourceEncoding;
        }

        @Override
        public boolean isUseJvmChmod() {
            return this.useJvmChmod;
        }
    }
}

