/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.booterclient.output.NativeStdOutStreamConsumer;
import org.apache.maven.plugin.surefire.extensions.EventConsumerThread;
import org.apache.maven.plugin.surefire.extensions.InvalidSessionIdException;
import org.apache.maven.plugin.surefire.extensions.StreamFeeder;
import org.apache.maven.surefire.api.event.Event;
import org.apache.maven.surefire.api.fork.ForkNodeArguments;
import org.apache.maven.surefire.api.util.internal.Channels;
import org.apache.maven.surefire.api.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.extensions.CloseableDaemonThread;
import org.apache.maven.surefire.extensions.CommandReader;
import org.apache.maven.surefire.extensions.EventHandler;
import org.apache.maven.surefire.extensions.ForkChannel;
import org.apache.maven.surefire.extensions.util.CountDownLauncher;
import org.apache.maven.surefire.extensions.util.CountdownCloseable;
import org.apache.maven.surefire.extensions.util.LineConsumerThread;
import org.apache.maven.surefire.shared.lang3.StringUtils;

final class SurefireForkChannel
extends ForkChannel {
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool(DaemonThreadFactory.newDaemonThreadFactory());
    private final AsynchronousServerSocketChannel server;
    private final String localHost;
    private final int localPort;
    private final String sessionId;
    private final Bindings bindings = new Bindings(2);
    private volatile Future<AsynchronousSocketChannel> session;
    private volatile LineConsumerThread out;
    private volatile CloseableDaemonThread commandReaderBindings;
    private volatile CloseableDaemonThread eventHandlerBindings;
    private volatile EventBindings eventBindings;
    private volatile CommandBindings commandBindings;

    SurefireForkChannel(@Nonnull ForkNodeArguments arguments) throws IOException {
        super(arguments);
        this.server = AsynchronousServerSocketChannel.open(AsynchronousChannelGroup.withThreadPool(THREAD_POOL));
        this.setTrueOptions(StandardSocketOptions.SO_REUSEADDR, StandardSocketOptions.TCP_NODELAY, StandardSocketOptions.SO_KEEPALIVE);
        InetAddress ip = InetAddress.getLoopbackAddress();
        this.server.bind(new InetSocketAddress(ip, 0), 1);
        InetSocketAddress localAddress = (InetSocketAddress)this.server.getLocalAddress();
        this.localHost = localAddress.getHostString();
        this.localPort = localAddress.getPort();
        this.sessionId = arguments.getSessionId();
    }

    public void tryConnectToClient() {
        if (this.session != null) {
            throw new IllegalStateException("already accepted TCP client connection");
        }
        this.session = this.server.accept();
    }

    public String getForkNodeConnectionString() {
        return "tcp://" + this.localHost + ":" + this.localPort + (StringUtils.isBlank((CharSequence)this.sessionId) ? "" : "?sessionId=" + this.sessionId);
    }

    public int getCountdownCloseablePermits() {
        return 3;
    }

    public void bindCommandReader(@Nonnull CommandReader commands, WritableByteChannel stdIn) throws IOException, InterruptedException {
        this.commandBindings = new CommandBindings(commands);
        this.bindings.countDown();
    }

    public void bindEventHandler(@Nonnull EventHandler<Event> eventHandler, @Nonnull CountdownCloseable countdown, ReadableByteChannel stdOut) throws IOException, InterruptedException {
        ForkNodeArguments args = this.getArguments();
        this.out = new LineConsumerThread("fork-" + args.getForkChannelId() + "-out-thread", stdOut, (EventHandler)new NativeStdOutStreamConsumer(args.getConsoleLock()), countdown);
        this.out.start();
        this.eventBindings = new EventBindings(eventHandler, countdown);
        this.bindings.countDown();
    }

    public void disable() {
        if (this.eventHandlerBindings != null) {
            this.eventHandlerBindings.disable();
        }
        if (this.commandReaderBindings != null) {
            this.commandReaderBindings.disable();
        }
    }

    public void close() throws IOException {
        try (AsynchronousSocketChannel c1 = this.getChannel();
             AsynchronousServerSocketChannel c2 = this.server;){
            LineConsumerThread c3 = this.out;
            if (c3 != null) {
                c3.close();
            }
        }
        catch (InterruptedException e) {
            Throwable cause = e.getCause();
            throw cause instanceof IOException ? (IOException)cause : new IOException(cause);
        }
    }

    private void verifySessionId() throws InterruptedException, IOException {
        try {
            int read;
            ByteBuffer buffer = ByteBuffer.allocate(this.sessionId.length());
            while ((read = this.getChannel().read(buffer).get().intValue()) != -1 && buffer.hasRemaining()) {
            }
            if (read == -1) {
                throw new IOException("Channel closed while verifying the client.");
            }
            ((Buffer)buffer).flip();
            String clientSessionId = new String(buffer.array(), StandardCharsets.US_ASCII);
            if (!clientSessionId.equals(this.sessionId)) {
                throw new InvalidSessionIdException(clientSessionId, this.sessionId);
            }
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw cause instanceof IOException ? (IOException)cause : new IOException(cause);
        }
    }

    @SafeVarargs
    private final void setTrueOptions(SocketOption<Boolean> ... options) throws IOException {
        for (SocketOption<Boolean> option : options) {
            if (!this.server.supportedOptions().contains(option)) continue;
            this.server.setOption((SocketOption)option, (Object)true);
        }
    }

    private AsynchronousSocketChannel getChannel() throws InterruptedException, IOException {
        try {
            return this.session == null ? null : this.session.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw cause instanceof IOException ? (IOException)cause : new IOException(cause);
        }
    }

    private class CommandBindings {
        private final CommandReader commands;

        private CommandBindings(CommandReader commands) {
            this.commands = commands;
        }

        void bindCommandSender(AsynchronousSocketChannel source) {
            ForkNodeArguments args = SurefireForkChannel.this.getArguments();
            WritableByteChannel channel = Channels.newChannel((OutputStream)Channels.newOutputStream((AsynchronousByteChannel)source));
            String threadName = "commands-fork-" + args.getForkChannelId();
            SurefireForkChannel.this.commandReaderBindings = new StreamFeeder(threadName, channel, this.commands, args.getConsoleLogger());
            SurefireForkChannel.this.commandReaderBindings.start();
        }
    }

    private class EventBindings {
        private final EventHandler<Event> eventHandler;
        private final CountdownCloseable countdown;

        private EventBindings(EventHandler<Event> eventHandler, CountdownCloseable countdown) {
            this.eventHandler = eventHandler;
            this.countdown = countdown;
        }

        void bindEventHandler(AsynchronousSocketChannel source) {
            ForkNodeArguments args = SurefireForkChannel.this.getArguments();
            String threadName = "fork-" + args.getForkChannelId() + "-event-thread";
            ReadableByteChannel channel = Channels.newBufferedChannel((InputStream)Channels.newInputStream((AsynchronousByteChannel)source));
            SurefireForkChannel.this.eventHandlerBindings = new EventConsumerThread(threadName, channel, this.eventHandler, this.countdown, args);
            SurefireForkChannel.this.eventHandlerBindings.start();
        }
    }

    private class Bindings
    extends CountDownLauncher {
        private Bindings(int count) {
            super(count);
        }

        protected void job() throws IOException, InterruptedException {
            AsynchronousSocketChannel channel = SurefireForkChannel.this.getChannel();
            if (StringUtils.isNotBlank((CharSequence)SurefireForkChannel.this.sessionId)) {
                SurefireForkChannel.this.verifySessionId();
            }
            SurefireForkChannel.this.eventBindings.bindEventHandler(channel);
            SurefireForkChannel.this.commandBindings.bindCommandSender(channel);
        }
    }
}

