/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.bio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.bio.SocketEndPoint;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.log.Log;

public class SocketConnector
extends AbstractConnector {
    protected ServerSocket _serverSocket;
    protected final Set<EndPoint> _connections = new HashSet<EndPoint>();
    protected volatile int _localPort = -1;

    public Object getConnection() {
        return this._serverSocket;
    }

    public void open() throws IOException {
        if (this._serverSocket == null || this._serverSocket.isClosed()) {
            this._serverSocket = this.newServerSocket(this.getHost(), this.getPort(), this.getAcceptQueueSize());
        }
        this._serverSocket.setReuseAddress(this.getReuseAddress());
        this._localPort = this._serverSocket.getLocalPort();
        if (this._localPort <= 0) {
            throw new IllegalStateException("port not allocated for " + this);
        }
    }

    protected ServerSocket newServerSocket(String host, int port, int backlog) throws IOException {
        ServerSocket ss = host == null ? new ServerSocket(port, backlog) : new ServerSocket(port, backlog, InetAddress.getByName(host));
        return ss;
    }

    public void close() throws IOException {
        if (this._serverSocket != null) {
            this._serverSocket.close();
        }
        this._serverSocket = null;
        this._localPort = -2;
    }

    public void accept(int acceptorID) throws IOException, InterruptedException {
        Socket socket = this._serverSocket.accept();
        this.configure(socket);
        ConnectorEndPoint connection = new ConnectorEndPoint(socket);
        connection.dispatch();
    }

    protected Connection newConnection(EndPoint endpoint) {
        return new HttpConnection(this, endpoint, this.getServer());
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        ConnectorEndPoint connection = (ConnectorEndPoint)endpoint;
        int lrmit = this.isLowResources() ? this._lowResourceMaxIdleTime : this._maxIdleTime;
        connection.setMaxIdleTime(lrmit);
        super.customize(endpoint, request);
    }

    public int getLocalPort() {
        return this._localPort;
    }

    protected void doStart() throws Exception {
        this._connections.clear();
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        HashSet<EndPoint> set = null;
        Set<EndPoint> set2 = this._connections;
        synchronized (set2) {
            set = new HashSet<EndPoint>(this._connections);
        }
        for (ConnectorEndPoint connectorEndPoint : set) {
            connectorEndPoint.close();
        }
    }

    protected class ConnectorEndPoint
    extends SocketEndPoint
    implements Runnable,
    ConnectedEndPoint {
        boolean _dispatched;
        volatile Connection _connection;
        protected final Socket _socket;

        public ConnectorEndPoint(Socket socket) throws IOException {
            super(socket, SocketConnector.this._maxIdleTime);
            this._dispatched = false;
            this._connection = SocketConnector.this.newConnection((EndPoint)this);
            this._socket = socket;
        }

        public Connection getConnection() {
            return this._connection;
        }

        public void setConnection(Connection connection) {
            if (this._connection != connection) {
                SocketConnector.this.connectionUpgraded(this._connection, connection);
            }
            this._connection = connection;
        }

        public void dispatch() throws IOException {
            if (SocketConnector.this.getThreadPool() == null || !SocketConnector.this.getThreadPool().dispatch((Runnable)this)) {
                Log.warn((String)"dispatch failed for {}", (Object)this._connection);
                this.close();
            }
        }

        public int fill(Buffer buffer) throws IOException {
            int l = super.fill(buffer);
            if (l < 0) {
                this.close();
            }
            return l;
        }

        public void close() throws IOException {
            if (this._connection instanceof HttpConnection) {
                ((HttpConnection)this._connection).getRequest().getAsyncContinuation().cancel();
            }
            super.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block50: {
                SocketConnector.this.connectionOpened(this._connection);
                Set<EndPoint> set = SocketConnector.this._connections;
                synchronized (set) {
                    SocketConnector.this._connections.add((EndPoint)this);
                }
                while (SocketConnector.this.isStarted() && !this.isClosed()) {
                    if (this._connection.isIdle() && SocketConnector.this.isLowResources()) {
                        this.setMaxIdleTime(SocketConnector.this.getLowResourcesMaxIdleTime());
                    }
                    this._connection = this._connection.handle();
                }
                Object var4_9 = null;
                SocketConnector.this.connectionClosed(this._connection);
                Set<EndPoint> set2 = SocketConnector.this._connections;
                synchronized (set2) {
                    SocketConnector.this._connections.remove(this);
                }
                try {
                    if (!this._socket.isClosed()) {
                        long timestamp = System.currentTimeMillis();
                        int max_idle = this.getMaxIdleTime();
                        this._socket.setSoTimeout(this.getMaxIdleTime());
                        int c = 0;
                        while ((c = this._socket.getInputStream().read()) >= 0 && System.currentTimeMillis() - timestamp < (long)max_idle) {
                        }
                        if (!this._socket.isClosed()) {
                            this._socket.close();
                        }
                    }
                    break block50;
                }
                catch (IOException e2) {
                    Log.ignore((Throwable)e2);
                }
                break block50;
                {
                    catch (EofException e) {
                        Log.debug((String)"EOF", (Object)((Object)e));
                        try {
                            this.close();
                        }
                        catch (IOException e2) {
                            Log.ignore((Throwable)e2);
                        }
                        Object var4_10 = null;
                        SocketConnector.this.connectionClosed(this._connection);
                        Set<EndPoint> set3 = SocketConnector.this._connections;
                        synchronized (set3) {
                            SocketConnector.this._connections.remove(this);
                        }
                        try {
                            if (!this._socket.isClosed()) {
                                long timestamp = System.currentTimeMillis();
                                int max_idle = this.getMaxIdleTime();
                                this._socket.setSoTimeout(this.getMaxIdleTime());
                                int c = 0;
                                while ((c = this._socket.getInputStream().read()) >= 0 && System.currentTimeMillis() - timestamp < (long)max_idle) {
                                }
                                if (!this._socket.isClosed()) {
                                    this._socket.close();
                                }
                            }
                            break block50;
                        }
                        catch (IOException e2) {
                            Log.ignore((Throwable)e2);
                        }
                        break block50;
                    }
                    catch (HttpException e) {
                        Log.debug((String)"BAD", (Object)((Object)e));
                        try {
                            this.close();
                        }
                        catch (IOException e2) {
                            Log.ignore((Throwable)e2);
                        }
                        Object var4_11 = null;
                        SocketConnector.this.connectionClosed(this._connection);
                        Set<EndPoint> set4 = SocketConnector.this._connections;
                        synchronized (set4) {
                            SocketConnector.this._connections.remove(this);
                        }
                        try {
                            if (!this._socket.isClosed()) {
                                long timestamp = System.currentTimeMillis();
                                int max_idle = this.getMaxIdleTime();
                                this._socket.setSoTimeout(this.getMaxIdleTime());
                                int c = 0;
                                while ((c = this._socket.getInputStream().read()) >= 0 && System.currentTimeMillis() - timestamp < (long)max_idle) {
                                }
                                if (!this._socket.isClosed()) {
                                    this._socket.close();
                                }
                            }
                            break block50;
                        }
                        catch (IOException e2) {
                            Log.ignore((Throwable)e2);
                        }
                        break block50;
                    }
                    catch (Exception e) {
                        Log.warn((String)"handle failed?", (Throwable)e);
                        try {
                            this.close();
                        }
                        catch (IOException e2) {
                            Log.ignore((Throwable)e2);
                        }
                        Object var4_12 = null;
                        SocketConnector.this.connectionClosed(this._connection);
                        Set<EndPoint> set5 = SocketConnector.this._connections;
                        synchronized (set5) {
                            SocketConnector.this._connections.remove(this);
                        }
                        try {
                            if (!this._socket.isClosed()) {
                                long timestamp = System.currentTimeMillis();
                                int max_idle = this.getMaxIdleTime();
                                this._socket.setSoTimeout(this.getMaxIdleTime());
                                int c = 0;
                                while ((c = this._socket.getInputStream().read()) >= 0 && System.currentTimeMillis() - timestamp < (long)max_idle) {
                                }
                                if (!this._socket.isClosed()) {
                                    this._socket.close();
                                }
                            }
                            break block50;
                        }
                        catch (IOException e2) {
                            Log.ignore((Throwable)e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var4_13 = null;
                    SocketConnector.this.connectionClosed(this._connection);
                    Set<EndPoint> set6 = SocketConnector.this._connections;
                    synchronized (set6) {
                        SocketConnector.this._connections.remove(this);
                    }
                    try {
                        if (!this._socket.isClosed()) {
                            long timestamp = System.currentTimeMillis();
                            int max_idle = this.getMaxIdleTime();
                            this._socket.setSoTimeout(this.getMaxIdleTime());
                            int c = 0;
                            while ((c = this._socket.getInputStream().read()) >= 0 && System.currentTimeMillis() - timestamp < (long)max_idle) {
                            }
                            if (!this._socket.isClosed()) {
                                this._socket.close();
                            }
                        }
                    }
                    catch (IOException e2) {
                        Log.ignore((Throwable)e2);
                    }
                    throw throwable;
                }
            }
        }
    }
}

