/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.controller.db;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.evomaster.clientJava.controller.db.DataRow;
import org.evomaster.clientJava.controller.db.VariableDescriptor;

public class QueryResult {
    private final List<VariableDescriptor> variableDescriptors = new ArrayList<VariableDescriptor>();
    private final List<DataRow> rows = new ArrayList<DataRow>();

    public QueryResult(List<String> names) {
        Objects.requireNonNull(names);
        for (String n : names) {
            this.variableDescriptors.add(new VariableDescriptor(n));
        }
    }

    public QueryResult(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            ResultSetMetaData md = resultSet.getMetaData();
            for (int i = 0; i < md.getColumnCount(); ++i) {
                int index = i + 1;
                VariableDescriptor desc = new VariableDescriptor(md.getColumnName(index), md.getColumnLabel(index), md.getTableName(index));
                this.variableDescriptors.add(desc);
            }
            while (resultSet.next()) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (int i = 0; i < md.getColumnCount(); ++i) {
                    Object value = resultSet.getObject(i + 1);
                    row.add(value);
                }
                this.rows.add(new DataRow(this.variableDescriptors, row));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addRow(DataRow row) {
        if (!this.sameVariableNames(row)) {
            throw new IllegalArgumentException("Variable name mismatch");
        }
        this.rows.add(row);
    }

    public boolean sameVariableNames(DataRow row) {
        if (this.variableDescriptors.size() != row.getVariableDescriptors().size()) {
            return false;
        }
        for (int i = 0; i < this.variableDescriptors.size(); ++i) {
            VariableDescriptor b;
            VariableDescriptor a = this.variableDescriptors.get(i);
            if (a.equals(b = row.getVariableDescriptors().get(i))) continue;
            return false;
        }
        return true;
    }

    public List<DataRow> seeRows() {
        return this.rows;
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public int size() {
        return this.rows.size();
    }

    public String toString() {
        if (this.variableDescriptors.isEmpty()) {
            return "EMPTY";
        }
        String header = String.join((CharSequence)",", this.variableDescriptors.stream().map(d -> d.toString()).collect(Collectors.toList()));
        return header + String.join((CharSequence)"", this.rows.stream().map(r -> "\n" + r.getAsLine()).collect(Collectors.toList()));
    }
}

