/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.instrumentation;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.evomaster.clientJava.instrumentation.ClassName;
import org.evomaster.clientJava.instrumentation.ClassesToExclude;
import org.evomaster.clientJava.instrumentation.ComputeClassWriter;
import org.evomaster.clientJava.instrumentation.testability.ReplacementList;
import org.evomaster.clientJava.instrumentation.visitor.CoverageClassVisitor;
import shaded.org.objectweb.asm.ClassReader;
import shaded.org.objectweb.asm.ClassVisitor;
import shaded.org.objectweb.asm.tree.ClassNode;

public class Instrumentator {
    private final List<String> prefixes;

    public Instrumentator(String packagePrefixesToCover) {
        Objects.requireNonNull(packagePrefixesToCover);
        this.prefixes = Arrays.asList(packagePrefixesToCover.split(",")).stream().map(s -> s.trim()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (this.prefixes.isEmpty()) {
            throw new IllegalArgumentException("You have to specify at least one non-empty prefix, e.g. 'com.yourapplication'");
        }
    }

    public byte[] transformBytes(ClassLoader classLoader, ClassName className, ClassReader reader) {
        ComputeClassWriter writer;
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(className);
        Objects.requireNonNull(reader);
        if (!ClassesToExclude.checkIfCanInstrument(className)) {
            throw new IllegalArgumentException("Cannot instrument " + className);
        }
        int asmFlags = 2;
        ClassVisitor cv = writer = new ComputeClassWriter(asmFlags);
        int readFlags = 4;
        if (this.canInstrumentForCoverage(className)) {
            ClassNode cn = new ClassNode();
            reader.accept(cn, readFlags);
            ReplacementList.getBooleanMethodTransformers().forEach(t -> t.transformClass(cn));
            cv = new CoverageClassVisitor(cv, className);
            cn.accept(cv);
        } else {
            reader.accept(cv, readFlags);
        }
        return writer.toByteArray();
    }

    private boolean canInstrumentForCoverage(ClassName className) {
        return this.prefixes.stream().anyMatch(s -> className.getFullNameWithDots().startsWith((String)s));
    }
}

