/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.instrumentation.testability;

import java.util.Objects;
import org.evomaster.clientJava.instrumentation.testability.BooleanMethodTransformer;
import org.evomaster.clientJava.instrumentation.testability.BooleanReplacement;

public class StringTransformer
extends BooleanMethodTransformer {
    public StringTransformer() {
        super(String.class);
    }

    @BooleanReplacement
    public static int equals(String caller, Object anObject) {
        Objects.requireNonNull(caller);
        if (anObject == null || !(anObject instanceof String)) {
            return -2147483645;
        }
        if (caller.equals(anObject)) {
            return 0x7FFFFFFD;
        }
        long distance = StringTransformer.getLeftAlignmentDistance(caller, anObject.toString());
        return StringTransformer.truncate(-distance);
    }

    @BooleanReplacement
    public static int equalsIgnoreCase(String caller, String anotherString) {
        Objects.requireNonNull(caller);
        if (anotherString == null) {
            return -2147483645;
        }
        if (caller.equalsIgnoreCase(anotherString)) {
            return 0x7FFFFFFD;
        }
        return StringTransformer.equals(caller.toLowerCase(), anotherString.toLowerCase());
    }

    @BooleanReplacement
    public static int startsWith(String caller, String prefix, int toffset) {
        int pl;
        Objects.requireNonNull(caller);
        Objects.requireNonNull(prefix);
        int penalty = pl = prefix.length();
        if (caller.length() < pl) {
            penalty += pl - caller.length();
        }
        if (toffset < 0) {
            long dist = (-toffset + penalty) * 65535;
            return StringTransformer.truncate(-dist);
        }
        if (toffset > caller.length() - pl) {
            assert (toffset >= 0);
            long dist = (toffset + penalty) * 65535;
            return StringTransformer.truncate(-dist);
        }
        int len = Math.min(prefix.length(), caller.length());
        String sub = caller.substring(toffset, Math.min(toffset + len, caller.length()));
        return StringTransformer.equals(sub, prefix);
    }

    @BooleanReplacement
    public static int startsWith(String caller, String prefix) {
        return StringTransformer.startsWith(caller, prefix, 0);
    }

    @BooleanReplacement
    public static int endsWith(String caller, String suffix) {
        return StringTransformer.startsWith(caller, suffix, caller.length() - suffix.length());
    }

    @BooleanReplacement
    public static int isEmpty(String caller) {
        Objects.requireNonNull(caller);
        int len = caller.length();
        if (len == 0) {
            return 0x7FFFFFFD;
        }
        return -len;
    }

    @BooleanReplacement
    public static int contentEquals(String caller, CharSequence cs) {
        return StringTransformer.equals(caller, cs.toString());
    }

    @BooleanReplacement
    public static int contentEquals(String caller, StringBuffer sb) {
        return StringTransformer.equals(caller, sb.toString());
    }

    @BooleanReplacement
    public static int contains(String caller, CharSequence s) {
        Objects.requireNonNull(caller);
        Objects.requireNonNull(s);
        if (caller.contains(s)) {
            return 0x7FFFFFFD;
        }
        String k = s.toString();
        if (caller.length() <= k.length()) {
            return StringTransformer.equals(caller, k);
        }
        assert (caller.length() > k.length());
        int best = -2147483645;
        for (int i = 0; i < caller.length() - k.length() + 1; ++i) {
            String sub = caller.substring(i, i + k.length());
            int h = StringTransformer.equals(sub, k);
            if (h <= best) continue;
            best = h;
        }
        return best;
    }

    private static int truncate(long value) {
        if (value > 0x7FFFFFFDL) {
            return 0x7FFFFFFD;
        }
        if (value < -2147483645L) {
            return -2147483645;
        }
        return (int)value;
    }

    public static long getLeftAlignmentDistance(String a, String b) {
        long diff = Math.abs(a.length() - b.length());
        long dist = diff * 65535L;
        for (int i = 0; i < Math.min(a.length(), b.length()); ++i) {
            dist += (long)Math.abs(a.charAt(i) - b.charAt(i));
        }
        assert (dist >= 0L);
        return dist;
    }
}

