/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.instrumentation.visitor;

import org.evomaster.clientJava.instrumentation.ClassName;
import org.evomaster.clientJava.instrumentation.ObjectiveNaming;
import org.evomaster.clientJava.instrumentation.staticState.ExecutionTracer;
import org.evomaster.clientJava.instrumentation.staticState.ObjectiveRecorder;
import shaded.org.objectweb.asm.Label;
import shaded.org.objectweb.asm.MethodVisitor;

public class SuccessCallMethodVisitor
extends MethodVisitor {
    private final String className;
    private final String methodName;
    private int currentLine;
    private int currentIndex;

    public SuccessCallMethodVisitor(MethodVisitor mv, String className, String methodName, String descriptor) {
        super(327680, mv);
        this.className = className;
        this.methodName = methodName;
        this.currentLine = 0;
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.currentLine = line;
        this.currentIndex = 0;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (this.methodName.equals("<clinit>")) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        int index = this.currentIndex++;
        ObjectiveRecorder.registerTarget(ObjectiveNaming.successCallObjectiveName(this.className, this.currentLine, index));
        this.addInstrumentation(index, false);
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        this.addInstrumentation(index, true);
    }

    private void addInstrumentation(int index, boolean covered) {
        this.visitLdcInsn(this.className);
        this.visitLdcInsn(this.currentLine);
        this.visitLdcInsn(index);
        this.visitLdcInsn(covered);
        this.mv.visitMethodInsn(184, ClassName.get(ExecutionTracer.class).getBytecodeName(), "executingMethod", "(Ljava/lang/String;IIZ)V", ExecutionTracer.class.isInterface());
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack + 4, maxLocals);
    }
}

