/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.ExpressionVisitor;
import shaded.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import shaded.net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import shaded.net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import shaded.net.sf.jsqlparser.schema.Column;
import shaded.net.sf.jsqlparser.statement.select.SelectVisitor;
import shaded.net.sf.jsqlparser.statement.select.SubSelect;
import shaded.net.sf.jsqlparser.statement.select.WithItem;
import shaded.net.sf.jsqlparser.statement.upsert.Upsert;

public class UpsertDeParser
implements ItemsListVisitor {
    private StringBuilder buffer;
    private ExpressionVisitor expressionVisitor;
    private SelectVisitor selectVisitor;

    public UpsertDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuilder buffer) {
        this.buffer = buffer;
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public void deParse(Upsert upsert) {
        this.buffer.append("UPSERT INTO ");
        this.buffer.append(upsert.getTable().getFullyQualifiedName());
        if (upsert.getColumns() != null) {
            this.appendColumns(upsert);
        }
        if (upsert.getItemsList() != null) {
            upsert.getItemsList().accept(this);
        }
        if (upsert.getSelect() != null) {
            this.appendSelect(upsert);
        }
        if (upsert.isUseDuplicate()) {
            this.appendDuplicate(upsert);
        }
    }

    private void appendColumns(Upsert upsert) {
        this.buffer.append(" (");
        Iterator<Column> iter = upsert.getColumns().iterator();
        while (iter.hasNext()) {
            Column column = iter.next();
            this.buffer.append(column.getColumnName());
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    private void appendSelect(Upsert upsert) {
        this.buffer.append(" ");
        if (upsert.isUseSelectBrackets()) {
            this.buffer.append("(");
        }
        if (upsert.getSelect().getWithItemsList() != null) {
            this.buffer.append("WITH ");
            for (WithItem with : upsert.getSelect().getWithItemsList()) {
                with.accept(this.selectVisitor);
            }
            this.buffer.append(" ");
        }
        upsert.getSelect().getSelectBody().accept(this.selectVisitor);
        if (upsert.isUseSelectBrackets()) {
            this.buffer.append(")");
        }
    }

    private void appendDuplicate(Upsert upsert) {
        this.buffer.append(" ON DUPLICATE KEY UPDATE ");
        for (int i = 0; i < upsert.getDuplicateUpdateColumns().size(); ++i) {
            Column column = upsert.getDuplicateUpdateColumns().get(i);
            this.buffer.append(column.getFullyQualifiedName()).append(" = ");
            Expression expression = upsert.getDuplicateUpdateExpressionList().get(i);
            expression.accept(this.expressionVisitor);
            if (i >= upsert.getDuplicateUpdateColumns().size() - 1) continue;
            this.buffer.append(", ");
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        this.buffer.append(" VALUES (");
        Iterator<Expression> iter = expressionList.getExpressions().iterator();
        while (iter.hasNext()) {
            Expression expression = iter.next();
            expression.accept(this.expressionVisitor);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(MultiExpressionList multiExprList) {
        this.buffer.append(" VALUES ");
        Iterator<ExpressionList> it = multiExprList.getExprList().iterator();
        while (it.hasNext()) {
            this.buffer.append("(");
            Iterator<Expression> iter = it.next().getExpressions().iterator();
            while (iter.hasNext()) {
                Expression expression = iter.next();
                expression.accept(this.expressionVisitor);
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }

    public void setSelectVisitor(SelectVisitor visitor) {
        this.selectVisitor = visitor;
    }
}

