/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.client;

import java.io.IOException;
import shaded.javax.ws.rs.ProcessingException;
import shaded.javax.ws.rs.client.ClientRequestFilter;
import shaded.javax.ws.rs.client.ClientResponseFilter;
import shaded.javax.ws.rs.client.ResponseProcessingException;
import shaded.javax.ws.rs.core.Response;
import shaded.org.glassfish.hk2.api.ServiceLocator;
import shaded.org.glassfish.jersey.client.AbortException;
import shaded.org.glassfish.jersey.client.ClientRequest;
import shaded.org.glassfish.jersey.client.ClientResponse;
import shaded.org.glassfish.jersey.client.InboundJaxrsResponse;
import shaded.org.glassfish.jersey.internal.inject.Providers;
import shaded.org.glassfish.jersey.model.internal.RankedComparator;
import shaded.org.glassfish.jersey.process.internal.AbstractChainableStage;
import shaded.org.glassfish.jersey.process.internal.ChainableStage;
import shaded.org.glassfish.jersey.process.internal.Stage;

class ClientFilteringStages {
    private ClientFilteringStages() {
    }

    static ChainableStage<ClientRequest> createRequestFilteringStage(ServiceLocator locator) {
        RankedComparator comparator = new RankedComparator(RankedComparator.Order.ASCENDING);
        Iterable<ClientRequestFilter> requestFilters = Providers.getAllProviders(locator, ClientRequestFilter.class, comparator);
        return requestFilters.iterator().hasNext() ? new RequestFilteringStage(requestFilters) : null;
    }

    static ChainableStage<ClientResponse> createResponseFilteringStage(ServiceLocator locator) {
        RankedComparator comparator = new RankedComparator(RankedComparator.Order.DESCENDING);
        Iterable<ClientResponseFilter> responseFilters = Providers.getAllProviders(locator, ClientResponseFilter.class, comparator);
        return responseFilters.iterator().hasNext() ? new ResponseFilterStage(responseFilters) : null;
    }

    private static class ResponseFilterStage
    extends AbstractChainableStage<ClientResponse> {
        private final Iterable<ClientResponseFilter> filters;

        private ResponseFilterStage(Iterable<ClientResponseFilter> filters) {
            this.filters = filters;
        }

        @Override
        public Stage.Continuation<ClientResponse> apply(ClientResponse responseContext) {
            try {
                for (ClientResponseFilter filter : this.filters) {
                    filter.filter(responseContext.getRequestContext(), responseContext);
                }
            }
            catch (IOException ex) {
                InboundJaxrsResponse response = new InboundJaxrsResponse(responseContext, null);
                throw new ResponseProcessingException((Response)response, (Throwable)ex);
            }
            return Stage.Continuation.of(responseContext, this.getDefaultNext());
        }
    }

    private static final class RequestFilteringStage
    extends AbstractChainableStage<ClientRequest> {
        private final Iterable<ClientRequestFilter> requestFilters;

        private RequestFilteringStage(Iterable<ClientRequestFilter> requestFilters) {
            this.requestFilters = requestFilters;
        }

        @Override
        public Stage.Continuation<ClientRequest> apply(ClientRequest requestContext) {
            for (ClientRequestFilter filter : this.requestFilters) {
                try {
                    filter.filter(requestContext);
                    Response abortResponse = requestContext.getAbortResponse();
                    if (abortResponse == null) continue;
                    throw new AbortException(new ClientResponse(requestContext, abortResponse));
                }
                catch (IOException ex) {
                    throw new ProcessingException(ex);
                }
            }
            return Stage.Continuation.of(requestContext, this.getDefaultNext());
        }
    }
}

