/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.message.filtering;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import shaded.javax.ws.rs.ConstrainedTo;
import shaded.javax.ws.rs.RuntimeType;
import shaded.javax.ws.rs.core.Configuration;
import shaded.javax.ws.rs.core.Context;
import shaded.javax.ws.rs.core.SecurityContext;
import shaded.jersey.repackaged.com.google.common.collect.Sets;
import shaded.org.glassfish.hk2.api.ServiceLocator;
import shaded.org.glassfish.jersey.message.filtering.SecurityHelper;
import shaded.org.glassfish.jersey.message.filtering.ServerScopeProvider;

@Singleton
@ConstrainedTo(value=RuntimeType.SERVER)
final class SecurityServerScopeProvider
extends ServerScopeProvider {
    @Context
    private SecurityContext securityContext;

    @Inject
    public SecurityServerScopeProvider(Configuration config, ServiceLocator serviceLocator) {
        super(config, serviceLocator);
    }

    @Override
    public Set<String> getFilteringScopes(Annotation[] entityAnnotations, boolean defaultIfNotFound) {
        Set<String> filteringScope = super.getFilteringScopes(entityAnnotations, false);
        if (filteringScope.isEmpty()) {
            filteringScope = Sets.newHashSet();
            for (String role : SecurityHelper.getProcessedRoles()) {
                if (!this.securityContext.isUserInRole(role)) continue;
                filteringScope.add(SecurityHelper.getRolesAllowedScope(role));
            }
        }
        return this.returnFilteringScopes(filteringScope, defaultIfNotFound);
    }
}

