/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.server.internal.inject;

import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Singleton;
import shaded.javax.ws.rs.BeanParam;
import shaded.org.glassfish.hk2.api.ActiveDescriptor;
import shaded.org.glassfish.hk2.api.ServiceLocator;
import shaded.org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import shaded.org.glassfish.hk2.utilities.BuilderHelper;
import shaded.org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import shaded.org.glassfish.hk2.utilities.cache.Cache;
import shaded.org.glassfish.hk2.utilities.cache.Computable;
import shaded.org.glassfish.jersey.process.internal.RequestScoped;
import shaded.org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import shaded.org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import shaded.org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import shaded.org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import shaded.org.glassfish.jersey.server.model.Parameter;

@Singleton
final class BeanParamValueFactoryProvider
extends AbstractValueFactoryProvider {
    @Inject
    private ServiceLocator locator;

    @Inject
    public BeanParamValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator injector) {
        super(mpep, injector, Parameter.Source.BEAN_PARAM);
    }

    public AbstractContainerRequestValueFactory<?> createValueFactory(Parameter parameter) {
        return new BeanParamValueFactory(this.locator, parameter);
    }

    private static final class BeanParamValueFactory
    extends AbstractContainerRequestValueFactory<Object> {
        private final Parameter parameter;
        private final ServiceLocator locator;
        private final Cache<Class<?>, ActiveDescriptor<?>> descriptorCache = new Cache(new Computable<Class<?>, ActiveDescriptor<?>>(){

            @Override
            public ActiveDescriptor<?> compute(Class<?> key) {
                AbstractActiveDescriptor descriptor = BuilderHelper.activeLink(key).to(key).in(RequestScoped.class).build();
                return ServiceLocatorUtilities.addOneDescriptor(BeanParamValueFactory.this.locator, descriptor, false);
            }
        });

        private BeanParamValueFactory(ServiceLocator locator, Parameter parameter) {
            this.locator = locator;
            this.parameter = parameter;
        }

        @Override
        public Object provide() {
            Class<?> rawType = this.parameter.getRawType();
            Object fromHk2 = this.locator.getService(rawType, new Annotation[0]);
            if (fromHk2 != null) {
                return fromHk2;
            }
            ActiveDescriptor<?> reifiedDescriptor = this.descriptorCache.compute(rawType);
            return this.locator.getServiceHandle(reifiedDescriptor).getService();
        }
    }

    @Singleton
    static final class InjectionResolver
    extends ParamInjectionResolver<BeanParam> {
        public InjectionResolver() {
            super(BeanParamValueFactoryProvider.class);
        }
    }
}

