/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.server.internal.inject;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Singleton;
import shaded.org.glassfish.hk2.api.ActiveDescriptor;
import shaded.org.glassfish.hk2.api.Factory;
import shaded.org.glassfish.hk2.api.Injectee;
import shaded.org.glassfish.hk2.api.InjectionResolver;
import shaded.org.glassfish.hk2.api.ServiceHandle;
import shaded.org.glassfish.hk2.api.ServiceLocator;
import shaded.org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import shaded.org.glassfish.hk2.utilities.InjecteeImpl;
import shaded.org.glassfish.hk2.utilities.cache.Cache;
import shaded.org.glassfish.hk2.utilities.cache.Computable;
import shaded.org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import shaded.org.glassfish.jersey.internal.inject.Providers;
import shaded.org.glassfish.jersey.process.internal.RequestScoped;
import shaded.org.glassfish.jersey.server.model.Parameter;
import shaded.org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

@Singleton
class DelegatedInjectionValueFactoryProvider
implements ValueFactoryProvider {
    private final ContextInjectionResolver resolver;
    static final Cache<Parameter, ActiveDescriptor> descriptorCache = new Cache<Parameter, ActiveDescriptor>(new Computable<Parameter, ActiveDescriptor>(){

        @Override
        public ActiveDescriptor compute(Parameter parameter) {
            Class<?> rawType = parameter.getRawType();
            if (rawType.isInterface() && !(parameter.getType() instanceof ParameterizedType)) {
                return DelegatedInjectionValueFactoryProvider.createDescriptor(rawType);
            }
            return null;
        }
    });

    @Inject
    public DelegatedInjectionValueFactoryProvider(ServiceLocator locator) {
        ContextInjectionResolver result = null;
        for (InjectionResolver r : Providers.getProviders(locator, InjectionResolver.class)) {
            if (!ContextInjectionResolver.class.isInstance(r)) continue;
            result = (ContextInjectionResolver)ContextInjectionResolver.class.cast(r);
            break;
        }
        this.resolver = result;
    }

    @Override
    public Factory<?> getValueFactory(Parameter parameter) {
        Parameter.Source paramSource = parameter.getSource();
        if (paramSource == Parameter.Source.CONTEXT) {
            final Injectee effectiveInjectee = DelegatedInjectionValueFactoryProvider.getInjectee(parameter);
            return new Factory<Object>(){

                @Override
                public Object provide() {
                    return DelegatedInjectionValueFactoryProvider.this.resolver.resolve(effectiveInjectee, null);
                }

                @Override
                public void dispose(Object instance) {
                }
            };
        }
        return null;
    }

    @Override
    public ValueFactoryProvider.PriorityType getPriority() {
        return ValueFactoryProvider.Priority.LOW;
    }

    private static Injectee getInjectee(final Parameter parameter) {
        return new InjecteeImpl(){
            private final Class<?> rawType;
            {
                this.rawType = parameter.getRawType();
                this.setRequiredType(parameter.getType());
                this.setRequiredQualifiers(Collections.emptySet());
                ActiveDescriptor proxyDescriptor = descriptorCache.compute(parameter);
                if (proxyDescriptor != null) {
                    this.setInjecteeDescriptor(proxyDescriptor);
                }
            }

            @Override
            public Class<?> getInjecteeClass() {
                return this.rawType;
            }
        };
    }

    private static <T> AbstractActiveDescriptor<T> createDescriptor(final Class<T> clazz) {
        return new AbstractActiveDescriptor<T>(){

            @Override
            public Class<T> getImplementationClass() {
                return clazz;
            }

            @Override
            public Type getImplementationType() {
                return this.getImplementationClass();
            }

            @Override
            public T create(ServiceHandle sh) {
                return null;
            }

            @Override
            public Boolean isProxyForSameScope() {
                return false;
            }

            @Override
            public synchronized String getScope() {
                return RequestScoped.class.getName();
            }
        };
    }
}

