/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.server.internal.inject;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import shaded.javax.ws.rs.Encoded;
import shaded.javax.ws.rs.FormParam;
import shaded.javax.ws.rs.ProcessingException;
import shaded.javax.ws.rs.core.Form;
import shaded.javax.ws.rs.core.MediaType;
import shaded.org.glassfish.hk2.api.ServiceLocator;
import shaded.org.glassfish.jersey.internal.inject.ExtractorException;
import shaded.org.glassfish.jersey.internal.util.collection.NullableMultivaluedHashMap;
import shaded.org.glassfish.jersey.message.internal.MediaTypes;
import shaded.org.glassfish.jersey.message.internal.ReaderWriter;
import shaded.org.glassfish.jersey.server.ContainerRequest;
import shaded.org.glassfish.jersey.server.ParamException;
import shaded.org.glassfish.jersey.server.internal.LocalizationMessages;
import shaded.org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import shaded.org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import shaded.org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import shaded.org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import shaded.org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import shaded.org.glassfish.jersey.server.model.Parameter;

@Singleton
final class FormParamValueFactoryProvider
extends AbstractValueFactoryProvider {
    @Inject
    public FormParamValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator injector) {
        super(mpep, injector, Parameter.Source.FORM);
    }

    public AbstractContainerRequestValueFactory<?> createValueFactory(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.isEmpty()) {
            return null;
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new FormParamValueFactory(e, !parameter.isEncoded());
    }

    private static final class FormParamValueFactory
    extends AbstractContainerRequestValueFactory<Object> {
        private final MultivaluedParameterExtractor<?> extractor;
        private final boolean decode;
        private static final Annotation encodedAnnotation = FormParamValueFactory.getEncodedAnnotation();

        FormParamValueFactory(MultivaluedParameterExtractor<?> extractor, boolean decode) {
            this.extractor = extractor;
            this.decode = decode;
        }

        @Override
        public Object provide() {
            ContainerRequest request = this.getContainerRequest();
            Form form = FormParamValueFactory.getCachedForm(request, this.decode);
            if (form == null) {
                Form otherForm = FormParamValueFactory.getCachedForm(request, !this.decode);
                if (otherForm != null) {
                    form = this.switchUrlEncoding(request, otherForm);
                    this.cacheForm(request, form);
                } else {
                    form = this.getForm(request);
                    this.cacheForm(request, form);
                }
            }
            try {
                return this.extractor.extract(form.asMap());
            }
            catch (ExtractorException e) {
                throw new ParamException.FormParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }

        private Form switchUrlEncoding(ContainerRequest request, Form otherForm) {
            Set entries = otherForm.asMap().entrySet();
            NullableMultivaluedHashMap<String, String> formMap = new NullableMultivaluedHashMap<String, String>();
            for (Map.Entry entry : entries) {
                String charsetName = ReaderWriter.getCharset(MediaType.valueOf(request.getHeaderString("Content-Type"))).name();
                try {
                    String key = this.decode ? URLDecoder.decode((String)entry.getKey(), charsetName) : URLEncoder.encode((String)entry.getKey(), charsetName);
                    for (String value : (List)entry.getValue()) {
                        if (value != null) {
                            formMap.add(key, this.decode ? URLDecoder.decode(value, charsetName) : URLEncoder.encode(value, charsetName));
                            continue;
                        }
                        formMap.add(key, null);
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    throw new ProcessingException(LocalizationMessages.ERROR_UNSUPPORTED_ENCODING(charsetName, this.extractor.getName()), uee);
                }
            }
            return new Form(formMap);
        }

        private void cacheForm(ContainerRequest request, Form form) {
            request.setProperty(this.decode ? "shaded.jersey.config.server.representation.decoded.form" : "shaded.jersey.config.server.representation.form", form);
        }

        private Form getForm(ContainerRequest request) {
            return this.getFormParameters(FormParamValueFactory.ensureValidRequest(request));
        }

        private static Form getCachedForm(ContainerRequest request, boolean decode) {
            return (Form)request.getProperty(decode ? "shaded.jersey.config.server.representation.decoded.form" : "shaded.jersey.config.server.representation.form");
        }

        private static ContainerRequest ensureValidRequest(ContainerRequest request) throws IllegalStateException {
            if (request.getMethod().equals("GET")) {
                throw new IllegalStateException(LocalizationMessages.FORM_PARAM_METHOD_ERROR());
            }
            if (!MediaTypes.typeEqual(MediaType.APPLICATION_FORM_URLENCODED_TYPE, request.getMediaType())) {
                throw new IllegalStateException(LocalizationMessages.FORM_PARAM_CONTENT_TYPE_ERROR());
            }
            return request;
        }

        private static Annotation getEncodedAnnotation() {
            @Encoded
            final class EncodedAnnotationTemp {
                EncodedAnnotationTemp() {
                }
            }
            return EncodedAnnotationTemp.class.getAnnotation(Encoded.class);
        }

        private Form getFormParameters(ContainerRequest request) {
            if (MediaTypes.typeEqual(MediaType.APPLICATION_FORM_URLENCODED_TYPE, request.getMediaType())) {
                Form form;
                request.bufferEntity();
                if (this.decode) {
                    form = request.readEntity(Form.class);
                } else {
                    Annotation[] annotations = new Annotation[]{encodedAnnotation};
                    form = request.readEntity(Form.class, annotations);
                }
                return form == null ? new Form() : form;
            }
            return new Form();
        }
    }

    @Singleton
    static final class InjectionResolver
    extends ParamInjectionResolver<FormParam> {
        public InjectionResolver() {
            super(FormParamValueFactoryProvider.class);
        }
    }
}

