/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.server.model.internal;

import java.lang.reflect.InvocationHandler;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import shaded.org.glassfish.hk2.api.ServiceLocator;
import shaded.org.glassfish.jersey.internal.inject.Providers;
import shaded.org.glassfish.jersey.server.internal.LocalizationMessages;
import shaded.org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import shaded.org.glassfish.jersey.server.model.Invocable;
import shaded.org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;

@Singleton
public final class ResourceMethodDispatcherFactory
implements ResourceMethodDispatcher.Provider {
    private static final Logger LOGGER = Logger.getLogger(ResourceMethodDispatcherFactory.class.getName());
    private final Set<ResourceMethodDispatcher.Provider> providers;

    @Inject
    ResourceMethodDispatcherFactory(ServiceLocator locator) {
        this.providers = Providers.getProviders(locator, ResourceMethodDispatcher.Provider.class);
    }

    @Override
    public ResourceMethodDispatcher create(Invocable resourceMethod, InvocationHandler handler, ConfiguredValidator validator) {
        for (ResourceMethodDispatcher.Provider provider : this.providers) {
            try {
                ResourceMethodDispatcher dispatcher = provider.create(resourceMethod, handler, validator);
                if (dispatcher == null) continue;
                return dispatcher;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_PROCESSING_METHOD(resourceMethod, provider.getClass().getName()), e);
            }
        }
        return null;
    }
}

