/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import org.geotools.data.shapefile.ShapefileFeatureReader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.IndexedDbaseFileReader;
import org.geotools.data.shapefile.fid.IndexedFidReader;
import org.geotools.data.shapefile.index.CloseableIterator;
import org.geotools.data.shapefile.index.Data;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.opengis.feature.simple.SimpleFeatureType;

class IndexedShapefileFeatureReader
extends ShapefileFeatureReader {
    protected CloseableIterator<Data> goodRecs;
    private Data next;
    private IndexedFidReader fidReader;

    public IndexedShapefileFeatureReader(SimpleFeatureType schema, ShapefileReader shp, DbaseFileReader dbf, IndexedFidReader fidReader, CloseableIterator<Data> goodRecs) throws IOException {
        super(schema, shp, dbf, fidReader);
        this.goodRecs = goodRecs;
        this.fidReader = fidReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.goodRecs != null) {
                this.goodRecs.close();
            }
            this.goodRecs = null;
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        while (this.nextFeature == null && this.goodRecs.hasNext()) {
            DbaseFileReader.Row row;
            this.next = (Data)this.goodRecs.next();
            Long l = (Long)this.next.getValue(1);
            this.shp.goTo((int)l.longValue());
            ShapefileReader.Record record = this.shp.nextRecord();
            Envelope envelope = record.envelope();
            Geometry geometry = null;
            if (this.schema.getGeometryDescriptor() != null) {
                if (this.targetBBox != null && !this.targetBBox.isNull() && !this.targetBBox.intersects(envelope)) continue;
                if (this.simplificationDistance > 0.0 && envelope.getWidth() < this.simplificationDistance && envelope.getHeight() < this.simplificationDistance) {
                    try {
                        if (this.screenMap != null && this.screenMap.checkAndSet(envelope)) continue;
                        geometry = (Geometry)record.getSimplifiedShape(this.screenMap);
                    }
                    catch (Exception e) {
                        geometry = (Geometry)record.getSimplifiedShape();
                    }
                } else {
                    geometry = (Geometry)record.shape();
                }
            }
            if (this.dbf != null) {
                ((IndexedDbaseFileReader)this.dbf).goTo(record.number);
                row = this.dbf.readRow();
            } else {
                row = null;
            }
            this.nextFeature = this.buildFeature(record.number, geometry, row);
        }
        return this.nextFeature != null;
    }
}

