/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memcached;

import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.memcached.CacheManager;
import org.glassfish.grizzly.memcached.GrizzlyMemcachedCache;
import org.glassfish.grizzly.memcached.MemcachedCache;
import org.glassfish.grizzly.memcached.MemcachedClientFilter;
import org.glassfish.grizzly.memcached.zookeeper.ZKClient;
import org.glassfish.grizzly.memcached.zookeeper.ZooKeeperConfig;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.utils.DataStructures;

public class GrizzlyMemcachedCacheManager
implements CacheManager {
    private static final Logger logger = Grizzly.logger(GrizzlyMemcachedCacheManager.class);
    private final ConcurrentMap<String, GrizzlyMemcachedCache<?, ?>> caches = DataStructures.getConcurrentMap();
    private final TCPNIOTransport transport;
    private final boolean isExternalTransport;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private ZKClient zkClient;

    private GrizzlyMemcachedCacheManager(Builder builder) {
        TCPNIOTransport transportLocal = builder.transport;
        if (transportLocal == null) {
            this.isExternalTransport = false;
            FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
            clientFilterChainBuilder.add((Filter)new TransportFilter()).add((Filter)new MemcachedClientFilter(true, true));
            TCPNIOTransportBuilder clientTCPNIOTransportBuilder = TCPNIOTransportBuilder.newInstance();
            transportLocal = clientTCPNIOTransportBuilder.build();
            transportLocal.setProcessor((Processor)clientFilterChainBuilder.build());
            transportLocal.setSelectorRunnersCount(builder.selectorRunnersCount);
            transportLocal.setIOStrategy(builder.ioStrategy);
            transportLocal.configureBlocking(builder.blocking);
            if (builder.workerThreadPool != null) {
                transportLocal.setWorkerThreadPool(builder.workerThreadPool);
            }
            try {
                transportLocal.start();
            }
            catch (IOException ie) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to start the transport", ie);
                }
            }
        } else {
            this.isExternalTransport = true;
        }
        this.transport = transportLocal;
        if (builder.zooKeeperConfig != null) {
            ZKClient.Builder zkBuilder = new ZKClient.Builder(builder.zooKeeperConfig.getName(), builder.zooKeeperConfig.getZooKeeperServerList());
            zkBuilder.rootPath(builder.zooKeeperConfig.getRootPath());
            zkBuilder.connectTimeoutInMillis(builder.zooKeeperConfig.getConnectTimeoutInMillis());
            zkBuilder.sessionTimeoutInMillis(builder.zooKeeperConfig.getSessionTimeoutInMillis());
            zkBuilder.commitDelayTimeInSecs(builder.zooKeeperConfig.getCommitDelayTimeInSecs());
            this.zkClient = zkBuilder.build();
            boolean isZkConnected = false;
            try {
                isZkConnected = this.zkClient.connect();
            }
            catch (IOException ie) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to connect the zookeeper server. zkClient=" + this.zkClient, ie);
                }
                this.zkClient = null;
            }
            catch (InterruptedException ie) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to connect the zookeeper server. zkClient=" + this.zkClient, ie);
                }
                Thread.currentThread().interrupt();
                this.zkClient = null;
            }
            if (!isZkConnected) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "failed to connect the zookeeper server. zkClient=" + this.zkClient);
                }
                this.zkClient = null;
            }
        } else {
            this.zkClient = null;
        }
    }

    public <K, V> GrizzlyMemcachedCache.Builder<K, V> createCacheBuilder(String cacheName) {
        return new GrizzlyMemcachedCache.Builder(cacheName, this, this.transport);
    }

    public <K, V> GrizzlyMemcachedCache<K, V> getCache(String cacheName) {
        if (this.shutdown.get()) {
            return null;
        }
        return cacheName != null ? (GrizzlyMemcachedCache)this.caches.get(cacheName) : null;
    }

    @Override
    public boolean removeCache(String cacheName) {
        if (this.shutdown.get()) {
            return false;
        }
        if (cacheName == null) {
            return false;
        }
        GrizzlyMemcachedCache cache = (GrizzlyMemcachedCache)this.caches.remove(cacheName);
        if (cache == null) {
            return false;
        }
        cache.stop();
        return true;
    }

    @Override
    public void shutdown() {
        block6: {
            if (!this.shutdown.compareAndSet(false, true)) {
                return;
            }
            for (MemcachedCache cache : this.caches.values()) {
                cache.stop();
            }
            this.caches.clear();
            if (!this.isExternalTransport && this.transport != null) {
                try {
                    this.transport.shutdownNow();
                }
                catch (IOException ie) {
                    if (!logger.isLoggable(Level.INFO)) break block6;
                    logger.log(Level.INFO, "failed to stop the transport", ie);
                }
            }
        }
        if (this.zkClient != null) {
            this.zkClient.shutdown();
        }
    }

    <K, V> boolean addCache(GrizzlyMemcachedCache<K, V> cache) {
        return !this.shutdown.get() && cache != null && this.caches.putIfAbsent(cache.getName(), cache) == null && (!this.shutdown.get() || this.caches.remove(cache.getName()) != cache);
    }

    ZKClient getZkClient() {
        return this.zkClient;
    }

    public static class Builder {
        private TCPNIOTransport transport;
        private int selectorRunnersCount = Runtime.getRuntime().availableProcessors() * 2;
        private IOStrategy ioStrategy = SameThreadIOStrategy.getInstance();
        private boolean blocking = false;
        private ExecutorService workerThreadPool;
        private ZooKeeperConfig zooKeeperConfig;

        public Builder transport(TCPNIOTransport transport) {
            this.transport = transport;
            return this;
        }

        public Builder selectorRunnersCount(int selectorRunnersCount) {
            this.selectorRunnersCount = selectorRunnersCount;
            return this;
        }

        public Builder ioStrategy(IOStrategy ioStrategy) {
            this.ioStrategy = ioStrategy;
            return this;
        }

        public Builder blocking(boolean blocking) {
            this.blocking = blocking;
            return this;
        }

        public Builder workerThreadPool(ExecutorService workerThreadPool) {
            this.workerThreadPool = workerThreadPool;
            return this;
        }

        public Builder zooKeeperConfig(ZooKeeperConfig zooKeeperConfig) {
            this.zooKeeperConfig = zooKeeperConfig;
            return this;
        }

        public GrizzlyMemcachedCacheManager build() {
            return new GrizzlyMemcachedCacheManager(this);
        }
    }
}

