/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memcached;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memcached.BufferWrapper;
import org.glassfish.grizzly.memcached.CommandOpcodes;
import org.glassfish.grizzly.memcached.MemcachedClientFilter;
import org.glassfish.grizzly.memcached.ResponseStatus;
import org.glassfish.grizzly.memcached.ValueWithCas;
import org.glassfish.grizzly.memcached.ValueWithKey;
import org.glassfish.grizzly.memory.MemoryManager;

public class MemcachedResponse
implements Cacheable {
    private static final Logger logger = Grizzly.logger(MemcachedResponse.class);
    private static final Long INVALID_LONG = -1L;
    private static final ThreadCache.CachedTypeIndex<MemcachedResponse> CACHE_IDX = ThreadCache.obtainIndex(MemcachedResponse.class, (int)16);
    private CommandOpcodes op;
    private short keyLength;
    private byte extraLength;
    private byte dataType;
    private ResponseStatus status;
    private int totalBodyLength;
    private int opaque;
    private long cas;
    private int flags;
    private Object decodedKey;
    private Object decodedValue;
    private Object result;

    private MemcachedResponse() {
    }

    public static MemcachedResponse create() {
        MemcachedResponse response = (MemcachedResponse)ThreadCache.takeFromCache(CACHE_IDX);
        if (response != null) {
            return response;
        }
        return new MemcachedResponse();
    }

    public CommandOpcodes getOp() {
        return this.op;
    }

    public short getKeyLength() {
        return this.keyLength;
    }

    public byte getExtraLength() {
        return this.extraLength;
    }

    public byte getDataType() {
        return this.dataType;
    }

    public ResponseStatus getStatus() {
        return this.status;
    }

    public int getTotalBodyLength() {
        return this.totalBodyLength;
    }

    public int getOpaque() {
        return this.opaque;
    }

    public long getCas() {
        return this.cas;
    }

    public int getFlags() {
        return this.flags;
    }

    public Object getDecodedKey() {
        return this.decodedKey;
    }

    public Object getDecodedValue() {
        return this.decodedValue;
    }

    public Object getResult() {
        return this.result;
    }

    public void setOp(CommandOpcodes op) {
        this.op = op;
    }

    public void setKeyLength(short keyLength) {
        this.keyLength = keyLength;
    }

    public void setExtraLength(byte extraLength) {
        this.extraLength = extraLength;
    }

    public void setDataType(byte dataType) {
        this.dataType = dataType;
    }

    public void setStatus(ResponseStatus status) {
        this.status = status;
    }

    public void setTotalBodyLength(int totalBodyLength) {
        this.totalBodyLength = totalBodyLength;
    }

    public void setOpaque(int opaque) {
        this.opaque = opaque;
    }

    public void setCas(long cas) {
        this.cas = cas;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setDecodedKey(Buffer buffer, int position, int limit, MemoryManager memoryManager) {
        Object result;
        if (buffer == null || position > limit) {
            return;
        }
        switch (this.op) {
            case Stat: {
                if (!this.isError()) {
                    result = BufferWrapper.unwrap(buffer, position, limit, BufferWrapper.BufferType.STRING, memoryManager);
                    break;
                }
                result = null;
                break;
            }
            default: {
                result = null;
            }
        }
        this.decodedKey = result;
    }

    public void setDecodedKey(Object decodedKey) {
        this.decodedKey = decodedKey;
    }

    public void setDecodedValue(Buffer buffer, int position, int limit, MemoryManager memoryManager) {
        Object result;
        if (buffer == null || position > limit) {
            return;
        }
        switch (this.op) {
            case Get: 
            case GetQ: 
            case GAT: 
            case GATQ: 
            case GetK: 
            case GetKQ: 
            case Gets: 
            case GetsQ: {
                if (!this.isError()) {
                    result = BufferWrapper.unwrap(buffer, position, limit, BufferWrapper.BufferType.getBufferType(this.flags), memoryManager);
                    break;
                }
                result = null;
                break;
            }
            case Increment: 
            case Decrement: {
                if (!this.isError()) {
                    result = BufferWrapper.unwrap(buffer, position, limit, BufferWrapper.BufferType.LONG, memoryManager);
                    break;
                }
                result = INVALID_LONG;
                break;
            }
            case Stat: 
            case Version: {
                if (!this.isError()) {
                    result = BufferWrapper.unwrap(buffer, position, limit, BufferWrapper.BufferType.STRING, memoryManager);
                    break;
                }
                result = null;
                break;
            }
            default: {
                result = null;
            }
        }
        this.decodedValue = result;
    }

    public void setDecodedValue(Object decodedValue) {
        this.decodedValue = decodedValue;
    }

    public <K> void setResult(K originKey, MemcachedClientFilter.ParsingStatus parsingStatus) {
        ValueWithKey<String, String> result;
        if (this.isError() && parsingStatus == MemcachedClientFilter.ParsingStatus.DONE) {
            if (this.status == ResponseStatus.Key_Not_Found) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "error status code={0}, status msg={1}, op={2}, key={3}", new Object[]{this.status, this.status.message(), this.op, originKey});
                }
            } else if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "error status code={0}, status msg={1}, op={2}, key={3}", new Object[]{this.status, this.status.message(), this.op, originKey});
            }
        }
        switch (this.op) {
            case Get: 
            case GetQ: 
            case GAT: 
            case GATQ: {
                if (!this.isError()) {
                    result = this.decodedValue;
                    break;
                }
                result = null;
                break;
            }
            case GetK: 
            case GetKQ: {
                if (!this.isError() && this.decodedValue != null) {
                    result = new ValueWithKey<K, Object>(originKey, this.decodedValue);
                    break;
                }
                result = null;
                break;
            }
            case Gets: 
            case GetsQ: {
                if (!this.isError() && this.decodedValue != null) {
                    result = new ValueWithCas<Object>(this.decodedValue, this.cas);
                    break;
                }
                result = null;
                break;
            }
            case Set: 
            case Add: 
            case Replace: 
            case Delete: 
            case Quit: 
            case Flush: 
            case Append: 
            case Prepend: 
            case Verbosity: 
            case Touch: 
            case Noop: 
            case SetQ: 
            case AddQ: 
            case ReplaceQ: 
            case DeleteQ: 
            case IncrementQ: 
            case DecrementQ: 
            case QuitQ: 
            case FlushQ: 
            case AppendQ: 
            case PrependQ: {
                if (!this.isError() || parsingStatus == MemcachedClientFilter.ParsingStatus.NO_REPLY) {
                    result = Boolean.TRUE;
                    break;
                }
                result = Boolean.FALSE;
                break;
            }
            case Increment: 
            case Decrement: {
                if (!this.isError() && this.decodedValue instanceof Long) {
                    result = this.decodedValue;
                    break;
                }
                result = INVALID_LONG;
                break;
            }
            case Version: {
                if (!this.isError() && this.decodedValue instanceof String) {
                    result = this.decodedValue;
                    break;
                }
                result = null;
                break;
            }
            case Stat: {
                if (!this.isError() && this.decodedKey instanceof String && this.decodedValue instanceof String) {
                    result = new ValueWithKey<String, String>((String)this.decodedKey, (String)this.decodedValue);
                    break;
                }
                result = null;
                break;
            }
            default: {
                result = null;
            }
        }
        this.result = result;
    }

    public boolean isError() {
        switch (this.op) {
            case Delete: 
            case DeleteQ: {
                return this.status != null && this.status != ResponseStatus.No_Error && this.status != ResponseStatus.Key_Not_Found;
            }
        }
        return this.status != null && this.status != ResponseStatus.No_Error;
    }

    public boolean complete() {
        switch (this.op) {
            case Stat: {
                return this.decodedKey == null || this.decodedValue == null;
            }
        }
        return true;
    }

    public void clear() {
        this.op = null;
        this.keyLength = 0;
        this.extraLength = 0;
        this.dataType = 0;
        this.status = null;
        this.totalBodyLength = 0;
        this.opaque = 0;
        this.cas = 0L;
        this.flags = 0;
        this.decodedKey = null;
        this.decodedValue = null;
        this.result = null;
    }

    public void recycle() {
        this.clear();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    public String toString() {
        return "MemcachedResponse{op=" + (Object)((Object)this.op) + ", keyLength=" + this.keyLength + ", extraLength=" + this.extraLength + ", dataType=" + this.dataType + ", status=" + (Object)((Object)this.status) + ", totalBodyLength=" + this.totalBodyLength + ", opaque=" + this.opaque + ", cas=" + this.cas + ", flags=" + this.flags + ", decodedKey=" + this.decodedKey + ", decodedValue=" + this.decodedValue + ", result=" + this.result + '}';
    }
}

