/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memcached.zookeeper;

import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.memcached.MemcachedCache;
import org.glassfish.grizzly.memcached.zookeeper.BarrierListener;

public class CacheServerListBarrierListener
implements BarrierListener {
    private static final Logger logger = Grizzly.logger(CacheServerListBarrierListener.class);
    public static final String DEFAULT_SERVER_LIST_CHARSET = "UTF-8";
    protected final MemcachedCache cache;
    protected final String cacheName;
    protected final Set<SocketAddress> localCacheServerSet = new CopyOnWriteArraySet<SocketAddress>();
    private final List<BarrierListener> customListenerList = new CopyOnWriteArrayList<BarrierListener>();

    public CacheServerListBarrierListener(MemcachedCache cache, Set<SocketAddress> cacheServerSet) {
        this.cache = cache;
        this.cacheName = cache.getName();
        if (cacheServerSet != null) {
            this.localCacheServerSet.addAll(cacheServerSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInit(String regionName, String path, byte[] remoteBytes) {
        block18: {
            if (remoteBytes == null || remoteBytes.length == 0) {
                return;
            }
            try {
                String remoteCacheServerList = new String(remoteBytes, DEFAULT_SERVER_LIST_CHARSET);
                Set<SocketAddress> remoteCacheServers = CacheServerListBarrierListener.getAddressesFromStringList(remoteCacheServerList);
                boolean checked = true;
                for (SocketAddress local : this.localCacheServerSet) {
                    if (remoteCacheServers.remove(local)) continue;
                    checked = false;
                    break;
                }
                if (checked && !remoteCacheServers.isEmpty()) {
                    checked = false;
                }
                if (!checked) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "failed to check the cache server list from the remote. cacheName={0}, local={1}, remote={2}", new Object[]{this.cacheName, this.localCacheServerSet, remoteCacheServers});
                    }
                    break block18;
                }
                if (!logger.isLoggable(Level.INFO)) break block18;
                logger.log(Level.INFO, "cache server list confirmed. cacheName={0}, list=[{1}]", new Object[]{this.cacheName, remoteCacheServerList});
            }
            catch (UnsupportedEncodingException uee) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "failed to check the cache server list from the remote. cacheName=" + this.cacheName, uee);
                }
            }
            finally {
                for (BarrierListener listener : this.customListenerList) {
                    try {
                        listener.onInit(regionName, path, remoteBytes);
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.WARNING)) continue;
                        logger.log(Level.WARNING, "failed to call onInit(). cacheName=" + this.cacheName + ", listener=" + listener, e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCommit(String regionName, String path, byte[] remoteBytes) {
        block18: {
            if (remoteBytes == null || remoteBytes.length == 0) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "remote bytes is null or NO_DATA(byte[0]). regionName={0}, path={1}", new Object[]{regionName, path});
                }
                return;
            }
            try {
                String remoteDataString = new String(remoteBytes, DEFAULT_SERVER_LIST_CHARSET);
                Set<SocketAddress> remoteCacheServers = CacheServerListBarrierListener.getAddressesFromStringList(remoteDataString);
                if (remoteCacheServers.isEmpty() || this.cache == null) break block18;
                HashSet<SocketAddress> shouldBeAdded = new HashSet<SocketAddress>();
                HashSet<SocketAddress> shouldBeRemoved = new HashSet<SocketAddress>();
                for (SocketAddress remoteServer : remoteCacheServers) {
                    if (this.localCacheServerSet.remove(remoteServer)) continue;
                    shouldBeAdded.add(remoteServer);
                }
                shouldBeRemoved.addAll(this.localCacheServerSet);
                for (SocketAddress address : shouldBeAdded) {
                    this.cache.addServer(address);
                }
                for (SocketAddress address : shouldBeRemoved) {
                    this.cache.removeServer(address);
                }
                this.localCacheServerSet.clear();
                this.localCacheServerSet.addAll(remoteCacheServers);
            }
            catch (UnsupportedEncodingException uee) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "failed to apply the changed server list of the remote zookeeper server. regionName=" + regionName + ", path=" + path, uee);
                }
            }
            finally {
                for (BarrierListener listener : this.customListenerList) {
                    try {
                        listener.onCommit(regionName, path, remoteBytes);
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.WARNING)) continue;
                        logger.log(Level.WARNING, "failed to call onCommit(). cacheName=" + this.cacheName + ", listener=" + listener, e);
                    }
                }
            }
        }
    }

    @Override
    public void onDestroy(String regionName) {
        for (BarrierListener listener : this.customListenerList) {
            try {
                listener.onDestroy(regionName);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "failed to call onDestroy(). cacheName=" + this.cacheName + ", listener=" + listener, e);
            }
        }
    }

    public void addCustomListener(BarrierListener listener) {
        if (listener == null) {
            return;
        }
        this.customListenerList.add(listener);
    }

    public void removeCustomListener(BarrierListener listener) {
        if (listener == null) {
            return;
        }
        this.customListenerList.remove(listener);
    }

    public String toString() {
        return "CacheServerListBarrierListener{cacheName='" + this.cacheName + '\'' + ", localCacheServerSet=" + this.localCacheServerSet + ", customListenerList=" + this.customListenerList + '}';
    }

    public static Set<SocketAddress> getAddressesFromStringList(String serverList) {
        if (serverList == null) {
            throw new IllegalArgumentException("null host list");
        }
        if (serverList.trim().equals("")) {
            throw new IllegalArgumentException("no hosts in list:  ``" + serverList + "''");
        }
        HashSet<SocketAddress> addrs = new HashSet<SocketAddress>();
        for (String hoststuff : serverList.split("(,| )")) {
            if (hoststuff.length() == 0) continue;
            int finalColon = hoststuff.lastIndexOf(58);
            if (finalColon < 1) {
                throw new IllegalArgumentException("Invalid server ``" + hoststuff + "'' in list:  " + serverList);
            }
            String hostPart = hoststuff.substring(0, finalColon);
            String portNum = hoststuff.substring(finalColon + 1);
            addrs.add(new InetSocketAddress(hostPart, Integer.parseInt(portNum)));
        }
        return addrs;
    }

    public static String getStringListFromAddressSet(Set<SocketAddress> servers) {
        if (servers == null || servers.isEmpty()) {
            throw new IllegalArgumentException("Null servers");
        }
        StringBuilder builder = new StringBuilder(256);
        for (SocketAddress server : servers) {
            if (!(server instanceof InetSocketAddress)) continue;
            InetSocketAddress inetSocketAddress = (InetSocketAddress)server;
            builder.append(inetSocketAddress.getHostName()).append(':').append(inetSocketAddress.getPort());
            builder.append(',');
        }
        String result = builder.toString();
        int resultLength = result.length();
        if (resultLength < 1) {
            throw new IllegalArgumentException("there is no InetSocketAddress in the server set");
        }
        return result.substring(0, result.length() - 1);
    }
}

