/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import java.lang.ref.SoftReference;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SoftCache<K, V> {
    private Logger logger = Logger.getLogger(SoftCache.class.getName());
    protected SoftReference<K> key;
    protected SoftReference<V> value;

    public synchronized V get(K k, Callable<V> callable) {
        V thisV;
        Object thisK;
        assert (null != callable);
        Object v0 = thisK = null == this.key ? null : this.key.get();
        if (k.equals(thisK)) {
            if (null == this.value) {
                return this.usingCacheValue(null);
            }
            thisV = this.value.get();
            if (null != thisV) {
                return this.usingCacheValue(thisV);
            }
        }
        this.key = new SoftReference<K>(k);
        try {
            thisV = callable.call();
            return this.cacheValue(this.value, thisV);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected V cacheValue(SoftReference<V> value2, V thisV) {
        this.value = null == thisV ? null : new SoftReference<V>(thisV);
        this.logger.log(Level.FINEST, "caching value");
        return thisV;
    }

    protected V usingCacheValue(V thisV) {
        this.logger.log(Level.FINEST, "using cached value");
        return thisV;
    }

    public void clear() {
        this.logger.log(Level.FINEST, "clearing cached value");
        this.key = null;
        this.value = null;
    }
}

