/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.AsyncPostConstruct;
import org.jvnet.hk2.component.Inhabitant;

public class AsyncWaiter {
    private static Logger logger = Logger.getLogger(AsyncWaiter.class.getName());
    private static Level LEVEL = Level.FINE;
    private Collection<AsyncPostConstruct> watches;
    private AsyncPostConstruct workingOn;

    public synchronized void clear() {
        this.watches = null;
        this.workingOn = null;
    }

    public synchronized void watchIfNecessary(Inhabitant<?> i) {
        Object service = i.get();
        if (AsyncPostConstruct.class.isInstance(service) && !((AsyncPostConstruct)AsyncPostConstruct.class.cast(service)).isDone()) {
            if (null == this.watches) {
                this.watches = new ArrayList<AsyncPostConstruct>();
            }
            AsyncInhabitant watch = new AsyncInhabitant(i);
            logger.log(LEVEL, "Adding watch on {0}", watch);
            logger.log(LEVEL, " watch done = {0}", watch.isDone());
            this.watches.add(watch);
        }
    }

    public synchronized void watchIfNecessary(Future<?> f) {
        if (!f.isDone()) {
            if (null == this.watches) {
                this.watches = new ArrayList<AsyncPostConstruct>();
            }
            AsyncFuture watch = new AsyncFuture(f);
            logger.log(LEVEL, "Adding watch on {0}", watch);
            this.watches.add(watch);
        }
    }

    public synchronized void waitForDone() throws ExecutionException, TimeoutException, InterruptedException {
        if (null != this.watches) {
            Iterator<AsyncPostConstruct> iter = this.watches.iterator();
            while (iter.hasNext()) {
                this.workingOn = iter.next();
                this.workingOn.waitForDone();
                iter.remove();
            }
        }
        this.workingOn = null;
    }

    public boolean waitForDone(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException, InterruptedException {
        long start = System.currentTimeMillis();
        logger.log(LEVEL, "entering; watches = {0}", null == this.watches ? -1 : this.watches.size());
        boolean done = true;
        if (null != this.watches) {
            Iterator<AsyncPostConstruct> iter = this.watches.iterator();
            while (iter.hasNext()) {
                this.workingOn = iter.next();
                if (this.workingOn.waitForDone(timeout, unit)) {
                    iter.remove();
                    continue;
                }
                logger.log(LEVEL, "gave up waiting on {0}", this.workingOn);
                done = false;
            }
        }
        this.workingOn = null;
        logger.log(LEVEL, "exiting - {0} ms", System.currentTimeMillis() - start);
        logger.log(LEVEL, " watches = {0}", null == this.watches ? -1 : this.watches.size());
        logger.log(LEVEL, " done is {0}", done);
        return done;
    }

    public synchronized int getWatches() {
        return null == this.watches ? 0 : this.watches.size();
    }

    public synchronized boolean isDone() {
        boolean done = true;
        if (null != this.watches) {
            Iterator<AsyncPostConstruct> iter = this.watches.iterator();
            while (iter.hasNext()) {
                this.workingOn = iter.next();
                if (!this.workingOn.isDone()) continue;
                iter.remove();
            }
            this.workingOn = null;
            done = this.watches.isEmpty();
        }
        return done;
    }

    public synchronized Inhabitant<?> getLastInhabitantWorkingOn() {
        return AsyncInhabitant.class.isInstance(this.workingOn) ? ((AsyncInhabitant)AsyncInhabitant.class.cast(this.workingOn)).inhabitant : null;
    }

    private static class AsyncInhabitant
    implements AsyncPostConstruct {
        private final Inhabitant<?> inhabitant;
        private final AsyncPostConstruct service;

        private AsyncInhabitant(Inhabitant<?> inhabitant) {
            this.inhabitant = inhabitant;
            this.service = (AsyncPostConstruct)inhabitant.get();
        }

        public void postConstruct() {
        }

        public boolean isDone() {
            return this.service.isDone();
        }

        public void waitForDone() throws ExecutionException, TimeoutException, InterruptedException {
            this.service.waitForDone();
        }

        public boolean waitForDone(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException {
            return this.service.waitForDone(timeout, unit);
        }
    }

    private static class AsyncFuture
    implements AsyncPostConstruct {
        private final Future<?> future;

        private AsyncFuture(Future<?> future) {
            this.future = future;
        }

        public void postConstruct() {
        }

        public boolean isDone() {
            return this.future.isDone();
        }

        public void waitForDone() throws ExecutionException, InterruptedException {
            this.future.get();
        }

        public boolean waitForDone(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException {
            try {
                this.future.get(timeout, unit);
                return true;
            }
            catch (TimeoutException e) {
                return false;
            }
        }
    }
}

