/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.AsyncWaiter;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantActivator;
import org.jvnet.hk2.component.concurrent.WorkManager;

public class MultiThreadedInhabitantActivator
implements InhabitantActivator {
    private WorkManager wm;
    private final AsyncWaiter waiter = new AsyncWaiter();

    @Inject(name="inhabitation-activator", optional=true)
    public void setExecutorService(Executor es) {
        this.wm = new WorkManager(es);
    }

    @Override
    public void activate(final Inhabitant<?> inhabitant) {
        if (!inhabitant.isActive()) {
            this.wm.execute(new Runnable(){

                @Override
                public void run() {
                    inhabitant.get();
                }
            });
            this.waiter.watchIfNecessary(inhabitant);
        }
    }

    @Override
    public void deactivate(Inhabitant<?> inhabitant) {
        inhabitant.release();
    }

    @Override
    public void awaitCompletion() throws InterruptedException, ExecutionException, TimeoutException {
        this.wm.awaitCompletion();
        this.waiter.waitForDone();
    }

    @Override
    public void awaitCompletion(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        long millisTimeout = unit.toMillis(timeout);
        long start = System.currentTimeMillis();
        this.wm.awaitCompletion(timeout, unit);
        long end = System.currentTimeMillis();
        if ((millisTimeout -= end - start) > 0L) {
            this.waiter.waitForDone(millisTimeout, TimeUnit.MILLISECONDS);
        }
    }
}

