/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.internal.ReflectionHelper;
import org.glassfish.hk2.utilities.DescriptorImpl;

public abstract class AbstractActiveDescriptor<T>
extends DescriptorImpl
implements ActiveDescriptor<T>,
Serializable {
    private static final long serialVersionUID = 7080312303893604939L;
    private Set<Type> advertisedContracts = new HashSet<Type>();
    private Class<? extends Annotation> scope;
    private Set<Annotation> qualifiers = new HashSet<Annotation>();
    private transient boolean cacheSet = false;
    private transient T cachedValue;

    public AbstractActiveDescriptor() {
    }

    protected AbstractActiveDescriptor(Set<Type> advertisedContracts, Class<? extends Annotation> scope, String name, Set<Annotation> qualifiers, DescriptorType descriptorType, int ranking) {
        this.scope = scope;
        this.advertisedContracts.addAll(advertisedContracts);
        this.qualifiers.addAll(qualifiers);
        this.setRanking(ranking);
        this.setDescriptorType(descriptorType);
        this.setName(name);
        if (scope != null) {
            this.setScope(scope.getName());
        }
        for (Type t : advertisedContracts) {
            Class<?> raw = ReflectionHelper.getRawClass(t);
            if (raw == null) continue;
            this.addAdvertisedContract(raw.getName());
        }
        for (Annotation q : qualifiers) {
            this.addQualifier(q.annotationType().getName());
        }
    }

    @Override
    public synchronized T getCache() {
        return this.cachedValue;
    }

    @Override
    public synchronized boolean isCacheSet() {
        return this.cacheSet;
    }

    @Override
    public synchronized void setCache(T cacheMe) {
        this.cachedValue = cacheMe;
        this.cacheSet = true;
    }

    @Override
    public synchronized void releaseCache() {
        this.cacheSet = false;
        this.cachedValue = null;
    }

    @Override
    public synchronized boolean isReified() {
        return true;
    }

    @Override
    public synchronized Set<Type> getContractTypes() {
        return Collections.unmodifiableSet(this.advertisedContracts);
    }

    public synchronized void addContractType(Type addMe) {
        if (addMe == null) {
            return;
        }
        this.advertisedContracts.add(addMe);
        Class<?> rawClass = ReflectionHelper.getRawClass(addMe);
        if (rawClass == null) {
            return;
        }
        this.addAdvertisedContract(rawClass.getName());
    }

    public synchronized boolean removeContractType(Type removeMe) {
        if (removeMe == null) {
            return false;
        }
        boolean retVal = this.advertisedContracts.remove(removeMe);
        Class<?> rawClass = ReflectionHelper.getRawClass(removeMe);
        if (rawClass == null) {
            return retVal;
        }
        return this.removeAdvertisedContract(rawClass.getName());
    }

    @Override
    public synchronized Class<? extends Annotation> getScopeAnnotation() {
        return this.scope;
    }

    @Override
    public synchronized Set<Annotation> getQualifierAnnotations() {
        return Collections.unmodifiableSet(this.qualifiers);
    }

    public synchronized void addQualifierAnnotation(Annotation addMe) {
        if (addMe == null) {
            return;
        }
        this.qualifiers.add(addMe);
        this.addQualifier(addMe.annotationType().getName());
    }

    public synchronized boolean removeQualifierAnnotation(Annotation removeMe) {
        if (removeMe == null) {
            return false;
        }
        boolean retVal = this.qualifiers.remove(removeMe);
        this.removeQualifier(removeMe.annotationType().getName());
        return retVal;
    }

    @Override
    public synchronized List<Injectee> getInjectees() {
        return Collections.emptyList();
    }

    @Override
    public synchronized void dispose(T instance) {
    }
}

