/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import org.glassfish.tyrus.core.ReflectionHelper;
import org.glassfish.tyrus.core.ServiceConfigurationError;
import org.glassfish.tyrus.core.ServiceFinder;
import org.glassfish.tyrus.core.l10n.LocalizationMessages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.SynchronousBundleListener;

public final class OsgiRegistry
implements SynchronousBundleListener {
    private static final String CoreBundleSymbolicNAME = "org.glassfish.jersey.core.jersey-common";
    private static final Logger LOGGER = Logger.getLogger(OsgiRegistry.class.getName());
    private final BundleContext bundleContext;
    private final Map<Long, Map<String, Callable<List<Class<?>>>>> factories = new HashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static OsgiRegistry instance;
    private Map<String, Bundle> classToBundleMapping = new HashMap<String, Bundle>();

    public static synchronized OsgiRegistry getInstance() {
        BundleContext context;
        ClassLoader classLoader;
        if (instance == null && (classLoader = ReflectionHelper.class.getClassLoader()) instanceof BundleReference && (context = FrameworkUtil.getBundle(OsgiRegistry.class).getBundleContext()) != null) {
            instance = new OsgiRegistry(context);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32) {
            this.register(event.getBundle());
        } else if (event.getType() == 64 || event.getType() == 16) {
            Bundle unregisteredBundle = event.getBundle();
            this.lock.writeLock().lock();
            try {
                this.factories.remove(unregisteredBundle.getBundleId());
                if (unregisteredBundle.getSymbolicName().equals(CoreBundleSymbolicNAME)) {
                    this.bundleContext.removeBundleListener((BundleListener)this);
                    this.factories.clear();
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<URL> getPackageResources(String packagePath, ClassLoader classLoader) {
        LinkedList<URL> result = new LinkedList<URL>();
        this.classToBundleMapping.clear();
        for (Bundle bundle : this.bundleContext.getBundles()) {
            for (String bundlePackagePath : new String[]{packagePath, "WEB-INF/classes/" + packagePath}) {
                Enumeration enumeration = bundle.findEntries(bundlePackagePath, "*", false);
                if (enumeration == null) continue;
                while (enumeration.hasMoreElements()) {
                    URL url = (URL)enumeration.nextElement();
                    String path = url.getPath();
                    String className = (packagePath + path.substring(path.lastIndexOf(47))).replace('/', '.').replace(".class", "");
                    this.classToBundleMapping.put(className, bundle);
                    result.add(url);
                }
            }
            Enumeration jars = bundle.findEntries("/", "*.jar", true);
            if (jars == null) continue;
            while (jars.hasMoreElements()) {
                ZipInputStream jarInputStream = null;
                try {
                    JarEntry jarEntry;
                    InputStream inputStream = classLoader.getResourceAsStream(((URL)jars.nextElement()).getPath());
                    jarInputStream = new JarInputStream(inputStream);
                    while ((jarEntry = ((JarInputStream)jarInputStream).getNextJarEntry()) != null) {
                        String jarEntryName = jarEntry.getName();
                        if (!jarEntryName.endsWith(".class") || !jarEntryName.contains(packagePath)) continue;
                        this.classToBundleMapping.put(jarEntryName.replace(".class", "").replace('/', '.'), bundle);
                        result.add(bundle.getResource(jarEntryName));
                    }
                }
                catch (Exception exception) {}
                continue;
                finally {
                    if (jarInputStream == null) continue;
                    try {
                        jarInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return Collections.enumeration(result);
    }

    public Class<?> classForNameWithException(String className) throws ClassNotFoundException {
        Bundle bundle = this.classToBundleMapping.get(className);
        if (bundle == null) {
            throw new ClassNotFoundException(className);
        }
        return bundle.loadClass(className);
    }

    public ResourceBundle getResourceBundle(String bundleName) {
        int lastDotIndex = bundleName.lastIndexOf(46);
        String path = bundleName.substring(0, lastDotIndex).replace('.', '/');
        String propertiesName = bundleName.substring(lastDotIndex + 1, bundleName.length()) + ".properties";
        for (Bundle bundle : this.bundleContext.getBundles()) {
            Enumeration entries = bundle.findEntries(path, propertiesName, false);
            if (entries == null || !entries.hasMoreElements()) continue;
            URL entryUrl = (URL)entries.nextElement();
            try {
                return new PropertyResourceBundle(entryUrl.openStream());
            }
            catch (IOException ex) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Exception caught when tried to load resource bundle in OSGi");
                }
                return null;
            }
        }
        return null;
    }

    private OsgiRegistry(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void hookUp() {
        this.setOSGiServiceFinderIteratorProvider();
        this.bundleContext.addBundleListener((BundleListener)this);
        this.registerExistingBundles();
    }

    private void registerExistingBundles() {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32 && bundle.getState() != 16) continue;
            this.register(bundle);
        }
    }

    private void setOSGiServiceFinderIteratorProvider() {
        ServiceFinder.setIteratorProvider(new OsgiServiceFinder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(Bundle bundle) {
        Map<String, Callable<List<Class<?>>>> map;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "checking bundle {0}", bundle.getBundleId());
        }
        this.lock.writeLock().lock();
        try {
            map = this.factories.get(bundle.getBundleId());
            if (map == null) {
                map = new ConcurrentHashMap();
                this.factories.put(bundle.getBundleId(), map);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        Enumeration e = bundle.findEntries("META-INF/services/", "*", false);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL u = (URL)e.nextElement();
                String url = u.toString();
                if (url.endsWith("/")) continue;
                String factoryId = url.substring(url.lastIndexOf("/") + 1);
                try {
                    map.put(factoryId, new BundleSpiProvidersLoader(factoryId, u.toURI(), bundle));
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Class<?>> locateAllProviders(String serviceName) {
        this.lock.readLock().lock();
        try {
            LinkedList result = new LinkedList();
            for (Map<String, Callable<List<Class<?>>>> value : this.factories.values()) {
                if (!value.containsKey(serviceName)) continue;
                try {
                    result.addAll((Collection)value.get(serviceName).call());
                }
                catch (Exception exception) {}
            }
            LinkedList linkedList = result;
            return linkedList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static class BundleSpiProvidersLoader
    implements Callable<List<Class<?>>> {
        private final String spi;
        private final URI spiRegistryUri;
        private final Bundle bundle;

        BundleSpiProvidersLoader(String spi, URI spiRegistryUri, Bundle bundle) {
            this.spi = spi;
            this.spiRegistryUri = spiRegistryUri;
            this.bundle = bundle;
        }

        @Override
        public List<Class<?>> call() throws Exception {
            try {
                String providerClassName;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Loading providers for SPI: {0}", this.spi);
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(this.spiRegistryUri.toURL().openStream(), "UTF-8"));
                ArrayList providerClasses = new ArrayList();
                while ((providerClassName = br.readLine()) != null) {
                    if (providerClassName.trim().length() == 0) continue;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "SPI provider: {0}", providerClassName);
                    }
                    providerClasses.add(this.bundle.loadClass(providerClassName));
                }
                br.close();
                return providerClasses;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, LocalizationMessages.EXCEPTION_CAUGHT_WHILE_LOADING_SPI_PROVIDERS(), e);
                throw e;
            }
            catch (Error e) {
                LOGGER.log(Level.WARNING, LocalizationMessages.ERROR_CAUGHT_WHILE_LOADING_SPI_PROVIDERS(), e);
                throw e;
            }
        }

        public String toString() {
            return this.spiRegistryUri.toString();
        }

        public int hashCode() {
            return this.spiRegistryUri.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof BundleSpiProvidersLoader) {
                return this.spiRegistryUri.equals(((BundleSpiProvidersLoader)obj).spiRegistryUri);
            }
            return false;
        }
    }

    private final class OsgiServiceFinder
    extends ServiceFinder.ServiceIteratorProvider {
        final ServiceFinder.ServiceIteratorProvider defaultIterator = new ServiceFinder.DefaultServiceIteratorProvider();

        private OsgiServiceFinder() {
        }

        @Override
        public <T> Iterator<T> createIterator(final Class<T> serviceClass, final String serviceName, ClassLoader loader, boolean ignoreOnClassNotFound) {
            final List providerClasses = OsgiRegistry.this.locateAllProviders(serviceName);
            if (!providerClasses.isEmpty()) {
                return new Iterator<T>(){
                    Iterator<Class<?>> it;
                    {
                        this.it = providerClasses.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public T next() {
                        Class<?> nextClass = this.it.next();
                        try {
                            return nextClass.newInstance();
                        }
                        catch (Exception ex) {
                            ServiceConfigurationError sce = new ServiceConfigurationError(serviceName + ": " + LocalizationMessages.PROVIDER_COULD_NOT_BE_CREATED(nextClass.getName(), serviceClass, ex.getLocalizedMessage()));
                            sce.initCause(ex);
                            throw sce;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            return this.defaultIterator.createIterator(serviceClass, serviceName, loader, ignoreOnClassNotFound);
        }

        @Override
        public <T> Iterator<Class<T>> createClassIterator(Class<T> service, String serviceName, ClassLoader loader, boolean ignoreOnClassNotFound) {
            final List providerClasses = OsgiRegistry.this.locateAllProviders(serviceName);
            if (!providerClasses.isEmpty()) {
                return new Iterator<Class<T>>(){
                    Iterator<Class<?>> it;
                    {
                        this.it = providerClasses.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Class<T> next() {
                        return this.it.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            return this.defaultIterator.createClassIterator(service, serviceName, loader, ignoreOnClassNotFound);
        }
    }
}

