/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.CollectionsModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.CollectionsModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.deque.DequeIterBuiltins;
import com.oracle.graal.python.builtins.objects.deque.PDeque;
import com.oracle.graal.python.builtins.objects.deque.PDequeIter;
import com.oracle.graal.python.builtins.objects.dict.PDefaultDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(defineModule="_collections")
public final class CollectionsModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CollectionsModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="_tuplegetter", parameterNames={"cls", "index", "doc"}, constructsClass=PythonBuiltinClassType.PTupleGetter)
    @ArgumentClinic(name="index", conversion=ArgumentClinic.ClinicConversion.Index)
    @GenerateNodeFactory
    static abstract class TupleGetterNode
    extends PythonTernaryClinicBuiltinNode {
        TupleGetterNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CollectionsModuleBuiltinsClinicProviders.TupleGetterNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object construct(Object cls, int index, Object doc, @Cached PythonObjectFactory factory) {
            return factory.createTupleGetter(cls, index, doc);
        }
    }

    @Builtin(name="defaultdict", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.PDefaultDict, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    static abstract class DefaultDictNode
    extends PythonVarargsBuiltinNode {
        DefaultDictNode() {
        }

        @Specialization
        PDefaultDict doGeneric(Object cls, Object[] args, PKeyword[] kwargs, @Cached PythonObjectFactory factory) {
            return factory.createDefaultDict(cls);
        }
    }

    @Builtin(name="_deque_reverse_iterator", constructsClass=PythonBuiltinClassType.PDequeRevIter, minNumOfPositionalArgs=2, parameterNames={"$self", "iterable", "index"})
    @GenerateNodeFactory
    static abstract class DequeRevIterNode
    extends PythonTernaryBuiltinNode {
        DequeRevIterNode() {
        }

        @Specialization
        static PDequeIter doGeneric(VirtualFrame frame, Object cls, Object deque, Object indexObj, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile dequeProfile, @Cached InlinedConditionProfile indexNoneProfile, @Cached PyNumberIndexNode toIndexNode, @Cached CastToJavaIntExactNode castToJavaIntExactNode, @Cached DequeIterBuiltins.DequeIterNextNode getNextNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (!dequeProfile.profile(inliningTarget, deque instanceof PDeque)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_OBJ_TYPE_S_GOT_P, BuiltinNames.T_DEQUE, deque);
            }
            PDequeIter dequeIter = factory.createDequeRevIter((PDeque)deque);
            if (indexNoneProfile.profile(inliningTarget, indexObj != PNone.NO_VALUE)) {
                int index = castToJavaIntExactNode.execute(inliningTarget, toIndexNode.execute((Frame)frame, inliningTarget, indexObj));
                for (int i = 0; i < index; ++i) {
                    getNextNode.execute(dequeIter);
                }
            }
            return dequeIter;
        }
    }

    @Builtin(name="_deque_iterator", constructsClass=PythonBuiltinClassType.PDequeIter, minNumOfPositionalArgs=2, parameterNames={"$self", "iterable", "index"})
    @GenerateNodeFactory
    static abstract class DequeIterNode
    extends PythonTernaryBuiltinNode {
        DequeIterNode() {
        }

        @Specialization
        static PDequeIter doGeneric(VirtualFrame frame, Object cls, Object deque, Object indexObj, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile dequeProfile, @Cached InlinedConditionProfile indexNoneProfile, @Cached PyNumberIndexNode toIndexNode, @Cached CastToJavaIntExactNode castToJavaIntExactNode, @Cached DequeIterBuiltins.DequeIterNextNode getNextNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (!dequeProfile.profile(inliningTarget, deque instanceof PDeque)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_OBJ_TYPE_S_GOT_P, BuiltinNames.T_DEQUE, deque);
            }
            PDequeIter dequeIter = factory.createDequeIter((PDeque)deque);
            if (indexNoneProfile.profile(inliningTarget, indexObj != PNone.NO_VALUE)) {
                int index = castToJavaIntExactNode.execute(inliningTarget, toIndexNode.execute((Frame)frame, inliningTarget, indexObj));
                for (int i = 0; i < index; ++i) {
                    getNextNode.execute(dequeIter);
                }
            }
            return dequeIter;
        }
    }

    @Builtin(name="deque", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.PDeque, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    static abstract class DequeNode
    extends PythonVarargsBuiltinNode {
        DequeNode() {
        }

        @Override
        public Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            if (arguments.length >= 1) {
                return this.doGeneric(arguments[0], null, null);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported.INSTANCE;
        }

        @Specialization
        PDeque doGeneric(Object cls, Object[] args, PKeyword[] kwargs) {
            return this.factory().createDeque(cls);
        }
    }
}

