/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.modules.PwdModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.PwdModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.tuple.StructSequence;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;
import java.util.List;

@CoreFunctions(defineModule="pwd")
public final class PwdModuleBuiltins
extends PythonBuiltins {
    private static final TruffleString T_NOT_AVAILABLE = PythonUtils.tsLiteral("NOT_AVAILABLE");
    static final StructSequence.BuiltinTypeDescriptor STRUCT_PASSWD_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PStructPasswd, "pwd.struct_passwd: Results from getpw*() routines.\n\nThis object may be accessed either as a tuple of\n  (pw_name,pw_passwd,pw_uid,pw_gid,pw_gecos,pw_dir,pw_shell)\nor via the object attributes as named in the above tuple.", 7, new String[]{"pw_name", "pw_passwd", "pw_uid", "pw_gid", "pw_gecos", "pw_dir", "pw_shell"}, new String[]{"user name", "password", "user id", "group id", "real name", "home directory", "shell program"});

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        PosixSupportLibrary posixLib = PosixSupportLibrary.getUncached();
        boolean hasGetpwentries = posixLib.hasGetpwentries(PythonContext.get(null).getPosixSupport());
        if (hasGetpwentries) {
            return PwdModuleBuiltinsFactory.getFactories();
        }
        assert (PwdModuleBuiltinsFactory.getFactories().size() == 3);
        return Arrays.asList(PwdModuleBuiltinsFactory.GetpwuidNodeFactory.getInstance(), PwdModuleBuiltinsFactory.GetpwnamNodeFactory.getInstance());
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        StructSequence.initType(core, STRUCT_PASSWD_DESC);
    }

    private static Object[] createPwuidObject(Node inliningTarget, PosixSupportLibrary.PwdResult pwd, PythonObjectFactory factory, InlinedConditionProfile unsignedConversionProfile) {
        return new Object[]{pwd.name, T_NOT_AVAILABLE, PInt.createPythonIntFromUnsignedLong(inliningTarget, factory, unsignedConversionProfile, pwd.uid), PInt.createPythonIntFromUnsignedLong(inliningTarget, factory, unsignedConversionProfile, pwd.gid), StringLiterals.T_EMPTY_STRING, pwd.dir, pwd.shell};
    }

    @Builtin(name="getpwall")
    @GenerateNodeFactory
    public static abstract class GetpwallNode
    extends PythonBuiltinNode {
        @Specialization
        Object doGetpall(VirtualFrame frame, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile unsignedConversionProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            PosixSupportLibrary.PwdResult[] entries;
            try {
                entries = posixLib.getpwentries(this.getPosixSupport());
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            Object[] result = new Object[entries.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = factory.createStructSeq(STRUCT_PASSWD_DESC, PwdModuleBuiltins.createPwuidObject(inliningTarget, entries[i], factory, unsignedConversionProfile));
            }
            return factory.createList(result);
        }
    }

    @Builtin(name="getpwnam", minNumOfPositionalArgs=1, parameterNames={"name"})
    @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    public static abstract class GetpwnamNode
    extends PythonUnaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PwdModuleBuiltinsClinicProviders.GetpwnamNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object doGetpwname(VirtualFrame frame, TruffleString name, @Bind(value="this") Node inliningTarget, @Cached GilNode gil, @Cached PosixModuleBuiltins.StringOrBytesToOpaquePathNode encodeFSDefault, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile unsignedConversionProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            PosixSupportLibrary.PwdResult pwd;
            Object nameEncoded = encodeFSDefault.execute(inliningTarget, name);
            try {
                gil.release(true);
                PythonContext context = PythonContext.get(inliningTarget);
                try {
                    pwd = posixLib.getpwnam(context.getPosixSupport(), nameEncoded);
                }
                finally {
                    gil.acquire(context);
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            if (pwd == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.KeyError, ErrorMessages.GETPWNAM_NAME_NOT_FOUND, name);
            }
            return factory.createStructSeq(STRUCT_PASSWD_DESC, PwdModuleBuiltins.createPwuidObject(inliningTarget, pwd, factory, unsignedConversionProfile));
        }
    }

    @Builtin(name="getpwuid", minNumOfPositionalArgs=1, parameterNames={"uid"})
    @GenerateNodeFactory
    public static abstract class GetpwuidNode
    extends PythonUnaryBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object doGetpwuid(VirtualFrame frame, Object uidObj, @Bind(value="this") Node inliningTarget, @Cached PosixModuleBuiltins.UidConversionNode uidConversionNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile classProfile, @Cached GilNode gil, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile unsignedConversionProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            PosixSupportLibrary.PwdResult pwd;
            long uid;
            try {
                uid = uidConversionNode.executeLong(frame, uidObj);
            }
            catch (PException ex) {
                if (classProfile.profileException(inliningTarget, ex, PythonBuiltinClassType.OverflowError)) {
                    throw GetpwuidNode.raiseUidNotFound(raiseNode.get(inliningTarget));
                }
                throw ex;
            }
            try {
                PythonContext context = PythonContext.get(inliningTarget);
                gil.release(true);
                try {
                    pwd = posixLib.getpwuid(context.getPosixSupport(), uid);
                }
                finally {
                    gil.acquire(context);
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            if (pwd == null) {
                throw GetpwuidNode.raiseUidNotFound(raiseNode.get(inliningTarget));
            }
            return factory.createStructSeq(STRUCT_PASSWD_DESC, PwdModuleBuiltins.createPwuidObject(inliningTarget, pwd, factory, unsignedConversionProfile));
        }

        private static PException raiseUidNotFound(PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.KeyError, ErrorMessages.GETPWUID_NOT_FOUND);
        }
    }
}

