/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CArgObjectBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CFieldBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.PyCArgObject;
import com.oracle.graal.python.builtins.modules.ctypes.PyCFuncPtrBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.PyCFuncPtrObject;
import com.oracle.graal.python.builtins.modules.ctypes.PyCPointerTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.memory.Pointer;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodes;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerReference;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.LoadCExtException;
import com.oracle.graal.python.builtins.objects.cext.hpy.jni.GraalHPyJNIContext;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToPythonObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;

@CoreFunctions(defineModule="_ctypes")
public final class CtypesModuleBuiltins
extends PythonBuiltins {
    private static final TruffleString T_DL_ERROR = PythonUtils.tsLiteral("dlerror");
    private static final TruffleString T_DL_OPEN_ERROR = PythonUtils.tsLiteral("dlopen() error");
    private static final TruffleString T_WINDOWS_ERROR = PythonUtils.tsLiteral("Windows Error");
    private static final String J_DEFAULT_LIBRARY = PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? "msvcrt.dll" : "";
    private DLHandler rtldDefault;
    private Object dyldSharedCacheContainsPathFunction;
    protected static final int FUNCFLAG_STDCALL = 0;
    protected static final int FUNCFLAG_CDECL = 1;
    protected static final int FUNCFLAG_HRESULT = 2;
    protected static final int FUNCFLAG_PYTHONAPI = 4;
    protected static final int FUNCFLAG_USE_ERRNO = 8;
    protected static final int FUNCFLAG_USE_LASTERROR = 16;
    protected static final int TYPEFLAG_ISPOINTER = 256;
    protected static final int TYPEFLAG_HASPOINTER = 512;
    protected static final int TYPEFLAG_HASUNION = 1024;
    protected static final int TYPEFLAG_HASBITFIELD = 2048;
    protected static final String J_UNPICKLE = "_unpickle";
    protected static final TruffleString T_UNPICKLE = PythonUtils.tsLiteral("_unpickle");
    private static final TruffleString T_PLACEHOLDER_D_COMMA = PythonUtils.tsLiteral("%d,");
    private static final TruffleString T_PLACEHOLDER_D_RPAREN = PythonUtils.tsLiteral("%d)");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CtypesModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant("_pointer_type_cache", (Object)core.factory().createDict());
        if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32) {
            this.addBuiltinConstant("FUNCFLAG_STDCALL", (Object)0);
        }
        this.addBuiltinConstant("FUNCFLAG_CDECL", (Object)1);
        this.addBuiltinConstant("FUNCFLAG_USE_ERRNO", (Object)8);
        this.addBuiltinConstant("FUNCFLAG_USE_LASTERROR", (Object)16);
        this.addBuiltinConstant("FUNCFLAG_PYTHONAPI", (Object)4);
        this.addBuiltinConstant("__version__", (Object)"1.1.0");
        this.addBuiltinConstant("CFuncPtr", (Object)core.lookupType(PythonBuiltinClassType.PyCFuncPtr));
        this.addBuiltinConstant("ArgumentError", (Object)core.lookupType(PythonBuiltinClassType.ArgError));
        this.addBuiltinConstant("CTYPES_MAX_ARGCOUNT", (Object)1024);
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonObjectSlowPathFactory factory = core.factory();
        PythonModule ctypesModule = core.lookupBuiltinModule(BuiltinNames.T__CTYPES);
        ctypesModule.setAttribute(PythonUtils.tsLiteral("_string_at_addr"), factory.createNativeVoidPtr(StringAtFunction.create()));
        ctypesModule.setAttribute(PythonUtils.tsLiteral("_cast_addr"), factory.createNativeVoidPtr(CastFunction.create()));
        ctypesModule.setAttribute(PythonUtils.tsLiteral("_wstring_at_addr"), factory.createNativeVoidPtr(WStringAtFunction.create()));
        int rtldLocal = PosixConstants.RTLD_LOCAL.getValueIfDefined();
        ctypesModule.setAttribute(PythonUtils.tsLiteral("RTLD_LOCAL"), rtldLocal);
        ctypesModule.setAttribute(PythonUtils.tsLiteral("RTLD_GLOBAL"), PosixConstants.RTLD_GLOBAL.getValueIfDefined());
        PythonContext context = core.getContext();
        DLHandler handle = null;
        if (context.getEnv().isNativeAccessAllowed()) {
            handle = DlOpenNode.loadNFILibrary(context, NFIBackend.NATIVE, J_DEFAULT_LIBRARY, rtldLocal);
            if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32) {
                PythonModule sysModule = context.getSysModule();
                Object loadLibraryMethod = ReadAttributeFromObjectNode.getUncached().execute(ctypesModule, PythonUtils.toTruffleStringUncached("LoadLibrary"));
                Object pythonLib = CallNode.executeUncached(loadLibraryMethod, PythonUtils.toTruffleStringUncached(GraalHPyJNIContext.getJNILibrary()), 0);
                WriteAttributeToPythonObjectNode.getUncached().execute(sysModule, PythonUtils.toTruffleStringUncached("dllhandle"), pythonLib);
            }
        } else if (!((Boolean)PythonOptions.NativeModules.getValue(context.getEnv().getOptions())).booleanValue()) {
            try {
                Object llvmLibrary = CApiContext.ensureCApiLLVMLibrary(context);
                handle = new DLHandler(llvmLibrary, 0L, "", true);
            }
            catch (LoadCExtException.ApiInitException e) {
                throw e.reraise(null, null, PConstructAndRaiseNode.Lazy.getUncached());
            }
            catch (LoadCExtException.ImportException e) {
                throw e.reraise(null, null, PConstructAndRaiseNode.Lazy.getUncached());
            }
            catch (IOException e) {
                throw PConstructAndRaiseNode.getUncached().raiseOSError(null, e, TruffleString.EqualNode.getUncached());
            }
        }
        if (handle != null) {
            NativeFunction memmove = MemMoveFunction.create(handle, context);
            ctypesModule.setAttribute(PythonUtils.tsLiteral("_memmove_addr"), factory.createNativeVoidPtr(memmove, memmove.adr));
            NativeFunction memset = MemSetFunction.create(handle, context);
            ctypesModule.setAttribute(PythonUtils.tsLiteral("_memset_addr"), factory.createNativeVoidPtr(memset, memset.adr));
        }
        this.rtldDefault = handle;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object createNFIHelperFunction(PythonContext context, DLHandler h, String name, String signature) throws UnsupportedMessageException, UnknownIdentifierException {
        Object symbol = InteropLibrary.getUncached().readMember(h.library, name);
        Source source = Source.newBuilder((String)"nfi", (CharSequence)signature, (String)name).build();
        Object nfiSignature = context.getEnv().parseInternal(source, new String[0]).call(new Object[0]);
        return SignatureLibrary.getUncached().bind(nfiSignature, symbol);
    }

    @CompilerDirectives.TruffleBoundary
    protected static void registerAddress(PythonContext context, long adr, Object o) {
        context.getCtypesAdrMap().put(adr, o);
    }

    @CompilerDirectives.TruffleBoundary
    protected static Object getObjectAtAddress(PythonContext context, long adr) {
        return context.getCtypesAdrMap().get(adr);
    }

    protected static Object getObjectAt(PythonContext context, Object ptr) {
        if (PGuards.isInteger(ptr)) {
            return CtypesModuleBuiltins.getObjectAtAddress(context, (Long)ptr);
        }
        return ptr;
    }

    static TruffleString _ctypes_alloc_format_string_with_shape(int ndim, int[] shape, TruffleString prefix, TruffleString suffix, TruffleStringBuilder.AppendStringNode appendStringNode, TruffleStringBuilder.ToStringNode toStringNode, StringUtils.SimpleTruffleStringFormatNode formatNode) {
        TruffleStringBuilder buf = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
        if (prefix != null) {
            appendStringNode.execute(buf, (AbstractTruffleString)prefix);
        }
        if (ndim > 0) {
            appendStringNode.execute(buf, (AbstractTruffleString)StringLiterals.T_LPAREN);
            TruffleString fmt = T_PLACEHOLDER_D_COMMA;
            for (int k = 0; k < ndim; ++k) {
                if (k == ndim - 1) {
                    fmt = T_PLACEHOLDER_D_RPAREN;
                }
                appendStringNode.execute(buf, (AbstractTruffleString)formatNode.format(fmt, shape[k]));
            }
        }
        if (suffix != null) {
            appendStringNode.execute(buf, (AbstractTruffleString)suffix);
        }
        return toStringNode.execute(buf);
    }

    @ExportLibrary(value=InteropLibrary.class)
    protected static class StringAtFunction
    implements TruffleObject {
        protected StringAtFunction() {
        }

        protected static NativeFunction create() {
            StringAtFunction f = new StringAtFunction();
            return new NativeFunction(f, PyObjectHashNode.executeUncached(f), NativeCAPISymbol.FUN_STRING_AT.getName(), true);
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        Object execute(Object[] arguments, @Cached StringAtFunctionNode stringAtFunctionNode) {
            return stringAtFunctionNode.execute(arguments[0], arguments[1]);
        }
    }

    @ExportLibrary(value=InteropLibrary.class, delegateTo="sym")
    protected static final class NativeFunction
    implements TruffleObject {
        final Object sym;
        final long adr;
        final String name;
        Object function;
        TruffleString signature;
        FFIType[] atypes;
        FFIType rtype;
        final boolean isManaged;

        NativeFunction(Object sym, long adr, String name, boolean isManaged) {
            this.sym = sym;
            this.adr = adr;
            this.name = name;
            this.function = null;
            this.signature = null;
            this.isManaged = isManaged;
        }

        protected boolean isManaged() {
            return this.isManaged;
        }

        protected boolean isLLVM() {
            return this.sym instanceof CallLLVMFunction;
        }

        protected boolean isManaged(long address) {
            return this.adr == address;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    protected static class CastFunction
    implements TruffleObject {
        protected CastFunction() {
        }

        protected static NativeFunction create() {
            CastFunction f = new CastFunction();
            return new NativeFunction(f, PyObjectHashNode.executeUncached(f), NativeCAPISymbol.FUN_CAST.getName(), true);
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        Object execute(Object[] arguments, @Cached CastFunctionNode castFunctionNode) {
            return castFunctionNode.execute(arguments[0], arguments[1], arguments[2]);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    protected static class WStringAtFunction
    implements TruffleObject {
        protected WStringAtFunction() {
        }

        protected static NativeFunction create() {
            WStringAtFunction f = new WStringAtFunction();
            return new NativeFunction(f, PyObjectHashNode.executeUncached(f), NativeCAPISymbol.FUN_WSTRING_AT.getName(), true);
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        Object execute(Object[] arguments, @Cached WStringAtFunctionNode wStringAtFunctionNode) {
            return wStringAtFunctionNode.execute(arguments[0], arguments[1]);
        }
    }

    static enum NFIBackend {
        NATIVE(StringLiterals.T_EMPTY_STRING),
        LLVM(PythonUtils.tsLiteral("with llvm "));

        private final TruffleString withClause;

        private NFIBackend(TruffleString withClause) {
            this.withClause = withClause;
        }
    }

    @Builtins(value={@Builtin(name="LoadLibrary", minNumOfPositionalArgs=1, parameterNames={"$self", "name", "mode"}, declaresExplicitSelf=true, os=PythonOS.PLATFORM_WIN32), @Builtin(name="dlopen", minNumOfPositionalArgs=1, parameterNames={"$self", "name", "mode"}, declaresExplicitSelf=true)})
    @ArgumentsClinic(value={@ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_EMPTY_STRING", useDefaultForNone=true), @ArgumentClinic(name="mode", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="Integer.MIN_VALUE", useDefaultForNone=true)})
    @GenerateNodeFactory
    protected static abstract class DlOpenNode
    extends PythonTernaryClinicBuiltinNode {
        private static final TruffleString MACOS_Security_LIB = PythonUtils.tsLiteral("/System/Library/Frameworks/Security.framework/Security");
        private static final TruffleString MACOS_CoreFoundation_LIB = PythonUtils.tsLiteral("/System/Library/Frameworks/CoreFoundation.framework/CoreFoundation");
        private static final String T_RTLD_LOCAL = "RTLD_LOCAL|RTLD_NOW";
        private static final String T_RTLD_GLOBAL = "RTLD_GLOBAL|RTLD_NOW";
        private static final TruffleLogger LOGGER = PythonLanguage.getLogger(DlOpenNode.class);

        protected DlOpenNode() {
        }

        protected static String flagsToString(int flag) {
            return (flag & PosixConstants.RTLD_LOCAL.getValueIfDefined()) != 0 ? T_RTLD_LOCAL : T_RTLD_GLOBAL;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CtypesModuleBuiltinsClinicProviders.DlOpenNodeClinicProviderGen.INSTANCE;
        }

        @CompilerDirectives.TruffleBoundary
        protected static DLHandler loadNFILibrary(PythonContext context, NFIBackend backendType, String name, int flags) {
            String src = !name.isEmpty() ? String.format("%sload (%s) \"%s\"", backendType.withClause, DlOpenNode.flagsToString(flags), name) : "default";
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Loading native library %s %s", name, backendType.withClause));
            }
            Object handler = DlOpenNode.load(context, src, name);
            InteropLibrary lib = InteropLibrary.getUncached();
            try {
                return new DLHandler(handler, lib.asPointer(handler), name, false);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((String)"Cannot convert NFI library to pointer", (Throwable)e);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static Object load(PythonContext context, String src, String name) {
            Source loadSrc = Source.newBuilder((String)"nfi", (CharSequence)src, (String)("load:" + name)).internal(true).build();
            return context.getEnv().parseInternal(loadSrc, new String[0]).call(new Object[0]);
        }

        @CompilerDirectives.TruffleBoundary
        protected static Object loadLLVMLibrary(PythonContext context, Node nodeForRaise, TruffleString path) throws LoadCExtException.ImportException, LoadCExtException.ApiInitException, IOException {
            context.ensureLLVMLanguage(nodeForRaise);
            if (path.isEmpty()) {
                return CApiContext.ensureCApiLLVMLibrary(context);
            }
            Source loadSrc = Source.newBuilder((String)"llvm", (TruffleFile)context.getPublicTruffleFileRelaxed(path, new TruffleString[0])).build();
            return context.getEnv().parseInternal(loadSrc, new String[0]).call(new Object[0]);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString getErrMsg(Exception e) {
            String errmsg;
            String string = errmsg = e != null ? e.getMessage() : null;
            if (errmsg == null || errmsg.isEmpty()) {
                return T_DL_OPEN_ERROR;
            }
            return PythonUtils.toTruffleStringUncached(errmsg);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static Object py_dl_open(PythonModule self, TruffleString name, int m, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode) {
            PythonContext context = PythonContext.get(inliningTarget);
            PythonObjectSlowPathFactory factory = context.factory();
            auditNode.audit(inliningTarget, "ctypes.dlopen", name);
            if (name.isEmpty()) {
                return factory.createNativeVoidPtr(((CtypesModuleBuiltins)self.getBuiltins()).rtldDefault);
            }
            CApiContext.ensureCapiWasLoaded("support ctypes module");
            int mode = m != Integer.MIN_VALUE ? m : PosixConstants.RTLD_LOCAL.getValueIfDefined();
            mode |= PosixConstants.RTLD_NOW.getValueIfDefined();
            Exception exception = null;
            try {
                if (!context.getEnv().isNativeAccessAllowed() && !((Boolean)PythonOptions.NativeModules.getValue(context.getEnv().getOptions())).booleanValue()) {
                    Object handler = DlOpenNode.loadLLVMLibrary(context, inliningTarget, name);
                    long adr = PyObjectHashNode.executeUncached(handler);
                    DLHandler handle = new DLHandler(handler, adr, name.toJavaStringUncached(), true);
                    CtypesModuleBuiltins.registerAddress(context, handle.adr, handle);
                    return factory.createNativeVoidPtr(handle);
                }
                if (context.getEnv().isNativeAccessAllowed()) {
                    CtypesThreadState ctypes = CtypesThreadState.get(context, PythonLanguage.get(inliningTarget));
                    TruffleString.EqualNode eqNode = TruffleString.EqualNode.getUncached();
                    if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)MACOS_Security_LIB, PythonUtils.TS_ENCODING) && !eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)MACOS_CoreFoundation_LIB, PythonUtils.TS_ENCODING)) {
                        DLHandler handle = DlOpenNode.loadNFILibrary(context, ctypes.backendType, name.toJavaStringUncached(), mode);
                        CtypesModuleBuiltins.registerAddress(context, handle.adr, handle);
                        return factory.createNativeVoidPtr(handle, handle.adr);
                    }
                }
            }
            catch (Exception e) {
                exception = e;
            }
            throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.OSError, DlOpenNode.getErrMsg(exception));
        }
    }

    @ExportLibrary(value=InteropLibrary.class, delegateTo="library")
    protected static final class DLHandler
    implements TruffleObject {
        final Object library;
        final String name;
        final long adr;
        final boolean isManaged;
        boolean isClosed;

        private DLHandler(Object library, long adr, String name, boolean isManaged) {
            this.library = library;
            this.adr = adr;
            this.name = name;
            this.isManaged = isManaged;
            this.isClosed = false;
        }

        public Object getLibrary() {
            return this.library;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    protected static class MemMoveFunction
    implements TruffleObject {
        final Object nativeMemmove;

        MemMoveFunction(Object nativeMemmove) {
            this.nativeMemmove = nativeMemmove;
        }

        protected static NativeFunction create(DLHandler handle, PythonContext context) {
            MemMoveFunction f;
            long adr;
            String name = NativeCAPISymbol.FUN_MEMMOVE.getName();
            try {
                Object sym = InteropLibrary.getUncached().readMember(handle.library, name);
                adr = InteropLibrary.getUncached().asPointer(sym);
                f = new MemMoveFunction(sym);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                f = new MemMoveFunction(null);
                adr = PyObjectHashNode.executeUncached(f);
            }
            NativeFunction func = new NativeFunction(f, adr, name, true);
            CtypesModuleBuiltins.registerAddress(context, adr, func);
            return func;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        static class Execute {
            Execute() {
            }

            @Specialization
            static Object managed(MemMoveFunction self, Object[] arguments, @Bind(value="$node") Node inliningTarget, @Cached MemmoveNode memmoveNode) {
                return memmoveNode.execute(inliningTarget, arguments[0], arguments[1], arguments[2]);
            }
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    protected static class MemSetFunction
    implements TruffleObject {
        final Object nativeMemset;

        MemSetFunction(Object nativeMemset) {
            this.nativeMemset = nativeMemset;
        }

        protected static NativeFunction create(DLHandler handle, PythonContext context) {
            MemSetFunction f;
            long adr;
            String name = NativeCAPISymbol.FUN_MEMSET.getName();
            try {
                Object sym = InteropLibrary.getUncached().readMember(handle.library, name);
                adr = InteropLibrary.getUncached().asPointer(sym);
                f = new MemSetFunction(sym);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                f = new MemSetFunction(null);
                adr = PyObjectHashNode.executeUncached(f);
            }
            NativeFunction func = new NativeFunction(f, adr, name, true);
            CtypesModuleBuiltins.registerAddress(context, adr, func);
            return func;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        static class Execute {
            Execute() {
            }

            @Specialization
            static Object managed(MemSetFunction self, Object[] arguments, @Bind(value="$node") Node inliningTarget, @Cached MemsetNode memsetNode) {
                return memsetNode.execute(inliningTarget, arguments[0], arguments[1], arguments[2]);
            }
        }
    }

    @GenerateUncached
    protected static abstract class WStringAtFunctionNode
    extends Node {
        protected WStringAtFunctionNode() {
        }

        abstract Object execute(Object var1, Object var2);

        @Specialization
        static TruffleString wstring_at(Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PointerNodes.ReadBytesNode read, @Cached PointerNodes.WCsLenNode wCsLenNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            auditNode.audit(inliningTarget, "ctypes.wstring_at", factory.createNativeVoidPtr(ptr), size);
            if (size == -1) {
                size = wCsLenNode.execute(inliningTarget, ptr);
            }
            byte[] bytes = read.execute(inliningTarget, ptr, size * CtypesNodes.WCHAR_T_SIZE);
            TruffleString s = fromByteArrayNode.execute(bytes, CtypesNodes.WCHAR_T_ENCODING);
            return switchEncodingNode.execute((AbstractTruffleString)s, PythonUtils.TS_ENCODING);
        }
    }

    @GenerateUncached
    protected static abstract class StringAtFunctionNode
    extends Node {
        protected StringAtFunctionNode() {
        }

        abstract Object execute(Object var1, Object var2);

        @Specialization
        static Object string_at(Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory, @Cached PointerNodes.ReadBytesNode read, @Cached PointerNodes.StrLenNode strLenNode, @Cached SysModuleBuiltins.AuditNode auditNode) {
            auditNode.audit(inliningTarget, "ctypes.string_at", factory.createNativeVoidPtr(ptr), size);
            if (size == -1) {
                size = strLenNode.execute(inliningTarget, ptr);
            }
            return factory.createBytes(read.execute(inliningTarget, ptr, size));
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    protected static abstract class MemsetNode
    extends Node {
        protected MemsetNode() {
        }

        abstract Object execute(Node var1, Object var2, Object var3, Object var4);

        @Specialization
        static Object memset(Node inliningTarget, Pointer ptr, int value, long size, @Cached PointerNodes.WriteLongNode writeLongNode, @Cached PointerNodes.WriteByteNode writeByteNode, @Cached(inline=false) PythonObjectFactory factory) {
            int i;
            byte b = (byte)value;
            long fill = 0L;
            for (i = 0; i < 64; i += 8) {
                fill |= (long)b << i;
            }
            i = 0;
            while ((long)i < size / 8L * 8L) {
                writeLongNode.execute(inliningTarget, ptr.withOffset(i), fill);
                i += 8;
            }
            while ((long)i < size) {
                writeByteNode.execute(inliningTarget, ptr.withOffset(i), b);
                ++i;
            }
            return factory.createNativeVoidPtr(ptr);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    protected static abstract class MemmoveNode
    extends Node {
        protected MemmoveNode() {
        }

        abstract Object execute(Node var1, Object var2, Object var3, Object var4);

        @Specialization
        static Object memmove(Node inliningTarget, Pointer destPtr, Pointer srcPtr, long size, @Cached PointerNodes.MemcpyNode memcpyNode, @Cached(inline=false) PythonObjectFactory factory) {
            memcpyNode.execute(inliningTarget, destPtr, srcPtr, (int)size);
            return factory.createNativeVoidPtr(destPtr);
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    protected static abstract class CastFunctionNode
    extends Node {
        protected CastFunctionNode() {
        }

        abstract Object execute(Object var1, Object var2, Object var3);

        @Specialization
        Object cast(Pointer ptr, Pointer srcObj, Pointer ctypeObj, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached PythonObjectFactory factory, @Cached CallNode callNode, @Cached CastCheckPtrTypeNode castCheckPtrTypeNode, @Cached PointerNodes.ReadPythonObject readPythonObject, @Cached PointerNodes.WritePointerNode writePointerNode) {
            CDataObject cdata;
            Object src = readPythonObject.execute(inliningTarget, srcObj);
            Object ctype = readPythonObject.execute(inliningTarget, ctypeObj);
            castCheckPtrTypeNode.execute(inliningTarget, ctype);
            CDataObject result = (CDataObject)callNode.executeWithoutFrame(ctype, new Object[0]);
            if (src instanceof CDataObject && pyTypeCheck.isCDataObject(inliningTarget, cdata = (CDataObject)src)) {
                CDataTypeBuiltins.PyCData_GetContainer(cdata, factory);
                if (cdata.b_objects == null) {
                    cdata.b_objects = factory.createDict();
                }
                result.b_objects = cdata.b_objects;
                if (PGuards.isDict(result.b_objects)) {
                    PDict dict = (PDict)result.b_objects;
                    PythonNativeVoidPtr index = factory.createNativeVoidPtr(cdata);
                    dict.setDictStorage(setItem.execute(null, inliningTarget, dict.getDictStorage(), index, cdata));
                }
            }
            writePointerNode.execute(inliningTarget, result.b_ptr, ptr);
            return result;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class CastCheckPtrTypeNode
    extends Node {
        private static final char[] sPzUZXO = "sPzUZXO".toCharArray();

        CastCheckPtrTypeNode() {
        }

        abstract void execute(Node var1, Object var2);

        protected static boolean isPtrTypeObject(Node inliningTarget, Object arg, CtypesNodes.PyTypeCheck pyTypeCheck) {
            return pyTypeCheck.isPyCPointerTypeObject(inliningTarget, arg) || pyTypeCheck.isPyCFuncPtrTypeObject(inliningTarget, arg);
        }

        @Specialization(guards={"isPtrTypeObject(inliningTarget, arg, pyTypeCheck)"}, limit="1")
        static void fastCheck(Node inliningTarget, Object arg, @Cached.Exclusive @Cached CtypesNodes.PyTypeCheck pyTypeCheck) {
        }

        @Specialization(replaces={"fastCheck"})
        static void fullcheck(Node inliningTarget, Object arg, @Cached.Exclusive @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached(inline=false) FailedCastCheckNode failedCastCheckNode, @Cached(inline=false) TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
            int code;
            if (CastCheckPtrTypeNode.isPtrTypeObject(inliningTarget, arg, pyTypeCheck)) {
                return;
            }
            StgDictObject dict = pyTypeStgDictNode.execute(inliningTarget, arg);
            if (dict != null && dict.proto != null && PGuards.isTruffleString(dict.proto) && PyCFuncPtrBuiltins.PyCFuncPtrFromDllNode.strchr(sPzUZXO, code = codePointAtIndexNode.execute((AbstractTruffleString)((TruffleString)dict.proto), 0, PythonUtils.TS_ENCODING))) {
                return;
            }
            failedCastCheckNode.execute(arg);
        }
    }

    @GenerateUncached
    static abstract class FailedCastCheckNode
    extends Node {
        FailedCastCheckNode() {
        }

        abstract void execute(Object var1);

        @Specialization
        static void raiseError(Object arg, @Cached PRaiseNode raiseNode, @Cached TypeNodes.IsTypeNode isTypeNode, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached TypeNodes.GetNameNode getNameNode) {
            Object clazz = isTypeNode.execute(inliningTarget, arg) ? arg : getClassNode.execute(inliningTarget, arg);
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CAST_ARGUMENT_2_MUST_BE_A_POINTER_TYPE_NOT_S, getNameNode.execute(inliningTarget, clazz));
        }
    }

    @ExportLibrary(value=InteropLibrary.class, delegateTo="llvmSym")
    protected static final class CallLLVMFunction
    implements TruffleObject {
        final Object llvmSym;

        private CallLLVMFunction(Object llvmSym) {
            this.llvmSym = llvmSym;
        }

        protected static Object create(Object sym, InteropLibrary lib) {
            if (lib.isExecutable(sym)) {
                return new CallLLVMFunction(sym);
            }
            return sym;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        Object execute(Object[] arguments, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @CachedLibrary(value="this.llvmSym") InteropLibrary ilib) {
            try {
                for (int i = 0; i < arguments.length; ++i) {
                    if (!(arguments[i] instanceof TruffleString)) continue;
                    arguments[i] = toJavaStringNode.execute((AbstractTruffleString)((TruffleString)arguments[i]));
                }
                return ilib.execute(this.llvmSym, arguments);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw PRaiseNode.getUncached().raise(PythonErrorType.RuntimeError, (Exception)e);
            }
        }
    }

    @Builtin(name="Py_DECREF", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class PyDECREFNode
    extends PythonUnaryBuiltinNode {
        protected PyDECREFNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object doGeneric(Object arg) {
            CApiContext.ensureCapiWasLoaded("support ctypes module");
            Object nativePointer = CApiTransitions.PythonToNativeNode.executeUncached(arg);
            CExtNodes.XDecRefPointerNode.executeUncached(nativePointer);
            return arg;
        }
    }

    @Builtin(name="Py_INCREF", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class PyINCREFNode
    extends PythonUnaryBuiltinNode {
        protected PyINCREFNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object doGeneric(Object arg) {
            CApiContext.ensureCapiWasLoaded("support ctypes module");
            CApiTransitions.PythonToNativeNewRefNode.executeUncached(arg);
            return arg;
        }
    }

    @Builtin(name="PyObj_FromPtr", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class PyObjFromPtrNode
    extends PythonUnaryBuiltinNode {
        protected PyObjFromPtrNode() {
        }

        static Object converter(Object obj) {
            return obj;
        }

        @Specialization
        static Object doit(Object obj, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode) {
            Object ob = PyObjFromPtrNode.converter(obj);
            auditNode.audit(inliningTarget, "ctypes.PyObj_FromPtr", "(O)", ob);
            return ob;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={FFIType.FFI_TYPES.class, BackendMode.class})
    static abstract class ConvertParameterToBackendValueNode
    extends Node {
        ConvertParameterToBackendValueNode() {
        }

        public abstract Object execute(Node var1, CTypesCallArgument var2, BackendMode var3);

        @Specialization(guards={"isFFIType(arg, FFI_TYPE_SINT8) || isFFIType(arg, FFI_TYPE_UINT8)"})
        static byte doByte(Node inliningTarget, CTypesCallArgument arg, BackendMode mode, @Cached PointerNodes.ReadByteNode readByteNode) {
            return readByteNode.execute(inliningTarget, arg.valuePointer);
        }

        @Specialization(guards={"isFFIType(arg, FFI_TYPE_SINT16) || isFFIType(arg, FFI_TYPE_UINT16)"})
        static short doShort(Node inliningTarget, CTypesCallArgument arg, BackendMode mode, @Cached PointerNodes.ReadShortNode readShortNode) {
            return readShortNode.execute(inliningTarget, arg.valuePointer);
        }

        @Specialization(guards={"isFFIType(arg, FFI_TYPE_SINT32) || isFFIType(arg, FFI_TYPE_UINT32)"})
        static int doInt(Node inliningTarget, CTypesCallArgument arg, BackendMode mode, @Cached.Shared @Cached PointerNodes.ReadIntNode readIntNode) {
            return readIntNode.execute(inliningTarget, arg.valuePointer);
        }

        @Specialization(guards={"isFFIType(arg, FFI_TYPE_SINT64) || isFFIType(arg, FFI_TYPE_UINT64)"})
        static long doLong(Node inliningTarget, CTypesCallArgument arg, BackendMode mode, @Cached.Shared @Cached PointerNodes.ReadLongNode readLongNode) {
            return readLongNode.execute(inliningTarget, arg.valuePointer);
        }

        @Specialization(guards={"isFFIType(arg, FFI_TYPE_FLOAT)"})
        static float doFloat(Node inliningTarget, CTypesCallArgument arg, BackendMode mode, @Cached.Shared @Cached PointerNodes.ReadIntNode readIntNode) {
            return Float.intBitsToFloat(readIntNode.execute(inliningTarget, arg.valuePointer));
        }

        @Specialization(guards={"isFFIType(arg, FFI_TYPE_DOUBLE)"})
        static double doDouble(Node inliningTarget, CTypesCallArgument arg, BackendMode mode, @Cached.Shared @Cached PointerNodes.ReadLongNode readLongNode) {
            return Double.longBitsToDouble(readLongNode.execute(inliningTarget, arg.valuePointer));
        }

        @Specialization(guards={"mode == NFI", "isFFIType(arg, FFI_TYPE_POINTER)"})
        static Object doNFIPointer(Node inliningTarget, CTypesCallArgument arg, BackendMode mode, @Cached.Shared @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached.Shared @Cached PointerNodes.GetPointerValueAsObjectNode toNativeNode) {
            Pointer value = readPointerNode.execute(inliningTarget, arg.valuePointer);
            return toNativeNode.execute(inliningTarget, value);
        }

        @Specialization(guards={"mode == LLVM", "isFFIType(arg, FFI_TYPE_POINTER)"})
        static Object doLLVMPointer(Node inliningTarget, CTypesCallArgument arg, BackendMode mode, @Cached.Shared @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached.Shared @Cached PointerNodes.GetPointerValueAsObjectNode toNativeNode) {
            Pointer value = readPointerNode.execute(inliningTarget, arg.valuePointer);
            return toNativeNode.execute(inliningTarget, value);
        }

        @Specialization(guards={"mode == INTRINSIC", "isFFIType(arg, FFI_TYPE_POINTER)"})
        static Object doIntrinsicPointer(Node inliningTarget, CTypesCallArgument arg, BackendMode mode, @Cached.Shared @Cached PointerNodes.ReadPointerNode readPointerNode) {
            return readPointerNode.execute(inliningTarget, arg.valuePointer);
        }

        @Specialization(guards={"mode == NFI", "isFFIType(arg, FFI_TYPE_STRUCT)"})
        static Object doNFIStruct(Node inliningTarget, CTypesCallArgument arg, BackendMode mode, @Cached(inline=false) PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.NotImplementedError, ErrorMessages.PASSING_STRUCTS_BY_VALUE_NOT_SUPPORTED);
        }

        @Specialization(guards={"mode == LLVM", "isFFIType(arg, FFI_TYPE_STRUCT)"})
        static Object doLLVMStruct(Node inliningTarget, CTypesCallArgument arg, BackendMode mode, @Cached PointerNodes.ReadBytesNode readBytesNode) {
            byte[] bytes = new byte[arg.stgDict.size];
            readBytesNode.execute(inliningTarget, bytes, 0, arg.valuePointer, arg.stgDict.size);
            return CDataObject.createWrapper(arg.keep, arg.stgDict, bytes);
        }

        static boolean isFFIType(CTypesCallArgument arg, FFIType.FFI_TYPES expected) {
            return arg.ffi_type.type == expected;
        }
    }

    static enum BackendMode {
        NFI,
        LLVM,
        INTRINSIC;

    }

    protected static abstract class ConvParamNode
    extends Node {
        protected ConvParamNode() {
        }

        final void execute(VirtualFrame frame, Object obj, int index, CTypesCallArgument pa) {
            this.execute(frame, obj, index, pa, true);
        }

        protected abstract void execute(VirtualFrame var1, Object var2, int var3, CTypesCallArgument var4, boolean var5);

        @Specialization
        void convParam(VirtualFrame frame, Object obj, int index, CTypesCallArgument pa, boolean allowRecursion, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached PyLongCheckNode longCheckNode, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached CastToTruffleStringNode toString, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profile, @Cached PyNumberAsSizeNode asInt, @Cached PyObjectLookupAttr lookupAttr, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached CArgObjectBuiltins.ParamFuncNode paramFuncNode, @Cached ConvParamNode recursive, @Cached PRaiseNode.Lazy raiseNode) {
            if (obj instanceof CDataObject) {
                CDataObject cdata = (CDataObject)obj;
                pa.stgDict = pyObjectStgDictNode.execute(inliningTarget, cdata);
                PyCArgObject carg = paramFuncNode.execute(inliningTarget, cdata, pa.stgDict);
                pa.ffi_type = carg.pffi_type;
                pa.valuePointer = carg.valuePointer;
                pa.keep = cdata;
                return;
            }
            if (PGuards.isPyCArg(obj)) {
                PyCArgObject carg = (PyCArgObject)obj;
                pa.stgDict = pyObjectStgDictNode.execute(inliningTarget, carg.obj);
                pa.ffi_type = carg.pffi_type;
                pa.valuePointer = carg.valuePointer;
                pa.keep = carg;
                return;
            }
            if (obj == PNone.NONE) {
                pa.ffi_type = FFIType.ffi_type_pointer;
                pa.valuePointer = Pointer.NULL.createReference();
                return;
            }
            if (longCheckNode.execute(inliningTarget, obj)) {
                pa.ffi_type = FFIType.ffi_type_sint;
                try {
                    pa.valuePointer = Pointer.create(pa.ffi_type, pa.ffi_type.size, asInt.executeExact((Frame)frame, inliningTarget, obj), 0);
                }
                catch (PException e) {
                    e.expectOverflowError(inliningTarget, profile);
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.INT_TOO_LONG_TO_CONVERT);
                }
                return;
            }
            if (obj instanceof PBytes) {
                int len = bufferLib.getBufferLength(obj);
                byte[] bytes = new byte[len + 1];
                bufferLib.readIntoByteArray(obj, 0, bytes, 0, len);
                Pointer valuePtr = Pointer.bytes(bytes);
                pa.ffi_type = FFIType.ffi_type_pointer;
                pa.valuePointer = valuePtr.createReference();
                new PointerReference((Object)pa, valuePtr, PythonContext.get(this).getSharedFinalizer());
                return;
            }
            if (unicodeCheckNode.execute(inliningTarget, obj)) {
                TruffleString string = switchEncodingNode.execute((AbstractTruffleString)toString.execute(inliningTarget, obj), CtypesNodes.WCHAR_T_ENCODING);
                int len = string.byteLength(CtypesNodes.WCHAR_T_ENCODING);
                byte[] bytes = new byte[len + CtypesNodes.WCHAR_T_SIZE];
                copyToByteArrayNode.execute((AbstractTruffleString)string, 0, bytes, 0, len, CtypesNodes.WCHAR_T_ENCODING);
                Pointer valuePtr = Pointer.bytes(bytes);
                pa.ffi_type = FFIType.ffi_type_pointer;
                pa.valuePointer = valuePtr.createReference();
                new PointerReference((Object)pa, valuePtr, PythonContext.get(this).getSharedFinalizer());
                return;
            }
            Object arg = lookupAttr.execute((Frame)frame, inliningTarget, obj, CDataTypeBuiltins.T__AS_PARAMETER_);
            if (arg != null && allowRecursion) {
                recursive.execute(frame, arg, index, pa, false);
                return;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.DON_T_KNOW_HOW_TO_CONVERT_PARAMETER_D, index);
        }
    }

    @ImportStatic(value={PGuards.class})
    static abstract class GetResultNode
    extends Node {
        GetResultNode() {
        }

        abstract Object execute(VirtualFrame var1, Object var2, FFIType var3, Object var4, Object var5);

        @Specialization(guards={"restype == null"}, limit="1")
        static Object asInt(Object restype, FFIType rtype, Object result, Object checker, @CachedLibrary(value="result") InteropLibrary ilib) {
            try {
                return ilib.asInt(result);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        @Specialization(guards={"isNone(restype)"})
        static Object none(Object restype, FFIType rtype, Object result, Object checker) {
            return PNone.NONE;
        }

        @Specialization(guards={"restype != null", "!isNone(restype)", "dict == null"}, limit="1")
        static Object callResType(VirtualFrame frame, Object restype, FFIType rtype, Object result, Object checker, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="result") InteropLibrary ilib, @Cached.Exclusive @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Bind(value="getStgDict(inliningTarget, restype, pyTypeStgDictNode)") StgDictObject dict, @Cached.Shared @Cached CallNode callNode) {
            try {
                return callNode.execute((Frame)frame, restype, ilib.asInt(result));
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        @Specialization(guards={"restype != null", "!isNone(restype)", "dict != null"}, limit="1")
        static Object callGetFunc(VirtualFrame frame, Object restype, FFIType rtype, Object result, Object checker, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="result") InteropLibrary ilib, @Cached.Exclusive @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Bind(value="getStgDict(inliningTarget, restype, pyTypeStgDictNode)") StgDictObject dict, @Cached.Shared @Cached CallNode callNode, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached TypeNodes.GetBaseClassNode getBaseClassNode, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached CFieldBuiltins.GetFuncNode getFuncNode, @Cached CtypesNodes.PyCDataFromBaseObjNode fromBaseObjNode) {
            Pointer resultPtr;
            try {
                resultPtr = switch (rtype.type) {
                    case FFIType.FFI_TYPES.FFI_TYPE_UINT8, FFIType.FFI_TYPES.FFI_TYPE_SINT8 -> Pointer.create(rtype, rtype.size, ilib.asByte(result), 0);
                    case FFIType.FFI_TYPES.FFI_TYPE_UINT16, FFIType.FFI_TYPES.FFI_TYPE_SINT16 -> Pointer.create(rtype, rtype.size, ilib.asShort(result), 0);
                    case FFIType.FFI_TYPES.FFI_TYPE_UINT32, FFIType.FFI_TYPES.FFI_TYPE_SINT32 -> Pointer.create(rtype, rtype.size, ilib.asInt(result), 0);
                    case FFIType.FFI_TYPES.FFI_TYPE_SINT64, FFIType.FFI_TYPES.FFI_TYPE_UINT64 -> Pointer.create(rtype, rtype.size, ilib.asLong(result), 0);
                    case FFIType.FFI_TYPES.FFI_TYPE_FLOAT -> Pointer.create(rtype, rtype.size, Float.valueOf(ilib.asFloat(result)), 0);
                    case FFIType.FFI_TYPES.FFI_TYPE_DOUBLE -> Pointer.create(rtype, rtype.size, ilib.asDouble(result), 0);
                    case FFIType.FFI_TYPES.FFI_TYPE_VOID -> Pointer.NULL;
                    case FFIType.FFI_TYPES.FFI_TYPE_STRUCT -> {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.RETURNING_STRUCT_BY_VALUE_NOT_SUPPORTED);
                    }
                    case FFIType.FFI_TYPES.FFI_TYPE_POINTER -> {
                        Pointer pointer;
                        if (ilib.isNull(result)) {
                            pointer = Pointer.NULL;
                        } else if (ilib.isPointer(result)) {
                            pointer = Pointer.nativeMemory(ilib.asPointer(result));
                        } else if (ilib.fitsInLong(result)) {
                            pointer = Pointer.nativeMemory(ilib.asLong(result));
                        } else if (ilib.hasArrayElements(result)) {
                            int size = (int)ilib.getArraySize(result);
                            byte[] bytes = new byte[size + 1];
                            for (int i = 0; i < size; ++i) {
                                bytes[i] = (Byte)ilib.readArrayElement(result, (long)i);
                            }
                            pointer = Pointer.bytes(bytes);
                        } else {
                            pointer = Pointer.nativeMemory(result);
                        }
                        yield pointer.createReference();
                    }
                    default -> throw CompilerDirectives.shouldNotReachHere();
                };
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            Object retval = dict.getfunc != FFIType.FieldGet.nil && !pyTypeCheck.ctypesSimpleInstance(inliningTarget, restype, getBaseClassNode, isSameTypeNode) ? getFuncNode.execute(dict.getfunc, resultPtr, dict.size) : fromBaseObjNode.execute(inliningTarget, restype, null, 0, resultPtr);
            assert (retval != null) : "Should have raised an error earlier!";
            if (PGuards.isPNone(checker) || checker == null) {
                return retval;
            }
            return callNode.execute((Frame)frame, checker, retval);
        }

        protected static StgDictObject getStgDict(Node inliningTarget, Object restype, StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode) {
            return pyTypeStgDictNode.execute(inliningTarget, restype);
        }
    }

    protected static abstract class CallProcNode
    extends PNodeWithContext {
        protected static final int CTYPES_MAX_ARGCOUNT = 1024;

        protected CallProcNode() {
        }

        abstract Object execute(VirtualFrame var1, NativeFunction var2, Object[] var3, int var4, Object[] var5, Object[] var6, Object var7, Object var8);

        @Specialization
        Object _ctypes_callproc(VirtualFrame frame, NativeFunction pProc, Object[] argarray, int flags, Object[] argtypes, Object[] converters, Object restype, Object checker, @Bind(value="this") Node inliningTarget, @Cached ConvParamNode convParamNode, @Cached ConvertParameterToBackendValueNode convertParameterToBackendValueNode, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached CallNode callNode, @Cached GetResultNode getResultNode, @CachedLibrary(limit="1") InteropLibrary ilib, @Cached PRaiseNode.Lazy raiseNode) {
            Object result;
            StgDictObject dict;
            int argcount = argarray.length;
            if (argcount > 1024) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ArgError, ErrorMessages.TOO_MANY_ARGUMENTS_D_MAXIMUM_IS_D, argcount, 1024);
            }
            CTypesCallArgument[] args = new CTypesCallArgument[argcount];
            Object[] avalues = new Object[argcount];
            FFIType[] atypes = new FFIType[argcount];
            int argtype_count = argtypes != null ? argtypes.length : 0;
            BackendMode mode = BackendMode.NFI;
            if (pProc.isManaged()) {
                mode = pProc.isLLVM() ? BackendMode.LLVM : BackendMode.INTRINSIC;
            }
            for (int i = 0; i < argcount; ++i) {
                FFIType ffiType;
                Object arg;
                args[i] = new CTypesCallArgument();
                Object v = arg = argarray[i];
                if (converters != null && argtype_count > i) {
                    try {
                        v = callNode.execute((Frame)frame, converters[i], arg);
                    }
                    catch (PException e) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ArgError, ErrorMessages.ARGUMENT_D, i + 1);
                    }
                }
                convParamNode.execute(frame, v, i + 1, args[i]);
                atypes[i] = ffiType = args[i].ffi_type;
                if (arg instanceof PyCFuncPtrObject) {
                    atypes[i] = new FFIType(atypes[i], ((PyCFuncPtrObject)arg).thunk);
                }
                avalues[i] = convertParameterToBackendValueNode.execute(inliningTarget, args[i], mode);
            }
            FFIType rtype = FFIType.ffi_type_sint;
            if (restype != null && (dict = pyTypeStgDictNode.execute(inliningTarget, restype)) != null) {
                rtype = dict.ffi_type_pointer;
            }
            if (mode == BackendMode.NFI) {
                result = this.callNativeFunction(inliningTarget, pProc, avalues, atypes, rtype, ilib, raiseNode);
            } else {
                result = CallProcNode.callManagedFunction(inliningTarget, pProc, avalues, ilib, raiseNode);
                if (mode == BackendMode.INTRINSIC) {
                    return result;
                }
            }
            return getResultNode.execute(frame, restype, rtype, result, checker);
        }

        static Object callManagedFunction(Node inliningTarget, NativeFunction pProc, Object[] argarray, InteropLibrary ilib, PRaiseNode.Lazy raiseNode) {
            try {
                return ilib.execute(pProc.sym, argarray);
            }
            catch (PException e) {
                throw e;
            }
            catch (AbstractTruffleException | ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreter();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.RuntimeError, ErrorMessages.FFI_CALL_FAILED);
            }
            catch (UnsupportedSpecializationException ee) {
                CompilerDirectives.transferToInterpreter();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.NotImplementedError, PythonUtils.toTruffleStringUncached("require backend support."));
            }
        }

        @CompilerDirectives.TruffleBoundary
        protected Object getFunction(NativeFunction pProc, String signature) throws Exception {
            Source source = Source.newBuilder((String)"nfi", (CharSequence)signature, (String)pProc.name).build();
            Object nfiSignature = this.getContext().getEnv().parseInternal(source, new String[0]).call(new Object[0]);
            return SignatureLibrary.getUncached().bind(nfiSignature, pProc.sym);
        }

        Object callNativeFunction(Node inliningTarget, NativeFunction pProc, Object[] avalues, FFIType[] atypes, FFIType restype, InteropLibrary ilib, PRaiseNode.Lazy raiseNode) {
            Object function;
            if (pProc.function != null && CallProcNode.equals(atypes, pProc.atypes) && restype == pProc.rtype) {
                function = pProc.function;
            } else {
                TruffleString signature = FFIType.buildNFISignature(atypes, restype);
                try {
                    function = this.getFunction(pProc, signature.toJavaStringUncached());
                }
                catch (Exception e) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.RuntimeError, ErrorMessages.FFI_PREP_CIF_FAILED);
                }
                pProc.atypes = atypes;
                pProc.rtype = restype;
                pProc.function = function;
                pProc.signature = signature;
            }
            try {
                return ilib.execute(function, avalues);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreter();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.RuntimeError, ErrorMessages.FFI_CALL_FAILED);
            }
        }

        private static boolean equals(FFIType[] atypes, FFIType[] atypes2) {
            if (atypes.length != atypes2.length) {
                return false;
            }
            for (int i = 0; i < atypes.length; ++i) {
                if (atypes[i] == atypes2[i]) continue;
                return false;
            }
            return true;
        }
    }

    protected static final class CTypesCallArgument {
        FFIType ffi_type;
        StgDictObject stgDict;
        Pointer valuePointer;
        Object keep;

        protected CTypesCallArgument() {
        }
    }

    @Builtin(name="_check_HRESULT", minNumOfPositionalArgs=1, parameterNames={"hresult"}, os=PythonOS.PLATFORM_WIN32)
    @ArgumentClinic(name="hresult", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    protected static abstract class CheckHresultNode
    extends PythonUnaryClinicBuiltinNode {
        protected CheckHresultNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CtypesModuleBuiltinsClinicProviders.CheckHresultNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object check(VirtualFrame frame, int hresult, @Bind(value="this") Node inliningTarget, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            if (hresult >= 0) {
                return hresult;
            }
            throw constructAndRaiseNode.get(inliningTarget).raiseOSError(frame, hresult, T_WINDOWS_ERROR);
        }
    }

    @Builtin(name="FormatError", minNumOfPositionalArgs=1, os=PythonOS.PLATFORM_WIN32)
    @GenerateNodeFactory
    protected static abstract class FormatErrorNode
    extends PythonUnaryBuiltinNode {
        protected FormatErrorNode() {
        }

        @Specialization
        static Object doit(Object errorCode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.NotImplementedError);
        }
    }

    @Builtin(name="call_cdeclfunction", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    protected static abstract class CallCdeclfunctionNode
    extends PythonBinaryBuiltinNode {
        protected CallCdeclfunctionNode() {
        }

        @Specialization
        static Object call_function(VirtualFrame frame, Object pointerObj, PTuple arguments, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached CallProcNode callProcNode, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached CtypesNodes.HandleFromLongNode handleFromLongNode) {
            NativeFunction func = handleFromLongNode.getNativeFunction(inliningTarget, pointerObj);
            auditNode.audit(inliningTarget, "ctypes.call_function", func, arguments);
            return callProcNode.execute(frame, func, getArray.execute(inliningTarget, arguments.getSequenceStorage()), 1, PythonUtils.EMPTY_OBJECT_ARRAY, PythonUtils.EMPTY_OBJECT_ARRAY, null, null);
        }
    }

    @Builtin(name="addressof", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class AddressOfNode
    extends PythonUnaryBuiltinNode {
        protected AddressOfNode() {
        }

        @Specialization
        static Object doit(CDataObject obj, @Bind(value="this") Node inliningTarget, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (!pyTypeCheck.isCDataObject(inliningTarget, obj)) {
                return AddressOfNode.error(obj, raiseNode.get(inliningTarget));
            }
            auditNode.audit(inliningTarget, "ctypes.addressof", obj);
            return factory.createNativeVoidPtr(obj.b_ptr);
        }

        @Fallback
        static Object error(Object o, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.INVALID_TYPE);
        }
    }

    @Builtin(name="call_function", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    protected static abstract class CallFunctionNode
    extends PythonBinaryBuiltinNode {
        protected CallFunctionNode() {
        }

        @Specialization
        Object call_function(VirtualFrame frame, Object pointerObj, PTuple arguments, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached CallProcNode callProcNode, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached CtypesNodes.HandleFromLongNode handleFromLongNode) {
            NativeFunction func = handleFromLongNode.getNativeFunction(inliningTarget, pointerObj);
            auditNode.audit(inliningTarget, "ctypes.call_function", func, arguments);
            return callProcNode.execute(frame, func, getArray.execute(inliningTarget, arguments.getSequenceStorage()), 0, PythonUtils.EMPTY_OBJECT_ARRAY, PythonUtils.EMPTY_OBJECT_ARRAY, null, null);
        }
    }

    @Builtin(name="byref", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=2, parameterNames={"instance", "offset"})
    @ArgumentClinic(name="offset", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0", useDefaultForNone=true)
    @GenerateNodeFactory
    protected static abstract class ByRefNode
    extends PythonBinaryClinicBuiltinNode {
        protected ByRefNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CtypesModuleBuiltinsClinicProviders.ByRefNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object doit(CDataObject obj, int offset, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (!pyTypeCheck.isCDataObject(inliningTarget, obj)) {
                return ByRefNode.error(null, obj, offset, inliningTarget, getClassNode, raiseNode);
            }
            PyCArgObject parg = factory.createCArgObject();
            parg.tag = (char)80;
            parg.pffi_type = FFIType.ffi_type_pointer;
            parg.obj = obj;
            parg.valuePointer = obj.b_ptr.createReference(offset);
            return parg;
        }

        @Fallback
        static Object error(VirtualFrame frame, Object obj, Object off, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            Object clazz = getClassNode.execute(inliningTarget, obj);
            TruffleString name = TypeNodes.GetNameNode.executeUncached(clazz);
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.BYREF_ARGUMENT_MUST_BE_A_CTYPES_INSTANCE_NOT_S, name);
        }
    }

    @Builtin(name="sizeof", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class SizeOfNode
    extends PythonUnaryBuiltinNode {
        protected SizeOfNode() {
        }

        @Specialization
        static Object doit(Object obj, @Bind(value="this") Node inliningTarget, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached PRaiseNode.Lazy raiseNode) {
            StgDictObject dict = pyTypeStgDictNode.execute(inliningTarget, obj);
            if (dict != null) {
                return dict.size;
            }
            if (pyTypeCheck.isCDataObject(inliningTarget, obj)) {
                return ((CDataObject)obj).b_size;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.THIS_TYPE_HAS_NO_SIZE);
        }
    }

    @Builtin(name="alignment", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class AlignmentNode
    extends PythonUnaryBuiltinNode {
        protected AlignmentNode() {
        }

        @Specialization
        static Object align_func(Object obj, @Bind(value="this") Node inliningTarget, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached PRaiseNode.Lazy raiseNode) {
            StgDictObject dict = pyTypeStgDictNode.execute(inliningTarget, obj);
            if (dict != null) {
                return dict.align;
            }
            dict = pyObjectStgDictNode.execute(inliningTarget, obj);
            if (dict != null) {
                return dict.align;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.NO_ALIGNMENT_INFO);
        }
    }

    @Builtin(name="_dyld_shared_cache_contains_path", parameterNames={"$self", "path"}, declaresExplicitSelf=true)
    @GenerateNodeFactory
    @ArgumentClinic(name="path", conversionClass=PosixModuleBuiltins.FsConverterNode.class)
    protected static abstract class DyldSharedCacheContainsPath
    extends PythonBinaryClinicBuiltinNode {
        private static final String DYLD_SHARED_CACHE_CONTAINS_PATH = "_dyld_shared_cache_contains_path";
        @CompilerDirectives.CompilationFinal
        private static boolean hasDynamicLoaderCacheValue = false;
        @CompilerDirectives.CompilationFinal
        private static boolean hasDynamicLoaderCacheInit = false;

        protected DyldSharedCacheContainsPath() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CtypesModuleBuiltinsClinicProviders.DyldSharedCacheContainsPathClinicProviderGen.INSTANCE;
        }

        private static boolean hasDynamicLoaderCache() {
            if (hasDynamicLoaderCacheInit) {
                return hasDynamicLoaderCacheValue;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (System.getProperty("os.name").contains("Mac")) {
                String osVersion = System.getProperty("os.version");
                int major = 11;
                int i = osVersion.indexOf(46);
                try {
                    major = Integer.parseInt(i < 0 ? osVersion : osVersion.substring(0, i));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                hasDynamicLoaderCacheValue = major >= 11;
            } else {
                hasDynamicLoaderCacheValue = false;
            }
            hasDynamicLoaderCacheInit = true;
            return hasDynamicLoaderCacheValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object doBytes(PythonModule self, PBytes path, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.ToBytesNode toBytesNode, @CachedLibrary(limit="1") InteropLibrary ilib, @CachedLibrary(limit="1") InteropLibrary resultLib, @Cached PRaiseNode.Lazy raiseNode) {
            if (!DyldSharedCacheContainsPath.hasDynamicLoaderCache()) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.NotImplementedError, ErrorMessages.S_SYMBOL_IS_MISSING, DYLD_SHARED_CACHE_CONTAINS_PATH);
            }
            CtypesModuleBuiltins builtins = (CtypesModuleBuiltins)self.getBuiltins();
            Object cachedFunction = builtins.dyldSharedCacheContainsPathFunction;
            if (cachedFunction == null) {
                builtins.dyldSharedCacheContainsPathFunction = cachedFunction = DyldSharedCacheContainsPath.initializeDyldSharedCacheContainsPathFunction(PythonContext.get(inliningTarget), builtins);
            }
            if (!ilib.isNull(cachedFunction)) {
                Boolean bl;
                CArrayWrappers.CByteArrayWrapper byteArrayWrapper = new CArrayWrappers.CByteArrayWrapper(toBytesNode.execute(path));
                try {
                    Object result = ilib.execute(cachedFunction, new Object[]{byteArrayWrapper});
                    bl = resultLib.asInt(result) != 0;
                }
                catch (Throwable throwable) {
                    try {
                        byteArrayWrapper.free();
                        throw throwable;
                    }
                    catch (InteropException interopException) {
                        // empty catch block
                    }
                }
                byteArrayWrapper.free();
                return bl;
            }
            return false;
        }

        @CompilerDirectives.TruffleBoundary
        private static Object initializeDyldSharedCacheContainsPathFunction(PythonContext context, CtypesModuleBuiltins builtins) {
            try {
                if (context.getEnv().isNativeAccessAllowed()) {
                    return CtypesModuleBuiltins.createNFIHelperFunction(context, builtins.rtldDefault, DYLD_SHARED_CACHE_CONTAINS_PATH, "(POINTER):SINT8");
                }
                InteropLibrary lib = InteropLibrary.getUncached((Object)builtins.rtldDefault.library);
                if (lib.isMemberReadable(builtins.rtldDefault.library, DYLD_SHARED_CACHE_CONTAINS_PATH)) {
                    return lib.readMember(builtins.rtldDefault.library, DYLD_SHARED_CACHE_CONTAINS_PATH);
                }
            }
            catch (InteropException interopException) {
                // empty catch block
            }
            return context.getNativeNull();
        }
    }

    @Builtin(name="dlsym", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    protected static abstract class DlSymNode
    extends PythonBinaryBuiltinNode {
        protected DlSymNode() {
        }

        @Specialization
        static Object py_dl_sym(VirtualFrame frame, Object obj, Object name, @Bind(value="this") Node inliningTarget, @Cached PointerNodes.PointerFromLongNode pointerFromLongNode, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached CtypesDlSymNode dlSymNode) {
            auditNode.audit(inliningTarget, "ctypes.dlsym/handle", obj, name);
            return dlSymNode.execute(frame, pointerFromLongNode.execute(inliningTarget, obj), name, PythonErrorType.OSError);
        }
    }

    protected static abstract class CtypesDlSymNode
    extends PNodeWithContext {
        protected CtypesDlSymNode() {
        }

        protected abstract Object execute(VirtualFrame var1, Pointer var2, Object var3, PythonBuiltinClassType var4);

        @Specialization
        static Object ctypes_dlsym(VirtualFrame frame, Pointer handlePtr, Object n, PythonBuiltinClassType error, @Bind(value="this") Node inliningTarget, @Cached CtypesNodes.HandleFromPointerNode handleFromPointerNode, @Cached PyObjectHashNode hashNode, @Cached CastToJavaStringNode asString, @CachedLibrary(limit="1") InteropLibrary ilib, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            DLHandler handle = handleFromPointerNode.getDLHandler(inliningTarget, handlePtr);
            String name = asString.execute(n);
            if (handle == null || handle.isClosed) {
                throw raiseNode.get(inliningTarget).raise(error, T_DL_ERROR);
            }
            try {
                Object sym = ilib.readMember(handle.library, name);
                boolean isManaged = handle.isManaged;
                long adr = isManaged ? hashNode.execute((Frame)frame, inliningTarget, sym) : ilib.asPointer(sym);
                sym = isManaged ? CallLLVMFunction.create(sym, ilib) : sym;
                NativeFunction func = new NativeFunction(sym, adr, name, isManaged);
                CtypesModuleBuiltins.registerAddress(PythonContext.get(inliningTarget), adr, func);
                if (!isManaged) {
                    return factory.createNativeVoidPtr(func, adr);
                }
                return factory.createNativeVoidPtr(func);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                throw raiseNode.get(inliningTarget).raise(error, (Exception)e);
            }
        }
    }

    @Builtin(name="dlclose", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class DlCloseNode
    extends PythonUnaryBuiltinNode {
        protected DlCloseNode() {
        }

        @Specialization
        static Object py_dl_close(Object pointerObj, @Bind(value="this") Node inliningTarget, @Cached CtypesNodes.HandleFromLongNode handleFromLongNode, @Cached PRaiseNode.Lazy raiseNode) {
            DLHandler handle = handleFromLongNode.getDLHandler(inliningTarget, pointerObj);
            if (handle != null) {
                handle.isClosed = true;
                return PNone.NONE;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.OSError, T_DL_ERROR);
        }
    }

    @Builtin(name="resize", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"obj", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    protected static abstract class ResizeNode
    extends PythonBinaryClinicBuiltinNode {
        protected ResizeNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CtypesModuleBuiltinsClinicProviders.ResizeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object resize(CDataObject obj, int size, @Bind(value="this") Node inliningTarget, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached PRaiseNode.Lazy raiseNode) {
            StgDictObject dict = pyObjectStgDictNode.execute(inliningTarget, obj);
            if (dict == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.EXCEPTED_CTYPES_INSTANCE);
            }
            if (size < dict.size) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.MINIMUM_SIZE_IS_D, dict.size);
            }
            if (obj.b_needsfree) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.MEMORY_CANNOT_BE_RESIZED_BECAUSE_THIS_OBJECT_DOESN_T_OWN_IT);
            }
            obj.b_size = size;
            return PNone.NONE;
        }
    }

    @Builtin(name="buffer_info", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class BufferInfoNode
    extends PythonUnaryBuiltinNode {
        protected BufferInfoNode() {
        }

        @Specialization
        static Object buffer_info(Object arg, @Bind(value="this") Node inliningTarget, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            StgDictObject dict = pyTypeStgDictNode.execute(inliningTarget, arg);
            if (dict == null) {
                dict = pyObjectStgDictNode.execute(inliningTarget, arg);
            }
            if (dict == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.NOT_A_CTYPES_TYPE_OR_OBJECT);
            }
            Object[] shape = new Object[dict.ndim];
            for (int i = 0; i < dict.ndim; ++i) {
                shape[i] = dict.shape[i];
            }
            return factory.createTuple(new Object[]{dict.format, dict.ndim, factory.createTuple(shape)});
        }
    }

    @Builtin(name="_unpickle", minNumOfPositionalArgs=2)
    @ImportStatic(value={SpecialMethodNames.class})
    @GenerateNodeFactory
    protected static abstract class UnpickleNode
    extends PythonBinaryBuiltinNode {
        protected UnpickleNode() {
        }

        @Specialization
        Object unpickle(VirtualFrame frame, Object typ, PTuple state, @Cached CallNode callNode, @Cached(value="create(New)") LookupAndCallUnaryNode lookupAndCallUnaryNode, @Cached(value="create(T___SETSTATE__)") GetAttributeNode setStateAttr) {
            Object obj = lookupAndCallUnaryNode.executeObject(frame, typ);
            Object meth = setStateAttr.executeObject(frame, obj);
            callNode.execute((Frame)frame, meth, state);
            return obj;
        }
    }

    @Builtin(name="pointer", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class PointerObjectNode
    extends PythonUnaryBuiltinNode {
        protected PointerObjectNode() {
        }

        @Specialization
        Object pointer(VirtualFrame frame, Object arg, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached PointerTypeNode callPOINTER, @Cached CallNode callNode, @Cached GetClassNode getClassNode) {
            CtypesThreadState ctypes = CtypesThreadState.get(this.getContext(), this.getLanguage());
            Object typ = getItem.execute((Frame)frame, inliningTarget, ctypes.ptrtype_cache, getClassNode.execute(inliningTarget, arg));
            if (typ != null) {
                return callNode.execute((Frame)frame, typ, arg);
            }
            typ = callPOINTER.execute(frame, getClassNode.execute(inliningTarget, arg));
            return callNode.execute((Frame)frame, typ, arg);
        }
    }

    @Builtin(name="POINTER", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class PointerTypeNode
    extends PythonUnaryBuiltinNode {
        protected PointerTypeNode() {
        }

        @Specialization
        static Object POINTER(VirtualFrame frame, Object cls, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached CallNode callNode, @Cached TypeNodes.GetNameNode getNameNode, @Cached CastToTruffleStringNode toTruffleStringNode, @Cached StringUtils.SimpleTruffleStringFormatNode formatNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            Object key;
            CtypesThreadState ctypes = CtypesThreadState.get(PythonContext.get(inliningTarget), PythonLanguage.get(inliningTarget));
            Object result = getItem.execute((Frame)frame, inliningTarget, ctypes.ptrtype_cache, cls);
            if (result != null) {
                return result;
            }
            if (PGuards.isString(cls)) {
                TruffleString name = toTruffleStringNode.execute(inliningTarget, cls);
                TruffleString buf = formatNode.format("LP_%s", name);
                Object[] args = new Object[]{buf, PythonBuiltinClassType.PyCPointer, factory.createDict()};
                result = callNode.execute((Frame)frame, (Object)PythonBuiltinClassType.PyCPointerType, args, PKeyword.EMPTY_KEYWORDS);
                key = factory.createNativeVoidPtr(result);
            } else if (isTypeNode.execute(inliningTarget, cls)) {
                TruffleString buf = formatNode.format("LP_%s", getNameNode.execute(inliningTarget, cls));
                PTuple bases = factory.createTuple(new Object[]{PythonBuiltinClassType.PyCPointer});
                Object[] args = new Object[]{buf, bases, factory.createDict(new PKeyword[]{new PKeyword(PyCPointerTypeBuiltins.T__TYPE_, cls)})};
                result = callNode.execute((Frame)frame, (Object)PythonBuiltinClassType.PyCPointerType, args, PKeyword.EMPTY_KEYWORDS);
                key = cls;
            } else {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.MUST_BE_A_CTYPES_TYPE);
            }
            HashingStorage newStorage = setItem.execute((Frame)frame, inliningTarget, ctypes.ptrtype_cache, key, result);
            assert (newStorage == ctypes.ptrtype_cache);
            return result;
        }
    }

    @Builtins(value={@Builtin(name="set_last_error", minNumOfPositionalArgs=1, parameterNames={"errno"}, os=PythonOS.PLATFORM_WIN32), @Builtin(name="set_errno", minNumOfPositionalArgs=1, parameterNames={"errno"})})
    @ArgumentClinic(name="errno", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    protected static abstract class SetErrnoNode
    extends PythonUnaryClinicBuiltinNode {
        protected SetErrnoNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CtypesModuleBuiltinsClinicProviders.SetErrnoNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object setErrno(int newErrno, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode) {
            auditNode.audit(inliningTarget, "ctypes.set_errno", newErrno);
            return SetErrnoNode.set_errno(newErrno, this.getContext(), this.getLanguage());
        }

        static Object set_errno(int newErrno, PythonContext context, PythonLanguage language) {
            CtypesThreadState ctypes = CtypesThreadState.get(context, language);
            int oldErrno = ctypes.errno;
            ctypes.errno = newErrno;
            return oldErrno;
        }
    }

    @Builtins(value={@Builtin(name="get_last_error", maxNumOfPositionalArgs=1, declaresExplicitSelf=true, os=PythonOS.PLATFORM_WIN32), @Builtin(name="get_errno", maxNumOfPositionalArgs=1, declaresExplicitSelf=true)})
    @GenerateNodeFactory
    protected static abstract class GetErrnoNode
    extends PythonUnaryBuiltinNode {
        protected GetErrnoNode() {
        }

        @Specialization
        Object getErrno(PythonModule module, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode) {
            auditNode.audit(inliningTarget, "ctypes.get_errno", new Object[0]);
            return GetErrnoNode.get_errno(this.getContext(), this.getLanguage());
        }

        static Object get_errno(PythonContext context, PythonLanguage language) {
            CtypesThreadState ctypes = CtypesThreadState.get(context, language);
            return ctypes.errno;
        }
    }

    public static final class CtypesThreadState {
        int errno = 0;
        NFIBackend backendType;
        EconomicMapStorage ptrtype_cache = EconomicMapStorage.create();
        EconomicMapStorage cache = EconomicMapStorage.create();

        public CtypesThreadState() {
            this.backendType = NFIBackend.NATIVE;
        }

        @CompilerDirectives.TruffleBoundary
        static CtypesThreadState initCtypesThreadState(PythonContext context, PythonLanguage language) {
            CtypesThreadState ctypes = new CtypesThreadState();
            context.getThreadState(language).setCtypes(ctypes);
            return ctypes;
        }

        static CtypesThreadState get(PythonContext context, PythonLanguage language) {
            CtypesThreadState ctypes = context.getThreadState(language).getCtypes();
            if (ctypes == null) {
                ctypes = CtypesThreadState.initCtypesThreadState(context, language);
            }
            return ctypes;
        }
    }
}

