/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.io.AbstractBufferedIOBuiltins;
import com.oracle.graal.python.builtins.modules.io.IOBaseDictBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PIOBase, PythonBuiltinClassType.PFileIO, PythonBuiltinClassType.PStringIO, PythonBuiltinClassType.PTextIOWrapper, PythonBuiltinClassType.PBytesIO, PythonBuiltinClassType.PBufferedReader, PythonBuiltinClassType.PBufferedWriter, PythonBuiltinClassType.PBufferedRandom, PythonBuiltinClassType.PBufferedRWPair})
public final class IOBaseDictBuiltins
extends AbstractBufferedIOBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return IOBaseDictBuiltinsFactory.getFactories();
    }

    @Builtin(name="__dict__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class DictNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        static Object doit(PythonObject self, PNone none, @Bind(value="this") Node inliningTarget, @Cached GetOrCreateDictNode getDict) {
            return getDict.execute(inliningTarget, self);
        }

        @Specialization
        static Object setDict(PythonObject self, Object d, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.AssertionError, ErrorMessages.ATTR_DICT_IS_NOT_WRITABLE, self);
        }
    }
}

